/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.PrinterMark;
import com.intellij.execution.ui.ConsoleViewContentType;
import org.jetbrains.annotations.NotNull;

public class DeferingPrinter
implements Printer {
    private CompositePrintable myCompositePrintable = new CompositePrintable();

    @Override
    public void print(final String text2, final ConsoleViewContentType contentType) {
        this.myCompositePrintable.addLast(new Printable(){

            @Override
            public void printOn(Printer printer2) {
                printer2.print(text2, contentType);
            }
        });
    }

    @Override
    public void onNewAvailable(@NotNull Printable printable) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/DeferingPrinter", "onNewAvailable"));
        }
        this.myCompositePrintable.addLast(printable);
    }

    @Override
    public void printHyperlink(String text2, HyperlinkInfo info) {
        this.myCompositePrintable.addLast(new HyperLink(text2, info));
    }

    @Override
    public void mark() {
        this.myCompositePrintable.addLast(new PrinterMark());
    }

    public void printAndForget(Printer printer2) {
        this.myCompositePrintable.printOn(printer2);
        this.myCompositePrintable.clear();
    }
}

