/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.FailedTestsNavigator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.execution.testframework.ToggleModelActionProvider;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.execution.testframework.actions.TestTreeExpander;
import com.intellij.execution.testframework.autotest.AdjustAutotestDelayActionGroup;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.DumbAwareToggleInvertedBooleanProperty;
import com.intellij.util.config.ToggleBooleanProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ToolbarPanel
extends JPanel
implements OccurenceNavigator,
Disposable {
    protected final TestTreeExpander myTreeExpander = new TestTreeExpander();
    protected final FailedTestsNavigator myOccurenceNavigator;
    protected final ScrollToTestSourceAction myScrollToSource;
    @Nullable
    private ExportTestResultsAction myExportAction;
    private final ArrayList<ToggleModelAction> myActions = new ArrayList();

    public ToolbarPanel(TestConsoleProperties properties, JComponent parent) {
        super(new BorderLayout());
        AnAction importAction;
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        actionGroup.addAction((AnAction)new DumbAwareToggleInvertedBooleanProperty(ExecutionBundle.message((String)"junit.run.hide.passed.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.run.hide.passed.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.TestPassed, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.HIDE_PASSED_TESTS));
        actionGroup.add((AnAction)new DumbAwareToggleInvertedBooleanProperty("Show Ignored", "Show Ignored", AllIcons.RunConfigurations.TestIgnored, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.HIDE_IGNORED_TEST));
        actionGroup.addSeparator();
        actionGroup.addAction((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.sort.alphabetically.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.sort.alphabetically.action.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SORT_ALPHABETICALLY));
        SortByDurationAction sortByStatistics = new SortByDurationAction(properties);
        this.myActions.add(sortByStatistics);
        actionGroup.addAction((AnAction)sortByStatistics);
        actionGroup.addSeparator();
        AnAction action2 = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)this.myTreeExpander, parent);
        action2.getTemplatePresentation().setDescription(ExecutionBundle.message((String)"junit.runing.info.expand.test.action.name", (Object[])new Object[0]));
        actionGroup.add(action2);
        action2 = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, parent);
        action2.getTemplatePresentation().setDescription(ExecutionBundle.message((String)"junit.runing.info.collapse.test.action.name", (Object[])new Object[0]));
        actionGroup.add(action2);
        actionGroup.addSeparator();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        this.myOccurenceNavigator = new FailedTestsNavigator();
        actionGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        actionGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        for (ToggleModelActionProvider actionProvider : (ToggleModelActionProvider[])Extensions.getExtensions(ToggleModelActionProvider.EP_NAME)) {
            ToggleModelAction toggleModelAction = actionProvider.createToggleModelAction(properties);
            this.myActions.add(toggleModelAction);
            actionGroup.add((AnAction)toggleModelAction);
        }
        RunProfile configuration = properties.getConfiguration();
        if (configuration instanceof RunConfiguration) {
            this.myExportAction = ExportTestResultsAction.create(properties.getExecutor().getToolWindowId(), (RunConfiguration)configuration);
            actionGroup.addAction((AnAction)this.myExportAction);
        }
        if ((importAction = properties.createImportAction()) != null) {
            actionGroup.addAction(importAction);
        }
        DefaultActionGroup secondaryGroup = new DefaultActionGroup();
        secondaryGroup.setPopup(true);
        secondaryGroup.getTemplatePresentation().setIcon(AllIcons.General.SecondaryGroup);
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.track.test.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.track.test.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.TRACK_RUNNING_TEST));
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty("Show Inline Statistics", "Toggle the visibility of the test duration in the tree", null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SHOW_INLINE_STATISTICS));
        secondaryGroup.addSeparator();
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.scroll.to.stacktrace.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.scroll.to.stacktrace.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SCROLL_TO_STACK_TRACE));
        secondaryGroup.add((AnAction)new ToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.open.source.at.exception.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.open.source.at.exception.action.description", (Object[])new Object[0]), null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.OPEN_FAILURE_LINE));
        this.myScrollToSource = new ScrollToTestSourceAction(properties);
        secondaryGroup.add((AnAction)this.myScrollToSource);
        secondaryGroup.add((AnAction)new AdjustAutotestDelayActionGroup(parent));
        secondaryGroup.addSeparator();
        secondaryGroup.add((AnAction)new DumbAwareToggleBooleanProperty(ExecutionBundle.message((String)"junit.runing.info.select.first.failed.action.name", (Object[])new Object[0]), null, null, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SELECT_FIRST_DEFECT));
        properties.appendAdditionalActions(secondaryGroup, parent, properties);
        actionGroup.add((AnAction)secondaryGroup);
        this.add((Component)ActionManager.getInstance().createActionToolbar("TestTreeViewToolbar", (ActionGroup)actionGroup, true).getComponent(), "Center");
    }

    public void setModel(final TestFrameworkRunningModel model2) {
        TestFrameworkActions.installFilterAction(model2);
        this.myScrollToSource.setModel(model2);
        this.myTreeExpander.setModel(model2);
        this.myOccurenceNavigator.setModel(model2);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(model2);
        }
        for (ToggleModelAction action2 : this.myActions) {
            action2.setModel(model2);
        }
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_ALPHABETICALLY, new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value2) {
                AbstractTestTreeBuilder builder = model2.getTreeBuilder();
                if (builder != null) {
                    builder.setTestsComparator(model2.getProperties());
                }
            }
        }, model2, true);
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.SORT_BY_DURATION, new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value2) {
                AbstractTestTreeBuilder builder = model2.getTreeBuilder();
                if (builder != null) {
                    builder.setTestsComparator(model2.getProperties());
                }
            }
        }, model2, true);
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator.getNextOccurenceActionName();
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator.getPreviousOccurenceActionName();
    }

    public void dispose() {
        this.myScrollToSource.setModel(null);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(null);
        }
    }

    private static class SortByDurationAction
    extends ToggleModelAction
    implements DumbAware {
        private TestFrameworkRunningModel myModel;

        public SortByDurationAction(TestConsoleProperties properties) {
            super(ExecutionBundle.message((String)"junit.runing.info.sort.by.statistics.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.runing.info.sort.by.statistics.action.description", (Object[])new Object[0]), AllIcons.RunConfigurations.SortbyDuration, properties, TestConsoleProperties.SORT_BY_DURATION);
        }

        protected boolean isEnabled() {
            TestFrameworkRunningModel model2 = this.myModel;
            return model2 != null && !model2.isRunning();
        }

        @Override
        public void setModel(TestFrameworkRunningModel model2) {
            this.myModel = model2;
        }
    }
}

