/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiffRequestProcessor
extends DiffRequestProcessor {
    @NotNull
    private final List<DiffHyperlink> myRequests;
    private int myIndex;

    public TestDiffRequestProcessor(@Nullable Project project2, @NotNull List<DiffHyperlink> requests, int index) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "<init>"));
        }
        super(project2, "TestsFiledAssertions");
        this.myRequests = requests;
        this.myIndex = index;
        this.putContextUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, true);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest(this.loadRequest(), force, scrollToChangePolicy);
    }

    @NotNull
    private DiffRequest loadRequest() {
        SimpleDiffRequest simpleDiffRequest;
        block5: {
            if (this.myIndex < 0 || this.myIndex >= this.myRequests.size()) {
                NoDiffRequest noDiffRequest = NoDiffRequest.INSTANCE;
                if (noDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "loadRequest"));
                }
                return noDiffRequest;
            }
            DiffHyperlink hyperlink = this.myRequests.get(this.myIndex);
            try {
                String windowTitle = hyperlink.getDiffTitle();
                String text1 = hyperlink.getLeft();
                String text2 = hyperlink.getRight();
                VirtualFile file1 = TestDiffRequestProcessor.findFile(hyperlink.getFilePath());
                VirtualFile file2 = TestDiffRequestProcessor.findFile(hyperlink.getActualFilePath());
                DiffContent content1 = TestDiffRequestProcessor.createContentWithTitle(this.getProject(), text1, file1, file2);
                DiffContent content2 = TestDiffRequestProcessor.createContentWithTitle(this.getProject(), text2, file2, file1);
                String title1 = TestDiffRequestProcessor.getContentTitle("diff.content.expected.title", file1);
                String title2 = TestDiffRequestProcessor.getContentTitle("diff.content.actual.title", file2);
                simpleDiffRequest = new SimpleDiffRequest(windowTitle, content1, content2, title1, title2);
                if (simpleDiffRequest != null) break block5;
            }
            catch (Exception e2) {
                ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest((Throwable)e2);
                if (errorDiffRequest == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "loadRequest"));
                }
                return errorDiffRequest;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "loadRequest"));
        }
        return simpleDiffRequest;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String path) {
        return path != null ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    @NotNull
    private static DiffContent createContentWithTitle(@Nullable Project project2, @NotNull String content2, @Nullable VirtualFile contentFile, @Nullable VirtualFile highlightFile) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "createContentWithTitle"));
        }
        if (contentFile != null) {
            DiffContent diffContent = DiffContentFactory.getInstance().create(project2, contentFile);
            if (diffContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "createContentWithTitle"));
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project2, content2, highlightFile);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "createContentWithTitle"));
        }
        return documentContent;
    }

    @NotNull
    private static String getContentTitle(@NotNull String titleKey, @Nullable VirtualFile file2) {
        if (titleKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleKey", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "getContentTitle"));
        }
        String title = ExecutionBundle.message((String)titleKey, (Object[])new Object[0]);
        if (file2 != null) {
            title = title + " (" + file2.getPresentableUrl() + ")";
        }
        String string2 = title;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/TestDiffRequestProcessor", "getContentTitle"));
        }
        return string2;
    }

    @Override
    protected boolean hasNextChange() {
        return true;
    }

    @Override
    protected boolean hasPrevChange() {
        return true;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ++this.myIndex;
        if (this.myIndex >= this.myRequests.size()) {
            this.myIndex = 0;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        --this.myIndex;
        if (this.myIndex < 0) {
            this.myIndex = this.myRequests.size() - 1;
        }
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequests.size() > 1;
    }
}

