/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.testframework.autotest.AutoTestManager;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustAutotestDelayActionGroup
extends ActionGroup {
    public static final int MAX_DELAY = 10;
    private final DataContext myDataContext;

    public AdjustAutotestDelayActionGroup(@NotNull JComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup", "<init>"));
        }
        super("Set AutoTest Delay", true);
        this.myDataContext = DataManager.getInstance().getDataContext((Component)parent);
    }

    public void update(AnActionEvent e2) {
        RunContentDescriptor descriptor2 = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(this.myDataContext);
        boolean visible = false;
        if (descriptor2 != null) {
            for (AnAction action2 : descriptor2.getRestartActions()) {
                if (!(action2 instanceof ToggleAutoTestAction)) continue;
                visible = ((ToggleAutoTestAction)action2).isDelayApplicable();
                break;
            }
        }
        e2.getPresentation().setVisible(visible);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e2) {
        AnAction[] actions2 = new AnAction[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            actions2[i2] = new SetAutoTestDelayAction(i2 + 1);
        }
        if (actions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AdjustAutotestDelayActionGroup", "getChildren"));
        }
        return actions2;
    }

    private static class SetAutoTestDelayAction
    extends ToggleAction {
        private final int myDelay;

        public SetAutoTestDelayAction(int delay) {
            super(delay + "s");
            this.myDelay = delay * 1000;
        }

        public boolean isSelected(AnActionEvent e2) {
            Project project2 = e2.getProject();
            return project2 != null && AutoTestManager.getInstance(project2).getDelay() == this.myDelay;
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            Project project2 = e2.getProject();
            if (project2 != null) {
                AutoTestManager.getInstance(project2).setDelay(this.myDelay);
            }
        }
    }
}

