/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.text.StringUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestIgnoredEvent
extends TreeNodeEvent {
    private final String myIgnoreComment;
    private final String myStacktrace;

    public TestIgnoredEvent(@NotNull String testName, @NotNull String ignoreComment, @Nullable String stacktrace) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "<init>"));
        }
        if (ignoreComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoreComment", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "<init>"));
        }
        super(testName, null);
        this.myIgnoreComment = ignoreComment;
        this.myStacktrace = stacktrace;
    }

    public TestIgnoredEvent(@NotNull TestIgnored testIgnored, @Nullable String stacktrace) {
        if (testIgnored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnored", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "<init>"));
        }
        super(testIgnored.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testIgnored));
        this.myIgnoreComment = testIgnored.getIgnoreComment();
        this.myStacktrace = stacktrace;
    }

    @NotNull
    public String getIgnoreComment() {
        if (StringUtil.isEmpty((String)this.myIgnoreComment)) {
            String string2 = SMTestsRunnerBundle.message("sm.test.runner.states.test.is.ignored", new Object[0]);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "getIgnoreComment"));
            }
            return string2;
        }
        String string3 = this.myIgnoreComment;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "getIgnoreComment"));
        }
        return string3;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/execution/testframework/sm/runner/events/TestIgnoredEvent", "appendToStringInfo"));
        }
        TestIgnoredEvent.append(buf, "ignoreComment", this.myIgnoreComment);
        TestIgnoredEvent.append(buf, "stacktrace", this.myStacktrace);
    }
}

