/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportedTestContentHandler
extends DefaultHandler {
    private final GeneralTestEventsProcessor myProcessor;
    private final Stack<String> mySuites = new Stack();
    private String myCurrentTest;
    private String myDuration;
    private String myStatus;
    private final StringBuilder currentValue = new StringBuilder();
    private boolean myErrorOutput = false;

    public ImportedTestContentHandler(GeneralTestEventsProcessor processor2) {
        this.myProcessor = processor2;
    }

    @Override
    public void startElement(String uri2, String localName, String qName, Attributes attributes) throws SAXException {
        if ("suite".equals(qName)) {
            String suiteName = StringUtil.unescapeXml((String)attributes.getValue("name"));
            this.myProcessor.onSuiteStarted(new TestSuiteStartedEvent(suiteName, StringUtil.unescapeXml((String)attributes.getValue("locationUrl"))));
            this.mySuites.push((Object)suiteName);
        } else if ("test".equals(qName)) {
            String name;
            this.myCurrentTest = name = StringUtil.unescapeXml((String)attributes.getValue("name"));
            this.myDuration = attributes.getValue("duration");
            this.myStatus = attributes.getValue("status");
            String isConfig = attributes.getValue("isConfig");
            TestStartedEvent startedEvent = new TestStartedEvent(name, StringUtil.unescapeXml((String)attributes.getValue("locationUrl")));
            if (isConfig != null && Boolean.valueOf(isConfig).booleanValue()) {
                startedEvent.setConfig(true);
            }
            this.myProcessor.onTestStarted(startedEvent);
            this.currentValue.setLength(0);
        } else if ("output".equals(qName)) {
            this.myErrorOutput = Comparing.equal((String)attributes.getValue("type"), (String)"stderr");
            this.currentValue.setLength(0);
        } else if ("root".equals(qName)) {
            this.myProcessor.onRootPresentationAdded(attributes.getValue("name"), attributes.getValue("comment"), attributes.getValue("location"));
        }
    }

    @Override
    public void characters(char[] ch, int start2, int length) throws SAXException {
        this.currentValue.append(ch, start2, length);
    }

    @Override
    public void endElement(String uri2, String localName, String qName) throws SAXException {
        boolean isTestOutput;
        String currentText = StringUtil.unescapeXml((String)this.currentValue.toString());
        boolean bl = isTestOutput = this.myCurrentTest == null || "passed".equals(this.myStatus) || !this.myErrorOutput;
        if (isTestOutput) {
            this.currentValue.setLength(0);
        }
        if ("suite".equals(qName)) {
            this.myProcessor.onSuiteFinished(new TestSuiteFinishedEvent((String)this.mySuites.pop()));
        } else if ("test".equals(qName)) {
            boolean isError = "error".equals(this.myStatus);
            if ("failed".equals(this.myStatus) || isError) {
                this.myProcessor.onTestFailure(new TestFailedEvent(this.myCurrentTest, "", currentText, isError, null, null));
            } else if ("ignored".equals(this.myStatus) || "skipped".equals(this.myStatus)) {
                this.myProcessor.onTestIgnored(new TestIgnoredEvent(this.myCurrentTest, "", currentText){

                    @Override
                    @NotNull
                    public String getIgnoreComment() {
                        if ("" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/history/ImportedTestContentHandler$1", "getIgnoreComment"));
                        }
                        return "";
                    }
                });
            }
            this.myProcessor.onTestFinished(new TestFinishedEvent(this.myCurrentTest, (Long)(this.myDuration != null ? Long.parseLong(this.myDuration) : -1L)));
            if (!"passed".equals(this.myStatus)) {
                this.currentValue.setLength(0);
            }
            this.myCurrentTest = null;
        } else if ("output".equals(qName) && !StringUtil.isEmpty((String)currentText) && isTestOutput) {
            if (this.myCurrentTest != null) {
                this.myProcessor.onTestOutput(new TestOutputEvent(this.myCurrentTest, currentText, !this.myErrorOutput));
            } else {
                this.myProcessor.onUncapturedOutput(currentText, this.myErrorOutput ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT);
            }
        }
    }
}

