/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private volatile Map<FacetTypeId, Collection<Facet>> myType2Facets;
    private volatile Map<Pair<Facet, FacetTypeId>, Collection<Facet>> myChildFacets;
    private volatile Facet[] mySortedFacets;

    @NotNull
    public Facet[] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet<Facet> facets = new LinkedHashSet<Facet>();
                for (Facet facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets, facet);
                }
                this.mySortedFacets = facets.toArray(new Facet[facets.size()]);
            }
        }
        if (this.mySortedFacets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetModelBase", "getSortedFacets"));
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<Facet> facets, Facet facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets, underlyingFacet);
        }
        facets.add(facet);
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet> facets;
        if (underlyingFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "underlyingFacet", "com/intellij/facet/impl/FacetModelBase", "getFacetsByType"));
        }
        if (this.myChildFacets == null) {
            MultiValuesMap children2 = new MultiValuesMap();
            for (Facet facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children2.put((Object)Pair.create((Object)underlying, (Object)facet.getTypeId()), (Object)facet);
            }
            HashMap<Pair<Facet, FacetTypeId>, Collection<Facet>> childFacets = new HashMap<Pair<Facet, FacetTypeId>, Collection<Facet>>();
            for (Pair pair : children2.keySet()) {
                Collection facets2 = children2.get((Object)pair);
                childFacets.put((Pair<Facet, FacetTypeId>)pair, Collections.unmodifiableCollection(facets2));
            }
            this.myChildFacets = childFacets;
        }
        Collection<Object> collection = (facets = this.myChildFacets.get(new Pair((Object)underlyingFacet, typeId))) != null ? facets : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetModelBase", "getFacetsByType"));
        }
        return collection;
    }

    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModelBase", "getFacetName"));
        }
        String string2 = facet.getName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetModelBase", "getFacetName"));
        }
        return string2;
    }

    @Nullable
    public <F extends Facet> F findFacet(FacetTypeId<F> type, String name) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f2 : fs) {
            if (!f2.getName().equals(name)) continue;
            return (F)f2;
        }
        return null;
    }

    @Nullable
    public <F extends Facet> F getFacetByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "underlyingFacet", "com/intellij/facet/impl/FacetModelBase", "getFacetByType"));
        }
        Collection<F> fs = this.getFacetsByType(underlyingFacet, typeId);
        return (F)(fs.isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Nullable
    public <F extends Facet> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> facets = this.getFacetsByType(typeId);
        return (F)(facets.isEmpty() ? null : (Facet)facets.iterator().next());
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet> facets;
        if (this.myType2Facets == null) {
            MultiValuesMap typeToFacets = new MultiValuesMap();
            for (Facet facet : this.getAllFacets()) {
                typeToFacets.put((Object)facet.getTypeId(), (Object)facet);
            }
            HashMap<FacetTypeId, Collection<Facet>> typeToFacetsCollection = new HashMap<FacetTypeId, Collection<Facet>>();
            for (FacetTypeId id : typeToFacets.keySet()) {
                Collection facets2 = typeToFacets.get((Object)id);
                typeToFacetsCollection.put(id, Collections.unmodifiableCollection(facets2));
            }
            this.myType2Facets = typeToFacetsCollection;
        }
        Collection<Object> collection = (facets = this.myType2Facets.get(typeId)) != null ? facets : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetModelBase", "getFacetsByType"));
        }
        return collection;
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }
}

