/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.pointers.FacetPointersManagerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetPointerImpl<F extends Facet>
implements FacetPointer<F> {
    private final FacetPointersManagerImpl myManager;
    private String myModuleName;
    private String myFacetTypeId;
    private String myFacetName;
    private F myFacet;

    public FacetPointerImpl(FacetPointersManagerImpl manager, String id) {
        this.myManager = manager;
        int i2 = id.indexOf(47);
        this.myModuleName = id.substring(0, i2);
        int j2 = id.lastIndexOf(47);
        this.myFacetTypeId = id.substring(i2 + 1, j2);
        this.myFacetName = id.substring(j2 + 1);
    }

    public FacetPointerImpl(FacetPointersManagerImpl manager, @NotNull F facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/pointers/FacetPointerImpl", "<init>"));
        }
        this.myManager = manager;
        this.myFacet = facet;
        this.updateInfo(this.myFacet);
        this.registerDisposable();
    }

    public void refresh() {
        this.findAndSetFacet();
        if (this.myFacet != null) {
            this.updateInfo(this.myFacet);
        }
    }

    private void findAndSetFacet() {
        if (this.myFacet == null) {
            this.myFacet = this.findFacet();
            if (this.myFacet != null) {
                this.registerDisposable();
            }
        }
    }

    private void registerDisposable() {
        Disposer.register(this.myFacet, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointerImpl.this.myManager.dispose(FacetPointerImpl.this);
                FacetPointerImpl.this.myFacet = null;
            }
        });
    }

    private void updateInfo(@NotNull F facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/pointers/FacetPointerImpl", "updateInfo"));
        }
        this.myModuleName = facet.getModule().getName();
        this.myFacetTypeId = facet.getType().getStringId();
        this.myFacetName = facet.getName();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myManager.getProject();
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getProject"));
        }
        return project2;
    }

    public F getFacet() {
        this.findAndSetFacet();
        return this.myFacet;
    }

    @Nullable
    private F findFacet() {
        Module module2 = ModuleManager.getInstance((Project)this.myManager.getProject()).findModuleByName(this.myModuleName);
        if (module2 == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)FacetManager.getInstance((Module)module2).findFacet(type.getId(), this.myFacetName);
    }

    @Nullable
    public F findFacet(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/facet/impl/pointers/FacetPointerImpl", "findFacet"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/facet/impl/pointers/FacetPointerImpl", "findFacet"));
        }
        Module module2 = modulesProvider.getModule(this.myModuleName);
        if (module2 == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)facetsProvider.findFacet(module2, type.getId(), this.myFacetName);
    }

    @NotNull
    public String getModuleName() {
        String string2 = this.myModuleName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getModuleName"));
        }
        return string2;
    }

    @NotNull
    public String getFacetName() {
        String string2 = this.myFacetName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getFacetName"));
        }
        return string2;
    }

    @NotNull
    public String getId() {
        String string2 = FacetPointersManager.constructId((String)this.myModuleName, (String)this.myFacetTypeId, (String)this.myFacetName);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getId"));
        }
        return string2;
    }

    @NotNull
    public String getFacetTypeId() {
        String string2 = this.myFacetTypeId;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getFacetTypeId"));
        }
        return string2;
    }

    @NotNull
    public String getModuleName(@Nullable ModifiableModuleModel moduleModel) {
        String newName;
        if (moduleModel != null && this.myFacet != null && (newName = moduleModel.getNewName(this.myFacet.getModule())) != null) {
            String string2 = newName;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getModuleName"));
            }
            return string2;
        }
        String string3 = this.myModuleName;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getModuleName"));
        }
        return string3;
    }

    @NotNull
    public String getFacetName(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getFacetName"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getFacetName"));
        }
        if (this.myFacet != null) {
            String string2 = modulesProvider.getFacetModel(this.myFacet.getModule()).getFacetName(this.myFacet);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getFacetName"));
            }
            return string2;
        }
        String string3 = this.myFacetName;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/pointers/FacetPointerImpl", "getFacetName"));
        }
        return string3;
    }

    @Nullable
    public FacetType<F, ?> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetTypeId);
    }
}

