/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetEditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class MultipleFacetEditorHelperImpl
implements MultipleFacetEditorHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.ui.MultipleFacetSettingsEditor");
    private final List<AbstractBinding> myBindings = new ArrayList<AbstractBinding>();

    public void bind(@NotNull ThreeStateCheckBox common, @NotNull FacetEditor[] editors, @NotNull NotNullFunction<FacetEditor, JCheckBox> fun) {
        if (common == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "common", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        ArrayList<JCheckBox> checkBoxesList = new ArrayList<JCheckBox>();
        for (FacetEditor editor : editors) {
            checkBoxesList.add((JCheckBox)fun.fun((Object)editor));
        }
        CheckBoxBinding checkBoxBinding = new CheckBoxBinding(common, checkBoxesList);
        this.myBindings.add(checkBoxBinding);
    }

    public void bind(@NotNull JTextField common, @NotNull FacetEditor[] editors, @NotNull NotNullFunction<FacetEditor, JTextField> fun) {
        if (common == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "common", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        ArrayList<Object> componentsList = new ArrayList<Object>();
        for (FacetEditor editor : editors) {
            componentsList.add(fun.fun((Object)editor));
        }
        TextFieldBinding binding = new TextFieldBinding(common, componentsList);
        this.myBindings.add(binding);
    }

    public void bind(@NotNull JComboBox common, @NotNull FacetEditor[] editors, @NotNull NotNullFunction<FacetEditor, JComboBox> fun) {
        if (common == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "common", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/facet/impl/ui/MultipleFacetEditorHelperImpl", "bind"));
        }
        ArrayList<JComboBox> componentsList = new ArrayList<JComboBox>();
        for (FacetEditor editor : editors) {
            componentsList.add((JComboBox)fun.fun((Object)editor));
        }
        CombobBoxBinding binding = new CombobBoxBinding(common, componentsList);
        this.myBindings.add(binding);
    }

    public void unbind() {
        for (AbstractBinding binding : this.myBindings) {
            binding.unbind();
        }
        this.myBindings.clear();
    }

    private static class CombobBoxBinding
    extends AbstractBinding
    implements ItemListener {
        private final JComboBox myCommon;
        private final List<JComboBox> myComponentsList;
        private final List<Object> myInitialValues;

        public CombobBoxBinding(JComboBox common, List<JComboBox> componentsList) {
            LOG.assertTrue(!componentsList.isEmpty());
            this.myCommon = common;
            this.myComponentsList = componentsList;
            JComboBox first = componentsList.get(0);
            Object initialValue = first.getSelectedItem();
            this.myInitialValues = new ArrayList<Object>();
            for (JComboBox component : componentsList) {
                Object item = component.getSelectedItem();
                this.myInitialValues.add(item);
                if (initialValue == null || initialValue.equals(item)) continue;
                initialValue = null;
            }
            common.setSelectedItem(initialValue);
            common.addItemListener(this);
        }

        @Override
        public void unbind() {
            this.myCommon.removeItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            Object item = this.myCommon.getSelectedItem();
            for (int i2 = 0; i2 < this.myComponentsList.size(); ++i2) {
                this.myComponentsList.get(i2).setSelectedItem(item != null ? item : this.myInitialValues.get(i2));
            }
        }
    }

    private static class TextFieldBinding
    extends AbstractBinding {
        private final JTextField myCommon;
        private final List<JTextField> myTextFields;
        private final List<String> myInitialValues;
        private final DocumentAdapter myListener;

        private TextFieldBinding(JTextField common, List<JTextField> textFields) {
            LOG.assertTrue(!textFields.isEmpty());
            this.myCommon = common;
            this.myTextFields = textFields;
            String initialValue = this.myTextFields.get(0).getText();
            this.myInitialValues = new ArrayList<String>();
            for (JTextField field : this.myTextFields) {
                String value2 = field.getText();
                this.myInitialValues.add(value2);
                if (initialValue == null || initialValue.equals(value2)) continue;
                initialValue = null;
            }
            common.setText(initialValue != null ? initialValue : "");
            this.myListener = new DocumentAdapter(){

                protected void textChanged(DocumentEvent e2) {
                    this.textChanged();
                }
            };
            this.myCommon.getDocument().addDocumentListener((DocumentListener)this.myListener);
        }

        protected void textChanged() {
            String value2 = this.myCommon.getText();
            for (int i2 = 0; i2 < this.myTextFields.size(); ++i2) {
                this.myTextFields.get(i2).setText(value2.length() == 0 ? this.myInitialValues.get(i2) : value2);
            }
        }

        @Override
        public void unbind() {
            this.myCommon.getDocument().removeDocumentListener((DocumentListener)this.myListener);
        }
    }

    private static class CheckBoxBinding
    extends AbstractBinding
    implements ActionListener {
        private final ThreeStateCheckBox myCommon;
        private final List<JCheckBox> myCheckBoxesList;
        private final List<Boolean> myInitialValues;

        public CheckBoxBinding(ThreeStateCheckBox common, List<JCheckBox> checkBoxesList) {
            LOG.assertTrue(!checkBoxesList.isEmpty());
            this.myCommon = common;
            this.myCheckBoxesList = checkBoxesList;
            Boolean initialValue = checkBoxesList.get(0).isSelected();
            this.myInitialValues = new ArrayList<Boolean>();
            for (JCheckBox checkBox2 : checkBoxesList) {
                boolean value2 = checkBox2.isSelected();
                this.myInitialValues.add(value2);
                if (initialValue == null || value2 == initialValue) continue;
                initialValue = null;
            }
            if (initialValue != null) {
                common.setThirdStateEnabled(false);
                common.setSelected(initialValue.booleanValue());
            } else {
                common.setThirdStateEnabled(true);
                common.setState(ThreeStateCheckBox.State.DONT_CARE);
            }
            this.myCommon.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ThreeStateCheckBox.State state = this.myCommon.getState();
            for (int i2 = 0; i2 < this.myCheckBoxesList.size(); ++i2) {
                JCheckBox checkBox2;
                boolean value2 = state == ThreeStateCheckBox.State.SELECTED ? true : (state == ThreeStateCheckBox.State.NOT_SELECTED ? false : this.myInitialValues.get(i2));
                if (value2 == (checkBox2 = this.myCheckBoxesList.get(i2)).isSelected()) continue;
                ButtonModel model2 = checkBox2.getModel();
                model2.setArmed(true);
                model2.setPressed(true);
                model2.setPressed(false);
                model2.setArmed(false);
            }
        }

        @Override
        public void unbind() {
            this.myCommon.removeActionListener((ActionListener)this);
        }
    }

    private static abstract class AbstractBinding {
        private AbstractBinding() {
        }

        public abstract void unbind();
    }
}

