/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProductivityFeaturesRegistryImpl
extends ProductivityFeaturesRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.featureStatistics.ProductivityFeaturesRegistry");
    private final Map<String, FeatureDescriptor> myFeatures = new HashMap<String, FeatureDescriptor>();
    private final Map<String, GroupDescriptor> myGroups = new HashMap<String, GroupDescriptor>();
    private final List<Pair<String, ApplicabilityFilter>> myApplicabilityFilters = new ArrayList<Pair<String, ApplicabilityFilter>>();
    private boolean myAdditionalFeaturesLoaded = false;
    @NonNls
    public static final String WELCOME = "features.welcome";
    @NonNls
    private static final String TAG_FILTER = "filter";
    @NonNls
    private static final String TAG_GROUP = "group";
    @NonNls
    private static final String TAG_FEATURE = "feature";
    @NonNls
    private static final String TODO_HTML_MARKER = "todo.html";
    @NonNls
    private static final String CLASS_ATTR = "class";
    @NonNls
    private static final String PREFIX_ATTR = "prefix";

    public ProductivityFeaturesRegistryImpl() {
        this.reloadFromXml();
    }

    private void reloadFromXml() {
        block4: {
            try {
                this.readFromXml("file:///ProductivityFeaturesRegistry.xml");
            }
            catch (Exception e2) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break block4;
                LOG.error((Throwable)e2);
            }
        }
        try {
            this.readFromXml("file:///IdeSpecificFeatures.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readFromXml(String path) throws JDOMException, IOException {
        Document document = JDOMUtil.loadResourceDocument((URL)new URL(path));
        Element root = document.getRootElement();
        this.readGroups(root);
        this.readFilters(root);
    }

    private void lazyLoadFromPluginsFeaturesProviders() {
        if (this.myAdditionalFeaturesLoaded) {
            return;
        }
        this.loadFeaturesFromProviders((ProductivityFeaturesProvider[])ApplicationManager.getApplication().getComponents(ProductivityFeaturesProvider.class));
        this.loadFeaturesFromProviders((ProductivityFeaturesProvider[])Extensions.getExtensions((ExtensionPointName)ProductivityFeaturesProvider.EP_NAME));
        this.myAdditionalFeaturesLoaded = true;
    }

    private void loadFeaturesFromProviders(ProductivityFeaturesProvider[] providers) {
        for (ProductivityFeaturesProvider provider : providers) {
            ApplicabilityFilter[] applicabilityFilters;
            FeatureDescriptor[] featureDescriptors;
            GroupDescriptor[] groupDescriptors = provider.getGroupDescriptors();
            if (groupDescriptors != null) {
                for (GroupDescriptor groupDescriptor : groupDescriptors) {
                    this.myGroups.put(groupDescriptor.getId(), groupDescriptor);
                }
            }
            if ((featureDescriptors = provider.getFeatureDescriptors()) != null) {
                for (FeatureDescriptor featureDescriptor : featureDescriptors) {
                    FeatureDescriptor featureLoadedStatistics = this.myFeatures.get(featureDescriptor.getId());
                    if (featureLoadedStatistics != null) {
                        featureDescriptor.copyStatistics(featureLoadedStatistics);
                    }
                    this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
                }
            }
            if ((applicabilityFilters = provider.getApplicabilityFilters()) == null) continue;
            for (ApplicabilityFilter applicabilityFilter : applicabilityFilters) {
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)applicabilityFilter.getPrefix(), (Object)applicabilityFilter));
            }
        }
    }

    private void readFilters(Element element) {
        List filters2 = element.getChildren(TAG_FILTER);
        for (Object filter1 : filters2) {
            Element filterElement = (Element)filter1;
            String className = filterElement.getAttributeValue(CLASS_ATTR);
            try {
                Class<?> klass = Class.forName(className);
                if (!ApplicabilityFilter.class.isAssignableFrom(klass)) {
                    LOG.error("filter class must implement com.intellij.featureSatistics.ApplicabilityFilter");
                    continue;
                }
                ApplicabilityFilter filter2 = (ApplicabilityFilter)klass.newInstance();
                this.myApplicabilityFilters.add((Pair<String, ApplicabilityFilter>)Pair.create((Object)filterElement.getAttributeValue(PREFIX_ATTR), (Object)filter2));
            }
            catch (Exception e2) {
                LOG.error("Cannot instantiate filter " + className, (Throwable)e2);
            }
        }
    }

    private void readGroups(Element element) {
        List groups2 = element.getChildren(TAG_GROUP);
        for (Object group : groups2) {
            Element groupElement = (Element)group;
            this.readGroup(groupElement);
        }
    }

    private void readGroup(Element groupElement) {
        GroupDescriptor groupDescriptor = new GroupDescriptor();
        groupDescriptor.readExternal(groupElement);
        String groupId = groupDescriptor.getId();
        this.myGroups.put(groupId, groupDescriptor);
        this.readFeatures(groupElement, groupDescriptor);
    }

    private void readFeatures(Element groupElement, GroupDescriptor groupDescriptor) {
        List features = groupElement.getChildren(TAG_FEATURE);
        for (Object feature : features) {
            Element featureElement = (Element)feature;
            FeatureDescriptor featureDescriptor = new FeatureDescriptor(groupDescriptor);
            featureDescriptor.readExternal(featureElement);
            if (TODO_HTML_MARKER.equals(featureDescriptor.getTipFileName())) continue;
            this.myFeatures.put(featureDescriptor.getId(), featureDescriptor);
        }
    }

    @NotNull
    public Set<String> getFeatureIds() {
        this.lazyLoadFromPluginsFeaturesProviders();
        Set<String> set2 = this.myFeatures.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl", "getFeatureIds"));
        }
        return set2;
    }

    public FeatureDescriptor getFeatureDescriptor(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl", "getFeatureDescriptor"));
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.getFeatureDescriptorEx(id);
    }

    public FeatureDescriptor getFeatureDescriptorEx(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl", "getFeatureDescriptorEx"));
        }
        if (WELCOME.equals(id)) {
            return new FeatureDescriptor(WELCOME, "AdaptiveWelcome.html", FeatureStatisticsBundle.message((String)"feature.statistics.welcome.tip.name", (Object[])new Object[0]));
        }
        return this.myFeatures.get(id);
    }

    public GroupDescriptor getGroupDescriptor(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl", "getGroupDescriptor"));
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        return this.myGroups.get(id);
    }

    @NotNull
    public ApplicabilityFilter[] getMatchingFilters(@NotNull String featureId) {
        if (featureId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureId", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl", "getMatchingFilters"));
        }
        this.lazyLoadFromPluginsFeaturesProviders();
        ArrayList<Object> filters2 = new ArrayList<Object>();
        for (Pair<String, ApplicabilityFilter> pair : this.myApplicabilityFilters) {
            if (!featureId.startsWith((String)pair.getFirst())) continue;
            filters2.add(pair.getSecond());
        }
        ApplicabilityFilter[] applicabilityFilterArray = filters2.toArray(new ApplicabilityFilter[filters2.size()]);
        if (applicabilityFilterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/featureStatistics/ProductivityFeaturesRegistryImpl", "getMatchingFilters"));
        }
        return applicabilityFilterArray;
    }

    public String toString() {
        return super.toString() + "; myAdditionalFeaturesLoaded=" + this.myAdditionalFeaturesLoaded;
    }

    public void prepareForTest() {
        this.myAdditionalFeaturesLoaded = false;
        this.myFeatures.clear();
        this.myApplicabilityFilters.clear();
        this.myGroups.clear();
        this.reloadFromXml();
    }
}

