/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextFieldUI;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.InplaceActionButtonLook;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public class SearchTextArea
extends NonOpaquePanel
implements PropertyChangeListener,
FocusListener {
    public static final KeyStroke NEW_LINE_KEYSTROKE = KeyStroke.getKeyStroke(10, (SystemInfo.isMac ? 256 : 128) | 0x40);
    private final JTextArea myTextArea;
    private final boolean mySearchMode;
    private final boolean myInfoMode;
    private final JLabel myInfoLabel;
    private JPanel myIconsPanel;
    private ActionButton myNewLineButton;
    private ActionButton myClearButton;
    private JBScrollPane myScrollPane;
    private final ActionButton myHistoryPopupButton;
    private final LafHelper myHelper;
    private boolean myMultilineEnabled;
    private final KeyAdapter myEnterRedispatcher;
    private static Color enabledBorderColor = new JBColor((Color)Gray._196, (Color)Gray._100);
    private static Color disabledBorderColor = Gray._83;

    public SearchTextArea(boolean searchMode) {
        this(new JTextArea(), searchMode, false);
    }

    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode, boolean infoMode) {
        if (textArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textArea", "com/intellij/find/SearchTextArea", "<init>"));
        }
        this(textArea, searchMode, infoMode, false);
    }

    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode, boolean infoMode, boolean allowInsertTabInMultiline) {
        if (textArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textArea", "com/intellij/find/SearchTextArea", "<init>"));
        }
        this.myIconsPanel = null;
        this.myMultilineEnabled = true;
        this.myEnterRedispatcher = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 10 && SearchTextArea.this.getParent() != null) {
                    SearchTextArea.this.getParent().dispatchEvent(e2);
                }
            }
        };
        this.myTextArea = textArea;
        this.mySearchMode = searchMode;
        this.myInfoMode = infoMode;
        this.myTextArea.addPropertyChangeListener("background", this);
        this.myTextArea.addPropertyChangeListener("font", this);
        this.myTextArea.addFocusListener(this);
        this.myTextArea.registerKeyboardAction(e2 -> {
            if (allowInsertTabInMultiline && this.myTextArea.getText().contains("\n")) {
                if (this.myTextArea.isEditable() && this.myTextArea.isEnabled()) {
                    this.myTextArea.replaceSelection("\t");
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.myTextArea);
                }
            } else {
                this.myTextArea.transferFocus();
            }
        }, KeyStroke.getKeyStroke(9, 0), 0);
        this.myTextArea.registerKeyboardAction(e2 -> this.myTextArea.transferFocusBackward(), KeyStroke.getKeyStroke(9, 64), 0);
        KeymapUtil.reassignAction((JComponent)this.myTextArea, (KeyStroke)KeyStroke.getKeyStroke(10, 0), (KeyStroke)NEW_LINE_KEYSTROKE, (int)0);
        this.myTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.getProperty("filterNewlines") == Boolean.TRUE && str.indexOf(10) >= 0) {
                    str = StringUtil.replace((String)str, (String)"\n", (String)"");
                }
                if (!StringUtil.isEmpty((String)str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        this.myTextArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                SearchTextArea.this.updateIconsLayout();
            }
        });
        this.myTextArea.setOpaque(false);
        this.myScrollPane = new JBScrollPane(this.myTextArea, 20, 30){

            public Dimension getPreferredSize() {
                Dimension d2 = super.getPreferredSize();
                TextUI ui = SearchTextArea.this.myTextArea.getUI();
                if (ui != null) {
                    d2.height = Math.min(d2.height, ui.getPreferredSize((JComponent)((SearchTextArea)SearchTextArea.this).myTextArea).height);
                }
                return d2;
            }
        };
        this.myTextArea.setBorder(new Border(){

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c2) {
                int top;
                int bottom = StringUtil.getLineBreakCount((CharSequence)SearchTextArea.this.myTextArea.getText()) > 0 ? 2 : (UIUtil.isUnderDarcula() ? 1 : 0);
                int n2 = top = SearchTextArea.this.myTextArea.getFontMetrics(SearchTextArea.this.myTextArea.getFont()).getHeight() <= 16 ? 2 : 1;
                if (JBUI.isUsrHiDPI()) {
                    bottom = 2;
                    top = 2;
                }
                return new JBInsets(top, 0, bottom, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
        this.myScrollPane.getVerticalScrollBar().setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myScrollPane.getViewport().setBorder(null);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        this.myScrollPane.setOpaque(false);
        this.myInfoLabel = new JBLabel(UIUtil.ComponentStyle.SMALL);
        this.myInfoLabel.setForeground((Color)JBColor.GRAY);
        this.myHelper = this.createHelper();
        this.myHistoryPopupButton = SearchTextArea.createButton((AnAction)new ShowHistoryAction());
        this.myClearButton = SearchTextArea.createButton((AnAction)new ClearAction());
        this.myNewLineButton = SearchTextArea.createButton((AnAction)new NewLineAction());
        this.myNewLineButton.setVisible(searchMode);
        this.myIconsPanel = new NonOpaquePanel();
        this.updateLayout();
    }

    protected void updateLayout() {
        this.setBorder(this.myHelper.getBorder());
        this.setLayout((LayoutManager)new MigLayout(this.myHelper.getLayoutConstraints()));
        this.removeAll();
        this.add(this.myHistoryPopupButton, this.myHelper.getHistoryButtonConstraints());
        this.add((Component)this.myScrollPane, "ay top, growx, pushx");
        if (this.myInfoMode) {
            this.add(this.myInfoLabel, "gapright " + JBUI.scale((int)4));
        }
        this.add(this.myIconsPanel, this.myHelper.getIconsPanelConstraints());
        this.updateIconsLayout();
    }

    protected boolean isNewLineAvailable() {
        return Registry.is((String)"ide.find.show.add.newline.hint") && this.myMultilineEnabled;
    }

    private void updateIconsLayout() {
        boolean wrongPositioning;
        boolean multiline;
        if (this.myIconsPanel.getParent() == null) {
            return;
        }
        boolean showClearIcon = !StringUtil.isEmpty((String)this.myTextArea.getText());
        boolean showNewLine = this.isNewLineAvailable();
        boolean wrongVisibility = this.myClearButton.getParent() != null != showClearIcon || this.myNewLineButton.getParent() != null != showNewLine;
        LayoutManager layout = this.myIconsPanel.getLayout();
        boolean wrongLayout = !(layout instanceof GridLayout);
        boolean bl = multiline = StringUtil.getLineBreakCount((CharSequence)this.myTextArea.getText()) > 0;
        boolean bl2 = !wrongLayout && ((GridLayout)layout).getRows() > 1 != multiline ? true : (wrongPositioning = false);
        if (wrongLayout || wrongVisibility || wrongPositioning) {
            this.myIconsPanel.removeAll();
            int rows = multiline && showClearIcon && showNewLine ? 2 : 1;
            int columns = !multiline && showClearIcon && showNewLine ? 2 : 1;
            this.myIconsPanel.setLayout(new GridLayout(rows, columns, 8, 8));
            if (!multiline && showNewLine) {
                this.myIconsPanel.add(this.myNewLineButton);
            }
            if (showClearIcon) {
                this.myIconsPanel.add(this.myClearButton);
            }
            if (multiline && showNewLine) {
                this.myIconsPanel.add(this.myNewLineButton);
            }
            this.myIconsPanel.setBorder(this.myHelper.getIconsPanelBorder(rows));
            this.myScrollPane.setHorizontalScrollBarPolicy(multiline ? 30 : 31);
            this.myScrollPane.setVerticalScrollBarPolicy(multiline ? 20 : 21);
            this.myScrollPane.revalidate();
            this.doLayout();
        }
    }

    public void setMultilineEnabled(boolean enabled) {
        if (this.myMultilineEnabled == enabled) {
            return;
        }
        this.myMultilineEnabled = enabled;
        this.myTextArea.getDocument().putProperty("filterNewlines", this.myMultilineEnabled ? null : Boolean.TRUE);
        if (!this.myMultilineEnabled) {
            this.myTextArea.addKeyListener(this.myEnterRedispatcher);
        } else {
            this.myTextArea.removeKeyListener(this.myEnterRedispatcher);
        }
        this.updateIconsLayout();
    }

    @NotNull
    public JTextArea getTextArea() {
        JTextArea jTextArea = this.myTextArea;
        if (jTextArea == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchTextArea", "getTextArea"));
        }
        return jTextArea;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("background".equals(evt.getPropertyName())) {
            this.repaint();
        }
        if ("font".equals(evt.getPropertyName())) {
            this.updateLayout();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.myNewLineButton.setVisible(true);
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.myNewLineButton.setVisible(this.mySearchMode);
        this.repaint();
    }

    public void setInfoText(String info) {
        this.myInfoLabel.setText(info);
    }

    public void paint(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            this.myHelper.paint(g2);
        }
        finally {
            g2.dispose();
        }
        super.paint(graphics);
        if (UIUtil.isUnderGTKLookAndFeel()) {
            graphics.setColor(this.myTextArea.getBackground());
            Rectangle bounds = this.myScrollPane.getViewport().getBounds();
            if (this.myScrollPane.getVerticalScrollBar().isVisible()) {
                bounds.width -= this.myScrollPane.getVerticalScrollBar().getWidth();
            }
            bounds = SwingUtilities.convertRectangle(this.myScrollPane.getViewport(), bounds, (Component)((Object)this));
            JBInsets.addTo((Rectangle)bounds, (Insets)new JBInsets(2, 2, -1, -1));
            ((Graphics2D)graphics).draw(bounds);
        }
    }

    private static ActionButton createButton(AnAction action2) {
        Presentation presentation = action2.getTemplatePresentation();
        JBDimension d2 = new JBDimension(16, 16);
        ActionButton button = new ActionButton(action2, presentation, "unknown", (Dimension)d2){

            @Override
            protected DataContext getDataContext() {
                return DataManager.getInstance().getDataContext((Component)this);
            }
        };
        button.setLook(new InplaceActionButtonLook());
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.updateIcon();
        return button;
    }

    @NotNull
    private LafHelper createHelper() {
        LafHelper lafHelper = SystemInfo.isMac && !UIUtil.isUnderDarcula() ? new MacLafHelper() : new DefaultLafHelper();
        if (lafHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchTextArea", "createHelper"));
        }
        return lafHelper;
    }

    private class DefaultLafHelper
    extends LafHelper {
        private DefaultLafHelper() {
        }

        @Override
        Border getBorder() {
            return JBUI.Borders.empty((int)2);
        }

        @Override
        String getLayoutConstraints() {
            return "flowx, ins 2 " + JBUI.scale((int)4) + " 2 " + (3 + JBUI.scale((int)1)) + ", gapx " + JBUI.scale((int)4);
        }

        @Override
        String getHistoryButtonConstraints() {
            return "ay top, gaptop " + JBUI.scale((int)this.getIconTopGap());
        }

        private int getIconTopGap() {
            return Math.max(2, (UIUtil.getLineHeight((JTextComponent)SearchTextArea.this.myTextArea) + ((SearchTextArea)SearchTextArea.this).myTextArea.getInsets().top + ((SearchTextArea)SearchTextArea.this).myTextArea.getInsets().bottom - JBUI.scale((int)16)) / 2);
        }

        @Override
        String getIconsPanelConstraints() {
            return "gaptop " + this.getIconTopGap() + ",ay top";
        }

        @Override
        Border getIconsPanelBorder(int rows) {
            return JBUI.Borders.empty();
        }

        @Override
        Icon getShowHistoryIcon() {
            Icon searchIcon = UIManager.getIcon("TextField.darcula.searchWithHistory.icon");
            if (searchIcon == null) {
                searchIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/searchWithHistory.png", DarculaTextFieldUI.class, (boolean)true);
            }
            return searchIcon;
        }

        @Override
        Icon getClearIcon() {
            Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
            if (clearIcon == null) {
                clearIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
            }
            return clearIcon;
        }

        @Override
        void paint(Graphics2D g2) {
            Rectangle r2 = new Rectangle(SearchTextArea.this.getSize());
            JBInsets.removeFrom((Rectangle)r2, (Insets)SearchTextArea.this.getInsets());
            if (r2.height % 2 == 1) {
                ++r2.height;
            }
            int arcSize = JBUI.scale((int)26);
            JBInsets.removeFrom((Rectangle)r2, (Insets)new JBInsets(1, 1, 1, 1));
            if (SearchTextArea.this.myTextArea.hasFocus()) {
                g2.setColor(SearchTextArea.this.myTextArea.getBackground());
                RectanglePainter.FILL.paint(g2, r2.x, r2.y, r2.width, r2.height, (Object)arcSize);
                DarculaUIUtil.paintSearchFocusRing(g2, r2, SearchTextArea.this.myTextArea, arcSize);
            } else {
                RectanglePainter.paint((Graphics2D)g2, (int)r2.x, (int)r2.y, (int)r2.width, (int)r2.height, (int)(arcSize -= JBUI.scale((int)5)), (Color)SearchTextArea.this.myTextArea.getBackground(), (Color)(SearchTextArea.this.myTextArea.isEnabled() ? Gray._100 : Gray._83));
            }
        }
    }

    private class MacLafHelper
    extends LafHelper {
        private MacLafHelper() {
        }

        @Override
        Border getBorder() {
            return new EmptyBorder(3 + Math.max(0, JBUI.scale((int)16) - UIUtil.getLineHeight((JTextComponent)SearchTextArea.this.myTextArea)) / 2, 6, 3, 4);
        }

        @Override
        String getLayoutConstraints() {
            return "flowx, ins 0, gapx " + JBUI.scale((int)4);
        }

        @Override
        String getHistoryButtonConstraints() {
            int extraGap = this.getExtraGap();
            return "ay top, gaptop " + extraGap + ", gapleft" + (JBUI.isUsrHiDPI() ? 4 : 0);
        }

        private int getExtraGap() {
            int height = UIUtil.getLineHeight((JTextComponent)SearchTextArea.this.myTextArea);
            Insets insets = SearchTextArea.this.myTextArea.getInsets();
            return Math.max(JBUI.isUsrHiDPI() ? 0 : 1, (height + insets.top + insets.bottom - JBUI.scale((int)16)) / 2);
        }

        @Override
        String getIconsPanelConstraints() {
            int extraGap = this.getExtraGap();
            return "gaptop " + extraGap + ",ay top, gapright " + extraGap / 2;
        }

        @Override
        Border getIconsPanelBorder(int rows) {
            return JBUI.Borders.emptyBottom((int)(rows == 2 ? 3 : 0));
        }

        @Override
        Icon getShowHistoryIcon() {
            return MacIntelliJIconCache.getIcon("searchFieldWithHistory");
        }

        @Override
        Icon getClearIcon() {
            return AllIcons.Actions.Clear;
        }

        @Override
        void paint(Graphics2D g2) {
            Rectangle r2 = new Rectangle(SearchTextArea.this.getSize());
            int h2 = SearchTextArea.this.myIconsPanel.getParent() != null ? Math.max(SearchTextArea.this.myIconsPanel.getHeight(), SearchTextArea.this.myScrollPane.getHeight()) : SearchTextArea.this.myScrollPane.getHeight();
            r2.height = Math.max(r2.height, h2 + SearchTextArea.this.getInsets().top + SearchTextArea.this.getInsets().bottom);
            if (r2.height % 2 == 1) {
                --r2.height;
            }
            g2.setColor(SearchTextArea.this.myTextArea.isEnabled() ? enabledBorderColor : disabledBorderColor);
            MacIntelliJTextFieldUI.paintAquaSearchFocusRing(g2, r2, SearchTextArea.this.myTextArea);
        }
    }

    private static abstract class LafHelper {
        private LafHelper() {
        }

        abstract Border getBorder();

        abstract String getLayoutConstraints();

        abstract String getHistoryButtonConstraints();

        abstract String getIconsPanelConstraints();

        abstract Border getIconsPanelBorder(int var1);

        abstract Icon getShowHistoryIcon();

        abstract Icon getClearIcon();

        abstract void paint(Graphics2D var1);
    }

    private class NewLineAction
    extends DumbAwareAction {
        public NewLineAction() {
            super(null, "New line (" + KeymapUtil.getKeystrokeText((KeyStroke)NEW_LINE_KEYSTROKE) + ")", AllIcons.Actions.SearchNewLine);
        }

        public void actionPerformed(AnActionEvent e2) {
            new DefaultEditorKit.InsertBreakAction().actionPerformed(new ActionEvent(SearchTextArea.this.myTextArea, 0, "action"));
        }
    }

    private class ClearAction
    extends DumbAwareAction {
        public ClearAction() {
            super(null, null, SearchTextArea.this.myHelper.getClearIcon());
        }

        public void actionPerformed(AnActionEvent e2) {
            SearchTextArea.this.myTextArea.setText("");
        }
    }

    private class ShowHistoryAction
    extends DumbAwareAction {
        public ShowHistoryAction() {
            super((SearchTextArea.this.mySearchMode ? "Search" : "Replace") + " History", (SearchTextArea.this.mySearchMode ? "Search" : "Replace") + " history", SearchTextArea.this.myHelper.getShowHistoryIcon());
            KeyStroke stroke = KeyStroke.getKeyStroke(72, 128);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(stroke, null)}), SearchTextArea.this.myTextArea);
        }

        public void actionPerformed(AnActionEvent e2) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("find.recent.search");
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(e2.getProject());
            Object[] recent = SearchTextArea.this.mySearchMode ? findInProjectSettings.getRecentFindStrings() : findInProjectSettings.getRecentReplaceStrings();
            String title = "Recent " + (SearchTextArea.this.mySearchMode ? "Searches" : "Replaces");
            JBList historyList = new JBList(ArrayUtil.reverseArray((Object[])recent));
            Utils.showCompletionPopup((JComponent)((Object)SearchTextArea.this), (JList)historyList, title, SearchTextArea.this.myTextArea, null);
        }
    }
}

