/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.UsagesPreviewPanelProvider;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageGroupingRuleProviderImpl;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesAction
extends AnAction
implements PopupAction {
    public static final String ID = "ShowUsages";
    public static final int USAGES_PAGE_SIZE = 100;
    static final Usage MORE_USAGES_SEPARATOR = NullUsage.INSTANCE;
    static final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
    private static final UsageNode MORE_USAGES_SEPARATOR_NODE = UsageViewImpl.NULL_NODE;
    private static final UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, USAGES_OUTSIDE_SCOPE_SEPARATOR);
    private static final Comparator<UsageNode> USAGE_NODE_COMPARATOR = (c1, c2) -> {
        VirtualFile v2;
        String name2;
        int weight2;
        int weight1;
        if (c1 instanceof StringNode || c2 instanceof StringNode) {
            if (c1 instanceof StringNode && c2 instanceof StringNode) {
                return Comparing.compare((Comparable)((Object)c1.toString()), (Comparable)((Object)c2.toString()));
            }
            return c1 instanceof StringNode ? 1 : -1;
        }
        Usage o1 = c1.getUsage();
        Usage o2 = c2.getUsage();
        int n2 = o1 == USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == MORE_USAGES_SEPARATOR ? 1 : 0);
        int n3 = o2 == USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == MORE_USAGES_SEPARATOR ? 1 : 0);
        if (weight1 != weight2) {
            return weight1 - weight2;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
        String name1 = v1 == null ? null : v1.getName();
        int i2 = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
        if (i2 != 0) {
            return i2;
        }
        if (Comparing.equal((Object)v1, (Object)v2)) {
            FileEditorLocation loc1 = o1.getLocation();
            FileEditorLocation loc2 = o2.getLocation();
            return Comparing.compare((Comparable)loc1, (Comparable)loc2);
        }
        String path1 = v1 == null ? null : v1.getPath();
        String path2 = v2 == null ? null : v2.getPath();
        return Comparing.compare((Comparable)((Object)path1), (Comparable)((Object)path2));
    };
    private final boolean myShowSettingsDialogBefore;
    private final UsageViewSettings myUsageViewSettings;
    private Runnable mySearchEverywhereRunnable;
    private int myWidth;

    public ShowUsagesAction() {
        this(false);
    }

    private ShowUsagesAction(boolean showDialogBefore) {
        this.setInjectedContext(true);
        this.myShowSettingsDialogBefore = showDialogBefore;
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        this.myUsageViewSettings = new UsageViewSettings();
        this.myUsageViewSettings.loadState(usageViewSettings);
        this.myUsageViewSettings.GROUP_BY_FILE_STRUCTURE = false;
        this.myUsageViewSettings.GROUP_BY_MODULE = false;
        this.myUsageViewSettings.GROUP_BY_PACKAGE = false;
        this.myUsageViewSettings.GROUP_BY_USAGE_TYPE = false;
        this.myUsageViewSettings.GROUP_BY_SCOPE = false;
    }

    public boolean startInTransaction() {
        return true;
    }

    public void update(@NotNull AnActionEvent e2) {
        Object[] usageTargets;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction", "update"));
        }
        FindUsagesInFileAction.updateFindUsagesAction(e2);
        if (e2.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e2.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget)) {
            e2.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        PsiElement element2;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        if (project2 == null) {
            return;
        }
        Runnable searchEverywhere = this.mySearchEverywhereRunnable;
        this.mySearchEverywhereRunnable = null;
        ShowUsagesAction.hideHints();
        if (searchEverywhere != null) {
            searchEverywhere.run();
            return;
        }
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e2.getDataContext());
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        Object[] usageTargets = (UsageTarget[])e2.getData(UsageView.USAGE_TARGETS_KEY);
        Editor editor = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project2, editor, (PsiElementProcessor<PsiElement>)((PsiElementProcessor)element -> {
                this.startFindUsages(element, popupPosition, editor, 100);
                return false;
            }));
        } else if (ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget && (element2 = ((PsiElementUsageTarget)usageTargets[0]).getElement()) != null) {
            this.startFindUsages(element2, popupPosition, editor, 100);
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public void startFindUsages(@NotNull PsiElement element, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/ShowUsagesAction", "startFindUsages"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "startFindUsages"));
        }
        Project project2 = element.getProject();
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, false);
        if (handler2 == null) {
            return;
        }
        if (this.myShowSettingsDialogBefore) {
            this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
            return;
        }
        this.showElementUsages(editor, popupPosition, handler2, maxUsages, handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext()));
    }

    private void showElementUsages(Editor editor, @NotNull RelativePoint popupPosition, @NotNull FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options) {
        JBPopup popup2;
        PsiReference reference;
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showElementUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "showElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "showElementUsages"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        UsageViewSettings savedGlobalSettings = new UsageViewSettings();
        savedGlobalSettings.loadState(usageViewSettings);
        usageViewSettings.loadState(this.myUsageViewSettings);
        Project project2 = handler2.getProject();
        UsageViewManager manager = UsageViewManager.getInstance((Project)project2);
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
        UsageViewPresentation presentation = findUsagesManager.createPresentation(handler2, options);
        presentation.setDetachedMode(true);
        UsageViewImpl usageView2 = (UsageViewImpl)manager.createUsageView(UsageTarget.EMPTY_ARRAY, Usage.EMPTY_ARRAY, presentation, null);
        if (editor != null && (reference = TargetElementUtil.findReference(editor)) != null) {
            UsageInfo2UsageAdapter origin = new UsageInfo2UsageAdapter(new UsageInfo(reference));
            usageView2.setOriginUsage((Usage)origin);
        }
        Disposer.register((Disposable)usageView2, () -> {
            this.myUsageViewSettings.loadState(usageViewSettings);
            usageViewSettings.loadState(savedGlobalSettings);
        });
        MyTable table2 = new MyTable();
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        ShowUsagesAction.addUsageNodes(usageView2.getRoot(), usageView2, new ArrayList<UsageNode>());
        ArrayList<Usage> usages = new ArrayList<Usage>();
        LinkedHashSet<UsageNode> visibleNodes = new LinkedHashSet<UsageNode>();
        List<UsageNode> data = ShowUsagesAction.collectData(usages, visibleNodes, usageView2, presentation);
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        ShowUsagesAction.setTableModel((JTable)((Object)table2), usageView2, data, outOfScopeUsages, options.searchScope);
        boolean isPreviewMode = Boolean.TRUE == PreviewManager.SERVICE.preview(handler2.getProject(), UsagesPreviewPanelProvider.ID, Pair.create((Object)usageView2, (Object)((Object)table2)), false);
        Runnable itemChosenCallback = this.prepareTable(table2, editor, popupPosition, handler2, maxUsages, options, isPreviewMode);
        JBPopup jBPopup = popup2 = isPreviewMode ? null : this.createUsagePopup(usages, visibleNodes, handler2, editor, popupPosition, maxUsages, usageView2, options, (JTable)((Object)table2), itemChosenCallback, presentation, processIcon);
        if (popup2 != null) {
            Disposer.register(popup2, (Disposable)usageView2);
            Alarm alarm = new Alarm((Disposable)usageView2);
            alarm.addRequest(() -> {
                if (popupPosition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$3"));
                }
                ShowUsagesAction.showPopupIfNeedTo(popup2, popupPosition);
            }, 300);
        }
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", o2 -> popup2 != null && popup2.isDisposed(), 100, () -> {
            ArrayList<Usage> copy;
            if (popupPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$5"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$5"));
            }
            if (popup2 != null && popup2.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>();
            List list2 = usages;
            synchronized (list2) {
                if (!(popup2 == null || popup2.isVisible() || usages.size() > 1 && ShowUsagesAction.showPopupIfNeedTo(popup2, popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView2.getRoot(), usageView2, nodes);
                copy = new ArrayList<Usage>(usages);
            }
            this.rebuildTable(usageView2, copy, nodes, (JTable)((Object)table2), popup2, presentation, popupPosition, !processIcon.isDisposed(), outOfScopeUsages, options.searchScope);
        });
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)usageView2);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, pingEDT::ping);
        UsageTarget[] myUsageTarget = new UsageTarget[]{new PsiElement2UsageTargetAdapter(handler2.getPsiElement())};
        Processor collect = usage -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$7"));
            }
            if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)options.searchScope)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleNodes.add(USAGES_OUTSIDE_SCOPE_NODE);
                    usages.add(USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.size() >= maxUsages) {
                    return false;
                }
                if (UsageViewManager.isSelfUsage((Usage)usage, (UsageTarget[])myUsageTarget)) {
                    return true;
                }
                UsageNode node = (UsageNode)ReadAction.compute(() -> usageView2.doAppendUsage(usage));
                usages.add((Usage)usage);
                if (node != null) {
                    visibleNodes.add(node);
                    boolean continueSearch = true;
                    if (visibleNodes.size() == maxUsages) {
                        visibleNodes.add(MORE_USAGES_SEPARATOR_NODE);
                        usages.add(MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        ProgressIndicator indicator = FindUsagesManager.startProcessUsages(handler2, handler2.getPrimaryElements(), handler2.getSecondaryElements(), (Processor<Usage>)collect, options, () -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$9"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$9"));
            }
            if (popupPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$showElementUsages$9"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (options == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$8"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$8"));
                }
                if (popupPosition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$8"));
                }
                Disposer.dispose((Disposable)processIcon);
                Container parent = processIcon.getParent();
                if (parent != null) {
                    parent.remove((Component)processIcon);
                    parent.repaint();
                }
                pingEDT.ping();
                List list2 = usages;
                synchronized (list2) {
                    if (visibleNodes.isEmpty()) {
                        if (usages.isEmpty()) {
                            String text2 = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(options)});
                            this.hint(editor, text2, handler2, popupPosition, maxUsages, options, false);
                            ShowUsagesAction.cancel(popup2);
                        }
                    } else if (visibleNodes.size() == 1) {
                        if (usages.size() == 1) {
                            Usage usage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                            if (usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                                this.hint(editor, UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)options.searchScope), handler2, popupPosition, maxUsages, options, true);
                            } else {
                                String message2 = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(options)});
                                this.navigateAndHint(usage, message2, handler2, popupPosition, maxUsages, options);
                            }
                            ShowUsagesAction.cancel(popup2);
                        } else {
                            assert (usages.size() > 1) : usages;
                            Usage visibleUsage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                            if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                                String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), ShowUsagesAction.searchScopePresentableName(options)});
                                this.navigateAndHint(visibleUsage, hint, handler2, popupPosition, maxUsages, options);
                                ShowUsagesAction.cancel(popup2);
                            }
                        }
                    } else if (popup2 != null) {
                        String title = presentation.getTabText();
                        boolean shouldShowMoreSeparator = visibleNodes.contains(MORE_USAGES_SEPARATOR_NODE);
                        String fullTitle = ShowUsagesAction.getFullTitle(usages, title, shouldShowMoreSeparator, visibleNodes.size() - (shouldShowMoreSeparator ? 1 : 0), false);
                        ((AbstractPopup)popup2).setCaption(fullTitle);
                    }
                }
            }, project2.getDisposed());
        });
        if (popup2 != null) {
            Disposer.register((Disposable)popup2, () -> ((ProgressIndicator)indicator).cancel());
        }
    }

    @NotNull
    private static UsageNode createStringNode(@NotNull Object string2) {
        if (string2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction", "createStringNode"));
        }
        StringNode stringNode = new StringNode(string2);
        if (stringNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createStringNode"));
        }
        return stringNode;
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (popup2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/find/actions/ShowUsagesAction", "showPopupIfNeedTo"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showPopupIfNeedTo"));
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private JComponent createHintComponent(@NotNull String text2, final @NotNull FindUsagesHandler handler2, final @NotNull RelativePoint popupPosition, final Editor editor, @NotNull Runnable cancelAction2, final int maxUsages, final @NotNull FindUsagesOptions options, boolean isWarning) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (cancelAction2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelAction", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        JComponent label = HintUtil.createInformationLabel(ShowUsagesAction.suggestSecondInvocation(options, handler2, text2 + "&nbsp;"));
        if (isWarning) {
            label.setBackground(MessageType.WARNING.getPopupBackground());
        }
        InplaceButton button = this.createSettingsButton(handler2, popupPosition, editor, maxUsages, cancelAction2);
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                ShowUsagesAction.this.mySearchEverywhereRunnable = () -> {
                    if (options == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction$1", "lambda$addNotify$0"));
                    }
                    if (handler2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction$1", "lambda$addNotify$0"));
                    }
                    if (popupPosition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction$1", "lambda$addNotify$0"));
                    }
                    ShowUsagesAction.this.searchEverywhere(options, handler2, editor, popupPosition, maxUsages);
                };
                super.addNotify();
            }

            @Override
            public void removeNotify() {
                ShowUsagesAction.this.mySearchEverywhereRunnable = null;
                super.removeNotify();
            }
        };
        button.setBackground(label.getBackground());
        panel2.setBackground(label.getBackground());
        label.setOpaque(false);
        label.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label, "Center");
        panel2.add((Component)button, "East");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        return jPanel;
    }

    @NotNull
    private InplaceButton createSettingsButton(@NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages, @NotNull Runnable cancelAction2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        if (cancelAction2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelAction", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        String shortcutText = "";
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            shortcutText = "(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")";
        }
        InplaceButton inplaceButton = new InplaceButton("Settings..." + shortcutText, AllIcons.General.Settings, e2 -> {
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$createSettingsButton$11"));
            }
            if (popupPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$createSettingsButton$11"));
            }
            if (cancelAction2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelAction", "com/intellij/find/actions/ShowUsagesAction", "lambda$createSettingsButton$11"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$10"));
                }
                if (popupPosition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$10"));
                }
                this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
            });
            cancelAction2.run();
        });
        if (inplaceButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        return inplaceButton;
    }

    private void showDialogAndFindUsages(@NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "showDialogAndFindUsages"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showDialogAndFindUsages"));
        }
        AbstractFindUsagesDialog dialog2 = handler2.getFindUsagesDialog(false, false, false);
        if (dialog2.showAndGet()) {
            dialog2.calcFindUsagesOptions();
            FindUsagesOptions options = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
            this.showElementUsages(editor, popupPosition, handler2, maxUsages, options);
        }
    }

    @NotNull
    private static String searchScopePresentableName(@NotNull FindUsagesOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "searchScopePresentableName"));
        }
        String string2 = options.searchScope.getDisplayName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "searchScopePresentableName"));
        }
        return string2;
    }

    @NotNull
    private Runnable prepareTable(MyTable table2, Editor editor, RelativePoint popupPosition, FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options, boolean previewMode) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "prepareTable"));
        }
        MySpeedSearch speedSearch = new MySpeedSearch(table2);
        speedSearch.setComparator(new SpeedSearchComparator(false));
        table2.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        table2.setShowGrid(false);
        table2.setShowVerticalLines(false);
        table2.setShowHorizontalLines(false);
        table2.setTableHeader(null);
        table2.setAutoResizeMode(3);
        table2.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        table2.getSelectionModel().addListSelectionListener(e2 -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            ArrayList<Usage> usages = null;
            for (int i2 : table2.getSelectedRows()) {
                Object value2 = table2.getValueAt(i2, 0);
                if (!(value2 instanceof UsageNode)) continue;
                Usage usage = ((UsageNode)value2).getUsage();
                if (usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Usage>();
                }
                usages.add((Usage)(usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getUsageInfo().copy() : usage));
            }
            selectedUsages.set(usages);
        });
        final Runnable itemChosenCallback = () -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$prepareTable$13"));
            }
            if (moreUsagesSelected.get()) {
                this.appendMoreUsages(editor, popupPosition, handler2, maxUsages, options);
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                options.searchScope = GlobalSearchScope.projectScope((Project)handler2.getProject());
                this.showElementUsages(editor, popupPosition, handler2, maxUsages, options);
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage : usages) {
                    if (usage instanceof UsageInfo) {
                        UsageViewUtil.navigateTo((UsageInfo)usage, true);
                        continue;
                    }
                    if (!(usage instanceof Navigatable)) continue;
                    ((Navigatable)usage).navigate(true);
                }
            }
        };
        if (previewMode) {
            table2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e2) {
                    if (UIUtil.isActionClick((MouseEvent)e2, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e2) && !e2.isConsumed()) {
                        itemChosenCallback.run();
                    }
                }
            });
            table2.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e2) {
                    if (e2.getKeyCode() == 10) {
                        itemChosenCallback.run();
                    }
                }
            });
        }
        Runnable runnable2 = itemChosenCallback;
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "prepareTable"));
        }
        return runnable2;
    }

    @NotNull
    private JBPopup createUsagePopup(@NotNull List<Usage> usages, @NotNull Set<UsageNode> visibleNodes, final @NotNull FindUsagesHandler handler2, final Editor editor, final @NotNull RelativePoint popupPosition, final int maxUsages, @NotNull UsageViewImpl usageView2, final @NotNull FindUsagesOptions options, @NotNull JTable table2, @NotNull Runnable itemChoseCallback, @NotNull UsageViewPresentation presentation, final @NotNull AsyncProcessIcon processIcon) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (itemChoseCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemChoseCallback", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (processIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processIcon", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PopupChooserBuilder builder = new PopupChooserBuilder(table2);
        String title = presentation.getTabText();
        if (title != null) {
            String result2 = ShowUsagesAction.getFullTitle(usages, title, false, visibleNodes.size() - 1, true);
            builder.setTitle(result2);
            builder.setAdText(ShowUsagesAction.getSecondInvocationTitle(options, handler2));
        }
        builder.setMovable(true).setResizable(true);
        builder.setMovable(true).setResizable(true);
        builder.setItemChoosenCallback(itemChoseCallback);
        final JBPopup[] popup2 = new JBPopup[1];
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$4", "actionPerformed"));
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
                }

                public boolean startInTransaction() {
                    return true;
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table2);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$5", "actionPerformed"));
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.this.searchEverywhere(options, handler2, editor, popupPosition, maxUsages);
                }

                public boolean startInTransaction() {
                    return true;
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table2);
        }
        InplaceButton settingsButton = this.createSettingsButton(handler2, popupPosition, editor, maxUsages, () -> ShowUsagesAction.cancel(popup2[0]));
        ActiveComponent.Adapter spinningProgress = new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return processIcon;
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = this.createPinButton(handler2, usageView2, options, popup2, pinGroup);
        builder.setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{spinningProgress, settingsButton, pin}));
        DefaultActionGroup toolbar = new DefaultActionGroup();
        usageView2.addFilteringActions(toolbar);
        toolbar.add((AnAction)UsageGroupingRuleProviderImpl.createGroupByFileStructureAction((UsageViewImpl)usageView2));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)toolbar, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder.setSettingButton((Component)toolBar);
        builder.setCancelKeyEnabled(false);
        popup2[0] = builder.createPopup();
        JComponent content2 = popup2[0].getContent();
        this.myWidth = (int)(toolBar.getPreferredSize().getWidth() + new JLabel(ShowUsagesAction.getFullTitle(usages, title, false, visibleNodes.size() - 1, true)).getPreferredSize().getWidth() + settingsButton.getPreferredSize().getWidth());
        this.myWidth = -1;
        for (AnAction action2 : toolbar.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView2.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView2.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        JBPopup jBPopup = popup2[0];
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        return jBPopup;
    }

    private ActiveComponent createPinButton(final @NotNull FindUsagesHandler handler2, final @NotNull UsageViewImpl usageView2, final @NotNull FindUsagesOptions options, final @NotNull JBPopup[] popup2, @NotNull DefaultActionGroup pinGroup) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (popup2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (pinGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pinGroup", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        AnAction pinAction = new AnAction("Open Find Usages Toolwindow", "Show all usages in a separate toolwindow", AllIcons.General.AutohideOff){
            {
                super(arg0, arg1, arg2);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            public boolean startInTransaction() {
                return true;
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$7", "actionPerformed"));
                }
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel(popup2[0]);
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)usageView2.getProject())).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)pinGroup, true);
        pinToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return pinToolBar;
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @NotNull
    private static String getFullTitle(@NotNull List<Usage> usages, @NotNull String title, boolean hadMoreSeparator, int visibleNodesCount, boolean findUsagesInProgress) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "getFullTitle"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/actions/ShowUsagesAction", "getFullTitle"));
        }
        String soFarSuffix = findUsagesInProgress ? " so far" : "";
        String s2 = hadMoreSeparator ? "<b>Some</b> " + title + " <b>(Only " + visibleNodesCount + " usages shown" + soFarSuffix + ")</b>" : title + " (" + UsageViewBundle.message((String)"usages.n", (Object[])new Object[]{usages.size()}) + soFarSuffix + ")";
        String string2 = "<html><nobr>" + s2 + "</nobr></html>";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "getFullTitle"));
        }
        return string2;
    }

    @NotNull
    private static String suggestSecondInvocation(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2, @NotNull String text2) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        String title = ShowUsagesAction.getSecondInvocationTitle(options, handler2);
        if (title != null) {
            text2 = text2 + "<br><small> " + title + "</small>";
        }
        String string2 = XmlStringUtil.wrapInHtml((CharSequence)UIUtil.convertSpace2Nbsp((String)text2));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        return string2;
    }

    @Nullable
    private static String getSecondInvocationTitle(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2) {
        GlobalSearchScope maximalScope;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "getSecondInvocationTitle"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "getSecondInvocationTitle"));
        }
        if (ShowUsagesAction.getShowUsagesShortcut() != null && !options.searchScope.equals(maximalScope = FindUsagesManager.getMaximalScope(handler2))) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)ShowUsagesAction.getShowUsagesShortcut()) + " again to search in " + maximalScope.getDisplayName();
        }
        return null;
    }

    private void searchEverywhere(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2, Editor editor, @NotNull RelativePoint popupPosition, int maxUsages) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "searchEverywhere"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "searchEverywhere"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "searchEverywhere"));
        }
        FindUsagesOptions cloned = options.clone();
        cloned.searchScope = FindUsagesManager.getMaximalScope(handler2);
        this.showElementUsages(editor, popupPosition, handler2, maxUsages, cloned);
    }

    @Nullable
    private static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int filtered(@NotNull List<Usage> usages, @NotNull UsageViewImpl usageView2) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "filtered"));
        }
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "filtered"));
        }
        return (int)usages.stream().filter(usage -> {
            if (usageView2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "lambda$filtered$15"));
            }
            return !usageView2.isVisible(usage);
        }).count();
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction", "getUsageOffset"));
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element == null) {
            return -1;
        }
        return element.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<Usage> usages) {
        if (visibleUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleUsage", "com/intellij/find/actions/ShowUsagesAction", "areAllUsagesInOneLine"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "areAllUsagesInOneLine"));
        }
        Editor editor = ShowUsagesAction.getEditorFor(visibleUsage);
        if (editor == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage other : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(other);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(other);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static MyModel setTableModel(@NotNull JTable table2, @NotNull UsageViewImpl usageView2, @NotNull List<UsageNode> data, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        MyModel model2;
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (outOfScopeUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outOfScopeUsages", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesAction.calcColumnCount(data);
        MyModel myModel = model2 = table2.getModel() instanceof MyModel ? (MyModel)((Object)table2.getModel()) : null;
        if (model2 == null || model2.getColumnCount() != columnCount) {
            model2 = new MyModel(data, columnCount);
            table2.setModel((TableModel)((Object)model2));
            ShowUsagesTableCellRenderer renderer = new ShowUsagesTableCellRenderer(usageView2, outOfScopeUsages, searchScope);
            for (int i2 = 0; i2 < table2.getColumnModel().getColumnCount(); ++i2) {
                TableColumn column = table2.getColumnModel().getColumn(i2);
                column.setPreferredWidth(0);
                column.setCellRenderer(renderer);
            }
        }
        MyModel myModel2 = model2;
        if (myModel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        return myModel2;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction", "calcColumnCount"));
        }
        return data.isEmpty() || data.get(0) instanceof StringNode ? 1 : 3;
    }

    @NotNull
    private static List<UsageNode> collectData(@NotNull List<Usage> usages, @NotNull Collection<UsageNode> visibleNodes, @NotNull UsageViewImpl usageView2, @NotNull UsageViewPresentation presentation) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        ArrayList<UsageNode> data = new ArrayList<UsageNode>();
        int filtered = ShowUsagesAction.filtered(usages, usageView2);
        if (filtered != 0) {
            data.add(ShowUsagesAction.createStringNode(UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filtered})));
        }
        data.addAll(visibleNodes);
        if (data.isEmpty()) {
            String progressText = StringUtil.escapeXml((String)UsageViewManagerImpl.getProgressTitle((UsageViewPresentation)presentation));
            data.add(ShowUsagesAction.createStringNode(progressText));
        }
        Collections.sort(data, USAGE_NODE_COMPARATOR);
        ArrayList<UsageNode> arrayList = data;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        return arrayList;
    }

    private static int calcMaxWidth(JTable table2) {
        int colsNum = table2.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table2.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table2, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table2, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table2, int col) {
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "columnMaxWidth"));
        }
        TableColumn column = table2.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table2.getRowCount(); ++row) {
            Component component = table2.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table2.getIntercellSpacing().width);
        }
        return width;
    }

    private void rebuildTable(@NotNull UsageViewImpl usageView2, @NotNull List<Usage> usages, @NotNull List<UsageNode> nodes, @NotNull JTable table2, @Nullable JBPopup popup2, @NotNull UsageViewPresentation presentation, @NotNull RelativePoint popupPosition, boolean findUsagesInProgress, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        int row;
        List existingData;
        List<UsageNode> data;
        MyModel tableModel2;
        int newSelection;
        boolean hasOutsideScopeUsages;
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (outOfScopeUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outOfScopeUsages", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean shouldShowMoreSeparator = usages.contains(MORE_USAGES_SEPARATOR);
        if (shouldShowMoreSeparator) {
            nodes.add(MORE_USAGES_SEPARATOR_NODE);
        }
        if ((hasOutsideScopeUsages = usages.contains(USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
            nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
        }
        String title = presentation.getTabText();
        String fullTitle = ShowUsagesAction.getFullTitle(usages, title, shouldShowMoreSeparator || hasOutsideScopeUsages, nodes.size() - (shouldShowMoreSeparator || hasOutsideScopeUsages ? 1 : 0), findUsagesInProgress);
        if (popup2 != null) {
            ((AbstractPopup)popup2).setCaption(fullTitle);
        }
        if ((newSelection = ShowUsagesAction.updateModel(tableModel2 = ShowUsagesAction.setTableModel(table2, usageView2, data = ShowUsagesAction.collectData(usages, nodes, usageView2, presentation), outOfScopeUsages, searchScope), existingData = tableModel2.getItems(), data, (row = table2.getSelectedRow()) == -1 ? 0 : row)) < 0 || newSelection >= tableModel2.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)table2);
            newSelection = table2.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table2.getModel().getRowCount() > 1 && (valueInTopRow = table2.getModel().getValueAt(0, 0)) instanceof UsageNode && usageView2.isOriginUsage(((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table2.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)table2, (int)newSelection, (int)0);
        if (popup2 != null) {
            this.setSizeAndDimensions(table2, popup2, popupPosition, data);
        }
    }

    private static int updateModel(@NotNull MyModel tableModel2, @NotNull List<UsageNode> listOld, @NotNull List<UsageNode> listNew, int oldSelection) {
        if (tableModel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/find/actions/ShowUsagesAction", "updateModel"));
        }
        if (listOld == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOld", "com/intellij/find/actions/ShowUsagesAction", "updateModel"));
        }
        if (listNew == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listNew", "com/intellij/find/actions/ShowUsagesAction", "updateModel"));
        }
        Object[] oa = listOld.toArray(new UsageNode[listOld.size()]);
        Object[] na = listNew.toArray(new UsageNode[listNew.size()]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel2, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private void setSizeAndDimensions(@NotNull JTable table2, @NotNull JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull List<UsageNode> data) {
        int newWidth;
        if (table2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        if (popup2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        JComponent content2 = popup2.getContent();
        Window window = SwingUtilities.windowForComponent(content2);
        Dimension d2 = window.getSize();
        int width = ShowUsagesAction.calcMaxWidth(table2);
        width = (int)Math.max(d2.getWidth(), (double)width);
        Dimension headerSize = ((AbstractPopup)popup2).getHeaderPreferredSize();
        width = Math.max((int)headerSize.getWidth(), width);
        width = Math.max(this.myWidth, width);
        if (this.myWidth == -1) {
            this.myWidth = width;
        }
        this.myWidth = newWidth = Math.max(width, d2.width + width - this.myWidth);
        int rowsToShow = Math.min(30, data.size());
        Dimension dimension = new Dimension(newWidth, table2.getRowHeight() * rowsToShow);
        Rectangle rectangle = ShowUsagesAction.fitToScreen(dimension, popupPosition, table2);
        if (!data.isEmpty()) {
            ScrollingUtil.ensureSelectionExists((JTable)table2);
        }
        table2.setSize(rectangle.getSize());
        Dimension footerSize = ((AbstractPopup)popup2).getFooterPreferredSize();
        int footer = footerSize.height;
        int footerBorder = footer == 0 ? 0 : 1;
        Insets insets = ((AbstractPopup)popup2).getPopupBorder().getBorderInsets((Component)content2);
        rectangle.height += headerSize.height + footer + footerBorder + insets.top + insets.bottom;
        ScreenUtil.fitToScreen((Rectangle)rectangle);
        Dimension newDim = rectangle.getSize();
        window.setBounds(rectangle);
        window.setMinimumSize(newDim);
        window.setMaximumSize(newDim);
        window.validate();
        window.repaint();
    }

    private static Rectangle fitToScreen(@NotNull Dimension newDim, @NotNull RelativePoint popupPosition, JTable table2) {
        if (newDim == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDim", "com/intellij/find/actions/ShowUsagesAction", "fitToScreen"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "fitToScreen"));
        }
        Rectangle rectangle = new Rectangle(popupPosition.getScreenPoint(), newDim);
        ScreenUtil.fitToScreen((Rectangle)rectangle);
        if (rectangle.getHeight() != newDim.getHeight()) {
            int newHeight = (int)rectangle.getHeight();
            int roundedHeight = newHeight - newHeight % table2.getRowHeight();
            rectangle.setSize((int)rectangle.getWidth(), Math.max(roundedHeight, table2.getRowHeight()));
        }
        return rectangle;
    }

    private void appendMoreUsages(Editor editor, @NotNull RelativePoint popupPosition, @NotNull FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options) {
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "appendMoreUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "appendMoreUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "appendMoreUsages"));
        }
        TransactionGuard.submitTransaction((Disposable)handler2.getProject(), () -> {
            if (popupPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$appendMoreUsages$16"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$appendMoreUsages$16"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$appendMoreUsages$16"));
            }
            this.showElementUsages(editor, popupPosition, handler2, maxUsages + 100, options);
        });
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView2, @NotNull List<UsageNode> outNodes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/find/actions/ShowUsagesAction", "addUsageNodes"));
        }
        if (usageView2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "addUsageNodes"));
        }
        if (outNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outNodes", "com/intellij/find/actions/ShowUsagesAction", "addUsageNodes"));
        }
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView2.isVisible(usage)) continue;
            node.setParent((MutableTreeNode)root);
            outNodes.add(node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView2, outNodes);
        }
    }

    private void navigateAndHint(@NotNull Usage usage, @Nullable String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        usage.navigate(true);
        if (hint == null) {
            return;
        }
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        this.hint(newEditor, hint, handler2, popupPosition, maxUsages, options, false);
    }

    private void showHint(@Nullable Editor editor, @NotNull String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options, boolean isWarning) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        Runnable runnable2 = () -> {
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$showHint$17"));
            }
            if (hint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "lambda$showHint$17"));
            }
            if (popupPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$showHint$17"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$showHint$17"));
            }
            if (!handler2.getPsiElement().isValid()) {
                return;
            }
            JComponent label = this.createHintComponent(hint, handler2, popupPosition, editor, ShowUsagesAction::hideHints, maxUsages, options, isWarning);
            if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
                HintManager.getInstance().showHint(label, popupPosition, 42, 0);
            } else {
                HintManager.getInstance().showInformationHint(editor, label);
            }
        };
        if (editor == null) {
            runnable2.run();
        } else {
            AsyncEditorLoader.performWhenLoaded(editor, runnable2);
        }
    }

    private void hint(@Nullable Editor editor, @NotNull String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options, boolean isWarning) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        Project project2 = handler2.getProject();
        IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> {
            if (hint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "lambda$hint$20"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$hint$20"));
            }
            if (popupPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$hint$20"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$hint$20"));
            }
            Runnable runnable2 = () -> {
                if (hint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$19"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$19"));
                }
                if (popupPosition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$19"));
                }
                if (options == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$19"));
                }
                IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> {
                    if (hint == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$18"));
                    }
                    if (handler2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$18"));
                    }
                    if (popupPosition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$18"));
                    }
                    if (options == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "lambda$null$18"));
                    }
                    this.showHint(editor, hint, handler2, popupPosition, maxUsages, options, isWarning);
                });
            };
            if (editor == null) {
                runnable2.run();
            } else {
                editor.getScrollingModel().runActionOnScrollingFinished(runnable2);
            }
        });
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction", "getEditorFor"));
        }
        FileEditorLocation location = usage.getLocation();
        FileEditor newFileEditor = location == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull MyTable table2) {
            if (table2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction$MySpeedSearch", "<init>"));
            }
            super(table2);
        }

        @Override
        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        @Override
        protected int convertIndexToModel(int viewIndex) {
            return this.getTable().convertRowIndexToModel(viewIndex);
        }

        @Override
        @NotNull
        protected Object[] getAllElements() {
            Object[] objectArray = ((MyModel)((Object)this.getTable().getModel())).getItems().toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$MySpeedSearch", "getAllElements"));
            }
            return objectArray;
        }

        @Override
        protected String getElementText(@NotNull Object element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/ShowUsagesAction$MySpeedSearch", "getElementText"));
            }
            if (!(element instanceof UsageNode)) {
                return element.toString();
            }
            UsageNode node = (UsageNode)element;
            if (node instanceof StringNode) {
                return "";
            }
            Usage usage = node.getUsage();
            if (usage == MORE_USAGES_SEPARATOR || usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                return "";
            }
            GroupNode group = (GroupNode)node.getParent();
            String groupText = group == null ? "" : group.getGroup().getText(null);
            return groupText + usage.getPresentation().getPlainText();
        }

        @Override
        protected void selectElement(Object element, String selectedText) {
            List data = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i2 = data.indexOf(element);
            if (i2 == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i2);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private MyTable getTable() {
            return (MyTable)((Object)this.myComponent);
        }
    }

    static class StringNode
    extends UsageNode {
        @NotNull
        private final Object myString;

        StringNode(@NotNull Object string2) {
            if (string2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction$StringNode", "<init>"));
            }
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string2;
        }

        public String toString() {
            return this.myString.toString();
        }
    }

    private static class MyTable
    extends JBTable
    implements DataProvider {
        private static final int MARGIN = 2;

        public MyTable() {
            ScrollingUtil.installActions((JTable)((Object)this));
            HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                int[] selected = this.getSelectedRows();
                if (selected.length == 1) {
                    return MyTable.getPsiElementForHint(this.getValueAt(selected[0], 0));
                }
            } else if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                return PopupUtil.getPopupContainerFor((Component)((Object)this));
            }
            return null;
        }

        public int getRowHeight() {
            return super.getRowHeight() + 4;
        }

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/find/actions/ShowUsagesAction$MyTable", "prepareRenderer"));
            }
            Component component = super.prepareRenderer(renderer, row, column);
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)0));
            }
            Component component2 = component;
            if (component2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$MyTable", "prepareRenderer"));
            }
            return component2;
        }

        @Nullable
        private static PsiElement getPsiElementForHint(Object selectedValue) {
            PsiElement element;
            Usage usage;
            if (selectedValue instanceof UsageNode && (usage = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
                PsiElement view2 = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element);
                return view2 == null ? element : view2;
            }
            return null;
        }
    }

    private static class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<Object> {
        private MyModel(@NotNull List<UsageNode> data, int cols) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction$MyModel", "<init>"));
            }
            super(MyModel.cols(cols), data, 0);
        }

        @NotNull
        private static ColumnInfo[] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o2 = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node) {
                    return node;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o2);
            ColumnInfo[] columnInfoArray = list2.toArray(new ColumnInfo[list2.size()]);
            if (columnInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$MyModel", "cols"));
            }
            return columnInfoArray;
        }

        @Override
        public void addToModel(int idx, Object element) {
            UsageNode node;
            UsageNode usageNode = node = element instanceof UsageNode ? (UsageNode)element : ShowUsagesAction.createStringNode(element);
            if (idx < this.getRowCount()) {
                this.insertRow(idx, node);
            } else {
                this.addRow(node);
            }
        }

        @Override
        public void removeRangeFromModel(int start2, int end) {
            for (int i2 = end; i2 >= start2; --i2) {
                this.removeRow(i2);
            }
        }
    }
}

