/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PrevNextOccurrenceAction
extends DumbAwareAction
implements ContextAwareShortcutProvider {
    protected final boolean mySearch;

    PrevNextOccurrenceAction(@NotNull String templateActionId, boolean search) {
        if (templateActionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateActionId", "com/intellij/find/editorHeaderActions/PrevNextOccurrenceAction", "<init>"));
        }
        this.mySearch = search;
        this.copyFrom(ActionManager.getInstance().getAction(templateActionId));
    }

    public final void update(AnActionEvent e2) {
        SearchSession search = (SearchSession)e2.getData(SearchSession.KEY);
        boolean invokedByShortcut = !ActionPlaces.isToolbarPlace((String)e2.getPlace());
        e2.getPresentation().setEnabled(search != null && (invokedByShortcut || search.hasMatches()));
    }

    @Override
    @Nullable
    public final ShortcutSet getShortcut(@NotNull DataContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/find/editorHeaderActions/PrevNextOccurrenceAction", "getShortcut"));
        }
        SearchSession search = (SearchSession)SearchSession.KEY.getData(context2);
        boolean singleLine = search != null && !search.getFindModel().isMultiline();
        return Utils.shortcutSetOf(singleLine ? ContainerUtil.concat(this.getDefaultShortcuts(), this.getSingleLineShortcuts()) : this.getDefaultShortcuts());
    }

    @NotNull
    protected abstract List<Shortcut> getDefaultShortcuts();

    @NotNull
    protected abstract List<Shortcut> getSingleLineShortcuts();
}

