/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.FindSettings;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleWholeWordsOnlyAction
extends EditorHeaderToggleAction {
    public ToggleWholeWordsOnlyAction() {
        super("Wo&rds");
    }

    @Override
    public void update(AnActionEvent e2) {
        super.update(e2);
        SearchSession session2 = (SearchSession)e2.getData(SearchSession.KEY);
        e2.getPresentation().setEnabled(session2 != null && !session2.getFindModel().isRegularExpressions());
        e2.getPresentation().setVisible(session2 != null && !session2.getFindModel().isMultiline());
    }

    @Override
    protected boolean isSelected(@NotNull SearchSession session2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/find/editorHeaderActions/ToggleWholeWordsOnlyAction", "isSelected"));
        }
        return session2.getFindModel().isWholeWordsOnly();
    }

    @Override
    protected void setSelected(@NotNull SearchSession session2, boolean selected) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/find/editorHeaderActions/ToggleWholeWordsOnlyAction", "setSelected"));
        }
        FindSettings.getInstance().setLocalWholeWordsOnly(selected);
        session2.getFindModel().setWholeWordsOnly(selected);
    }
}

