/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UsageHistory {
    private final Map<ConfigurableUsageTarget, String> myHistory = new LinkedHashMap<ConfigurableUsageTarget, String>(EqualityPolicy.IDENTITY){

        protected boolean removeEldestEntry(Map.Entry<ConfigurableUsageTarget, String> eldest) {
            return this.size() > 15;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull ConfigurableUsageTarget usageTarget) {
        if (usageTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageTarget", "com/intellij/find/findUsages/UsageHistory", "add"));
        }
        String descriptiveName = usageTarget.getLongDescriptiveName();
        Map<ConfigurableUsageTarget, String> map2 = this.myHistory;
        synchronized (map2) {
            Set<Map.Entry<ConfigurableUsageTarget, String>> entries = this.myHistory.entrySet();
            Iterator<Map.Entry<ConfigurableUsageTarget, String>> iterator2 = entries.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().getValue().equals(descriptiveName)) continue;
                iterator2.remove();
            }
            this.myHistory.put(usageTarget, descriptiveName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<ConfigurableUsageTarget> getAll() {
        Map<ConfigurableUsageTarget, String> map2 = this.myHistory;
        // MONITORENTER : map2
        ArrayList result2 = ContainerUtil.newArrayList();
        Set<ConfigurableUsageTarget> entries = this.myHistory.keySet();
        Iterator<ConfigurableUsageTarget> iterator2 = entries.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                ArrayList arrayList = result2;
                // MONITOREXIT : map2
                if (arrayList != null) return arrayList;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/UsageHistory", "getAll"));
            }
            ConfigurableUsageTarget target = iterator2.next();
            if (!target.isValid()) {
                iterator2.remove();
                continue;
            }
            result2.add(target);
        }
    }
}

