/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.find.impl.RevealingSpaceComboboxEditor;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindDialog
extends DialogWrapper
implements FindUI {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindDialog");
    private final FindUIHelper myHelper;
    private ComboBox myInputComboBox;
    private ComboBox myReplaceComboBox;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private ComboBox mySearchContext;
    private StateRestoringCheckBox myCbRegularExpressions;
    private JRadioButton myRbGlobal;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbForward;
    private JRadioButton myRbBackward;
    private JRadioButton myRbFromCursor;
    private JRadioButton myRbEntireScope;
    private JRadioButton myRbProject;
    private JRadioButton myRbDirectory;
    private JRadioButton myRbModule;
    private ComboBox myModuleComboBox;
    private ComboBox myDirectoryComboBox;
    private StateRestoringCheckBox myCbWithSubdirectories;
    private JCheckBox myCbToOpenInNewTab;
    private FixedSizeButton mySelectDirectoryButton;
    private StateRestoringCheckBox myUseFileFilter;
    private ComboBox myFileFilter;
    private JCheckBox myCbToSkipResultsWhenOneUsage;
    private final Project myProject;
    private final Map<EditorTextField, DocumentAdapter> myComboBoxListeners = new HashMap<EditorTextField, DocumentAdapter>();
    private Action myFindAllAction;
    private JRadioButton myRbCustomScope;
    private ScopeChooserCombo myScopeCombo;
    protected JLabel myReplacePrompt;
    private HideableTitledPanel myScopePanel;
    private static boolean myPreviousResultsExpandedState = true;
    private static boolean myPreviewResultsTabWasSelected;
    private static final int RESULTS_PREVIEW_TAB_INDEX = 1;
    private Splitter myPreviewSplitter;
    private JBTable myResultsPreviewTable;
    private UsagePreviewPanel myUsagePreviewPanel;
    private TabbedPane myContent;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private static final String PREVIEW_TITLE;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;

    public FindDialog(FindUIHelper helper) {
        super(helper.getProject(), true);
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.setTitle(this.myHelper.getTitle());
        this.setOKButtonText(FindBundle.message("find.button", new Object[0]));
        this.init();
        this.initByModel();
        this.updateReplaceVisibility();
        this.validateFindButton();
        if (this.haveResultsPreview()) {
            ApplicationManager.getApplication().invokeLater(() -> this.scheduleResultsUpdate(), ModalityState.any());
        }
    }

    @Override
    public void showUI() {
        this.show();
    }

    public void doCancelAction() {
        this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel(), false);
        this.rememberResultsPreviewWasOpen();
        super.doCancelAction();
    }

    private void rememberResultsPreviewWasOpen() {
        int selectedIndex;
        if (this.myResultsPreviewTable != null && (selectedIndex = this.myContent.getSelectedIndex()) != -1) {
            myPreviewResultsTabWasSelected = selectedIndex == 1;
        }
    }

    protected void dispose() {
        this.finishPreviousPreviewSearch();
        if (this.mySearchRescheduleOnCancellationsAlarm != null) {
            Disposer.dispose((Disposable)this.mySearchRescheduleOnCancellationsAlarm);
        }
        if (this.myUsagePreviewPanel != null) {
            Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        }
        for (Map.Entry<EditorTextField, DocumentAdapter> e2 : this.myComboBoxListeners.entrySet()) {
            e2.getKey().removeDocumentListener((DocumentListener)e2.getValue());
        }
        this.myComboBoxListeners.clear();
        if (this.myScopePanel != null) {
            myPreviousResultsExpandedState = this.myScopePanel.isExpanded();
        }
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInputComboBox;
    }

    protected String getDimensionServiceKey() {
        return this.myHelper.getModel().isReplaceState() ? "replaceTextDialog" : "findTextDialog";
    }

    @NotNull
    protected Action[] createActions() {
        FindModel myModel = this.myHelper.getModel();
        if (!myModel.isMultipleFiles() && !myModel.isReplaceState() && myModel.isFindAllEnabled()) {
            Action[] actionArray = new Action[]{this.getFindAllAction(), this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createActions"));
        }
        return actionArray;
    }

    @NotNull
    private Action getFindAllAction() {
        this.myFindAllAction = new AbstractAction(FindBundle.message("find.all.button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.doOKAction(true);
            }
        };
        if (this.myFindAllAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "getFindAllAction"));
        }
        return this.myFindAllAction;
    }

    public JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JLabel prompt = new JLabel(FindBundle.message("find.text.to.find.label", new Object[0]));
        panel2.add((Component)prompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 4, 10), 0, 0));
        this.myInputComboBox = new ComboBox(300);
        this.revealWhitespaces(this.myInputComboBox);
        this.initCombobox(this.myInputComboBox);
        this.myReplaceComboBox = new ComboBox(300);
        this.revealWhitespaces(this.myReplaceComboBox);
        this.initCombobox(this.myReplaceComboBox);
        final Component editorComponent = this.myReplaceComboBox.getEditor().getEditorComponent();
        editorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                FindDialog.this.myReplaceComboBox.getEditor().selectAll();
                editorComponent.removeFocusListener(this);
            }
        });
        panel2.add((Component)this.myInputComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        prompt.setLabelFor(this.myInputComboBox.getEditor().getEditorComponent());
        this.myReplacePrompt = new JLabel(FindBundle.message("find.replace.with.label", new Object[0]));
        panel2.add((Component)this.myReplacePrompt, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 4, 10), 0, 0));
        panel2.add((Component)this.myReplaceComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.myReplacePrompt.setLabelFor(this.myReplaceComboBox.getEditor().getEditorComponent());
        return panel2;
    }

    private void revealWhitespaces(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/find/impl/FindDialog", "revealWhitespaces"));
        }
        RevealingSpaceComboboxEditor comboBoxEditor = new RevealingSpaceComboboxEditor(this.myProject, comboBox);
        comboBox.setEditor((ComboBoxEditor)comboBoxEditor);
        comboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboBoxEditor));
    }

    private void initCombobox(final @NotNull ComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/find/impl/FindDialog", "initCombobox"));
        }
        comboBox.setEditable(true);
        comboBox.setMaximumRowCount(8);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.validateFindButton();
            }
        });
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            EditorTextField etf = (EditorTextField)((Object)editorComponent);
            DocumentAdapter listener2 = new DocumentAdapter(){

                public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e2) {
                    FindDialog.this.handleComboBoxValueChanged(comboBox);
                }
            };
            etf.addDocumentListener((DocumentListener)listener2);
            this.myComboBoxListeners.put(etf, listener2);
        } else if (editorComponent instanceof JTextComponent) {
            final javax.swing.text.Document document = ((JTextComponent)editorComponent).getDocument();
            final com.intellij.ui.DocumentAdapter documentAdapter = new com.intellij.ui.DocumentAdapter(){

                protected void textChanged(DocumentEvent e2) {
                    FindDialog.this.handleAnyComboBoxValueChanged(comboBox);
                }
            };
            document.addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
            Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    document.removeDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
                }
            });
        } else assert (false);
        if (!this.myHelper.getModel().isReplaceState()) {
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(38, 0), "choosePrevious", () -> {
                int row = this.myResultsPreviewTable.getSelectedRow();
                if (row > 0) {
                    this.myResultsPreviewTable.setRowSelectionInterval(row - 1, row - 1);
                }
                TableUtil.scrollSelectionToVisible((JTable)this.myResultsPreviewTable);
            });
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(40, 0), "chooseNext", () -> {
                int row = this.myResultsPreviewTable.getSelectedRow();
                if (row >= -1 && row + 1 < this.myResultsPreviewTable.getRowCount()) {
                    this.myResultsPreviewTable.setRowSelectionInterval(row + 1, row + 1);
                    TableUtil.scrollSelectionToVisible((JTable)this.myResultsPreviewTable);
                }
            });
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(33, 0), "scrollUp", () -> ScrollingUtil.movePageUp((JTable)this.myResultsPreviewTable));
            this.makeResultsPreviewActionOverride((JComboBox)comboBox, KeyStroke.getKeyStroke(34, 0), "scrollDown", () -> ScrollingUtil.movePageDown((JTable)this.myResultsPreviewTable));
            final AnAction action2 = new AnAction(){

                public void actionPerformed(AnActionEvent e2) {
                    if (FindDialog.this.isResultsPreviewTabActive()) {
                        FindDialog.this.navigateToSelectedUsage(FindDialog.this.myResultsPreviewTable);
                    }
                }
            };
            action2.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)comboBox, this.myDisposable);
            new AnAction(){

                public void actionPerformed(AnActionEvent e2) {
                    if (!FindDialog.this.isResultsPreviewTabActive() || FindDialog.this.myResultsPreviewTable.getSelectedRowCount() == 0) {
                        FindDialog.this.doOKAction();
                    } else {
                        action2.actionPerformed(e2);
                    }
                }
            }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)comboBox, this.myDisposable);
        }
    }

    private boolean isResultsPreviewTabActive() {
        return this.myResultsPreviewTable != null && this.myContent.getSelectedIndex() == 1;
    }

    private void makeResultsPreviewActionOverride(final JComboBox component, KeyStroke keyStroke, String newActionKey, final Runnable newAction) {
        InputMap inputMap = component.getInputMap(1);
        Object action2 = inputMap.get(keyStroke);
        inputMap.put(keyStroke, newActionKey);
        final Action previousAction = action2 != null ? component.getActionMap().get(action2) : null;
        component.getActionMap().put(newActionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (FindDialog.this.isResultsPreviewTabActive() && !component.isPopupVisible()) {
                    newAction.run();
                    return;
                }
                if (previousAction != null) {
                    previousAction.actionPerformed(e2);
                }
            }
        });
    }

    private void handleComboBoxValueChanged(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/find/impl/FindDialog", "handleComboBoxValueChanged"));
        }
        Object item = comboBox.getEditor().getItem();
        if (item != null && !item.equals(comboBox.getSelectedItem())) {
            comboBox.setSelectedItem(item);
        }
        this.handleAnyComboBoxValueChanged(comboBox);
    }

    private void handleAnyComboBoxValueChanged(@NotNull ComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/find/impl/FindDialog", "handleAnyComboBoxValueChanged"));
        }
        if (comboBox != this.myReplaceComboBox) {
            this.scheduleResultsUpdate();
        }
        this.validateFindButton();
    }

    private void findSettingsChanged() {
        if (this.haveResultsPreview()) {
            Document document;
            ProgressIndicatorBase progressIndicatorWhenSearchStarted;
            final ModalityState state = ModalityState.current();
            if (state == ModalityState.NON_MODAL) {
                return;
            }
            this.finishPreviousPreviewSearch();
            this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
            final FindModel findModel = this.myHelper.getModel().clone();
            this.applyTo(findModel, false);
            ValidationInfo result2 = this.getValidationInfo(findModel);
            this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase();
            final DefaultTableModel model2 = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
            if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < findModel.getStringToFind().length()) {
                DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
                int len = previousModel.getRowCount();
                for (int i2 = 0; i2 < len; ++i2) {
                    UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)previousModel.getValueAt(i2, 0);
                    VirtualFile file2 = usage.getFile();
                    if (file2 == null) continue;
                    filesToScanInitially.add(file2);
                }
            }
            this.myHelper.myPreviousModel = findModel;
            model2.addColumn("Usages");
            this.myResultsPreviewTable.setModel((TableModel)model2);
            if (result2 != null) {
                this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                this.myContent.setTitleAt(1, PREVIEW_TITLE);
                return;
            }
            this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new UsageTableCellRenderer(false, true));
            this.myResultsPreviewTable.getEmptyText().setText("Searching...");
            this.myContent.setTitleAt(1, PREVIEW_TITLE);
            Component component = this.myInputComboBox.getEditor().getEditorComponent();
            if (component instanceof EditorTextField && (document = ((EditorTextField)((Object)component)).getDocument()) != null) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            }
            final AtomicInteger resultsCount = new AtomicInteger();
            final AtomicInteger resultsFilesCount = new AtomicInteger();
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myResultsPreviewSearchProgress, new ReadTask(){

                @Override
                @Nullable
                public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                    boolean succeeded;
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindDialog$11", "performInReadAction"));
                    }
                    UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModel);
                    boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
                    FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindDialog.this.myProject, showPanelIfOnlyOneUsage, presentation);
                    Ref lastUsageFileRef = new Ref();
                    FindInProjectUtil.findUsages(findModel, FindDialog.this.myProject, (Processor<UsageInfo>)((Processor)info -> {
                        if (this.isCancelled()) {
                            return false;
                        }
                        Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                        usage.getPresentation().getIcon();
                        VirtualFile file2 = (VirtualFile)lastUsageFileRef.get();
                        VirtualFile usageFile = info.getVirtualFile();
                        if (file2 == null || !file2.equals(usageFile)) {
                            resultsFilesCount.incrementAndGet();
                            lastUsageFileRef.set((Object)usageFile);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.isCancelled()) {
                                return;
                            }
                            model2.addRow(new Object[]{usage});
                        }, state);
                        return resultsCount.incrementAndGet() < 100;
                    }), processPresentation, filesToScanInitially);
                    boolean bl = succeeded = !progressIndicatorWhenSearchStarted.isCanceled();
                    if (succeeded) {
                        return new ReadTask.Continuation(() -> {
                            if (!this.isCancelled()) {
                                int occurrences = resultsCount.get();
                                int filesWithOccurrences = resultsFilesCount.get();
                                if (occurrences == 0) {
                                    FindDialog.this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                                }
                                boolean foundAllUsages = occurrences < 100;
                                FindDialog.this.myContent.setTitleAt(1, PREVIEW_TITLE + " (" + (foundAllUsages ? Integer.valueOf(occurrences) : occurrences + "+") + UIBundle.message((String)"message.matches", (Object[])new Object[]{occurrences}) + " in " + (foundAllUsages ? Integer.valueOf(filesWithOccurrences) : filesWithOccurrences + "+") + UIBundle.message((String)"message.files", (Object[])new Object[]{filesWithOccurrences}) + ")");
                            }
                        }, state);
                    }
                    return null;
                }

                boolean isCancelled() {
                    return progressIndicatorWhenSearchStarted != FindDialog.this.myResultsPreviewSearchProgress || FindDialog.this.myResultsPreviewSearchProgress.isCanceled();
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindDialog$11", "onCanceled"));
                    }
                    if (FindDialog.this.isShowing() && progressIndicatorWhenSearchStarted == FindDialog.this.myResultsPreviewSearchProgress) {
                        FindDialog.this.scheduleResultsUpdate();
                    }
                }
            });
        }
    }

    private void scheduleResultsUpdate() {
        Alarm alarm = this.mySearchRescheduleOnCancellationsAlarm;
        if (alarm == null || alarm.isDisposed()) {
            return;
        }
        alarm.cancelAllRequests();
        alarm.addRequest(() -> TransactionGuard.submitTransaction((Disposable)this.myDisposable, this::findSettingsChanged), 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    @Override
    public void updateReplaceVisibility() {
        boolean isReplaceState = this.myHelper.getModel().isReplaceState();
        this.myReplacePrompt.setVisible(isReplaceState);
        this.myReplaceComboBox.setVisible(isReplaceState);
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            this.myCbToSkipResultsWhenOneUsage.setVisible(!isReplaceState);
        }
        this.myCbPreserveCase.setVisible(isReplaceState);
        this.setTitle(this.myHelper.getTitle());
    }

    private void validateFindButton() {
        boolean okStatus = this.myHelper.canSearchThisString() || this.myRbDirectory != null && this.myRbDirectory.isSelected() && StringUtil.isEmpty((String)this.getDirectory());
        this.setOKStatus(okStatus);
    }

    private void setOKStatus(boolean value2) {
        this.setOKActionEnabled(value2);
        if (this.myFindAllAction != null) {
            this.myFindAllAction.setEnabled(value2);
        }
    }

    public JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        JPanel topOptionsPanel = new JPanel();
        topOptionsPanel.setLayout(new GridLayout(1, 2, 10, 0));
        topOptionsPanel.add(this.createFindOptionsPanel());
        optionsPanel.add((Component)topOptionsPanel, gbConstraints);
        JPanel resultsOptionPanel = null;
        if (this.myHelper.getModel().isMultipleFiles()) {
            optionsPanel.add((Component)this.createGlobalScopePanel(), gbConstraints);
            gbConstraints.weightx = 1.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.fill = 2;
            gbConstraints.gridwidth = 0;
            optionsPanel.add((Component)this.createFilterPanel(), gbConstraints);
            this.myCbToSkipResultsWhenOneUsage = FindDialog.createCheckbox(this.myHelper.isSkipResultsWithOneUsage(), FindBundle.message("find.options.skip.results.tab.with.one.occurrence.checkbox", new Object[0]));
            this.myCbToSkipResultsWhenOneUsage.addActionListener(e2 -> this.myHelper.setSkipResultsWithOneUsage(this.myCbToSkipResultsWhenOneUsage.isSelected()));
            resultsOptionPanel = this.createResultsOptionPanel(optionsPanel, gbConstraints);
            resultsOptionPanel.add(this.myCbToSkipResultsWhenOneUsage);
            this.myCbToSkipResultsWhenOneUsage.setVisible(!this.myHelper.isReplaceState());
            if (this.haveResultsPreview()) {
                JBTable table2 = new JBTable(){

                    public Dimension getPreferredSize() {
                        return new Dimension(FindDialog.this.myInputComboBox.getWidth(), super.getPreferredSize().height);
                    }
                };
                table2.setShowColumns(false);
                table2.setShowGrid(false);
                table2.setIntercellSpacing((Dimension)JBUI.emptySize());
                new NavigateToSourceListener().installOn((Component)table2);
                Splitter previewSplitter = new Splitter(true, 0.5f, 0.1f, 0.9f);
                this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation(), true);
                this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder());
                this.registerNavigateToSourceShortcutOnComponent(table2, (JComponent)this.myUsagePreviewPanel);
                this.myResultsPreviewTable = table2;
                new TableSpeedSearch((JTable)table2, new Convertor<Object, String>(){

                    public String convert(Object o2) {
                        return ((UsageInfo2UsageAdapter)o2).getFile().getName();
                    }
                });
                this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e2) {
                        if (e2.getValueIsAdjusting()) {
                            return;
                        }
                        int index = FindDialog.this.myResultsPreviewTable.getSelectionModel().getLeadSelectionIndex();
                        if (index != -1) {
                            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)FindDialog.this.myResultsPreviewTable.getModel().getValueAt(index, 0)).getUsageInfo();
                            FindDialog.this.myUsagePreviewPanel.updateLayout(usageInfo.isValid() ? Collections.singletonList(usageInfo) : null);
                            VirtualFile file2 = usageInfo.getVirtualFile();
                            FindDialog.this.myUsagePreviewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)(file2 != null ? file2.getPath() : ""), (boolean)false));
                        } else {
                            FindDialog.this.myUsagePreviewPanel.updateLayout(null);
                            FindDialog.this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder());
                        }
                    }
                });
                this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
                previewSplitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myResultsPreviewTable));
                previewSplitter.setSecondComponent(this.myUsagePreviewPanel.createComponent());
                this.myPreviewSplitter = previewSplitter;
            }
        } else {
            JPanel leftOptionsPanel = new JPanel();
            leftOptionsPanel.setLayout(new GridLayout(3, 1, 0, 4));
            leftOptionsPanel.add(this.createDirectionPanel());
            leftOptionsPanel.add(this.createOriginPanel());
            leftOptionsPanel.add(this.createScopePanel());
            topOptionsPanel.add(leftOptionsPanel);
        }
        if (this.myHelper.getModel().isOpenInNewTabVisible()) {
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.myCbToOpenInNewTab.setFocusable(false);
            this.myCbToOpenInNewTab.setSelected(this.myHelper.isUseSeparateView());
            this.myCbToOpenInNewTab.setEnabled(this.myHelper.getModel().isOpenInNewTabEnabled());
            this.myCbToOpenInNewTab.addActionListener(e2 -> this.myHelper.setUseSeparateView(this.myCbToOpenInNewTab.isSelected()));
            if (resultsOptionPanel == null) {
                resultsOptionPanel = this.createResultsOptionPanel(optionsPanel, gbConstraints);
            }
            resultsOptionPanel.add(this.myCbToOpenInNewTab);
        }
        if (this.myPreviewSplitter != null) {
            JBTabsPaneImpl pane = new JBTabsPaneImpl(this.myProject, 1, this.myDisposable);
            pane.insertTab("Options", null, optionsPanel, null, 0);
            pane.insertTab(PREVIEW_TITLE, null, (Component)this.myPreviewSplitter, null, 1);
            this.myContent = pane;
            DumbAwareAction anAction = new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e2) {
                    int selectedIndex = FindDialog.this.myContent.getSelectedIndex();
                    FindDialog.this.myContent.setSelectedIndex(1 - selectedIndex);
                }
            };
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction("Switcher").getShortcutSet();
            anAction.registerCustomShortcutSet(shortcutSet, (JComponent)this.getRootPane(), this.myDisposable);
            if (myPreviewResultsTabWasSelected) {
                this.myContent.setSelectedIndex(1);
            }
            return pane.getComponent();
        }
        return optionsPanel;
    }

    private boolean haveResultsPreview() {
        return Registry.is((String)"ide.find.show.preview") && this.myHelper.getModel().isMultipleFiles();
    }

    private JPanel createResultsOptionPanel(JPanel optionsPanel, GridBagConstraints gbConstraints) {
        JPanel resultsOptionPanel = new JPanel();
        resultsOptionPanel.setLayout(new BoxLayout(resultsOptionPanel, 1));
        this.myScopePanel = new HideableTitledPanel(FindBundle.message("results.options.group", new Object[0]), resultsOptionPanel, myPreviousResultsExpandedState);
        optionsPanel.add((Component)this.myScopePanel, gbConstraints);
        return resultsOptionPanel;
    }

    @NotNull
    private JComponent createFilterPanel() {
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BorderLayout());
        filterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.filter.file.name.group", new Object[0]), (boolean)true));
        this.myFileFilter = new ComboBox(100);
        this.initCombobox(this.myFileFilter);
        this.myUseFileFilter = FindDialog.createCheckbox(FindBundle.message("find.filter.file.mask.checkbox", new Object[0]));
        filterPanel.add((Component)this.myUseFileFilter, "West");
        filterPanel.add((Component)this.myFileFilter, "Center");
        FindDialog.initFileFilter((JComboBox)this.myFileFilter, this.myUseFileFilter);
        this.myUseFileFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
                FindDialog.this.validateFindButton();
            }
        });
        JPanel jPanel = filterPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createFilterPanel"));
        }
        return jPanel;
    }

    public static void initFileFilter(final @NotNull JComboBox fileFilter, final @NotNull JCheckBox useFileFilter) {
        if (fileFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFilter", "com/intellij/find/impl/FindDialog", "initFileFilter"));
        }
        if (useFileFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useFileFilter", "com/intellij/find/impl/FindDialog", "initFileFilter"));
        }
        fileFilter.setEditable(true);
        String[] fileMasks = FindSettings.getInstance().getRecentFileMasks();
        for (int i2 = fileMasks.length - 1; i2 >= 0; --i2) {
            fileFilter.addItem(fileMasks[i2]);
        }
        fileFilter.setEnabled(false);
        useFileFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (useFileFilter.isSelected()) {
                    fileFilter.setEnabled(true);
                    fileFilter.getEditor().selectAll();
                    fileFilter.getEditor().getEditorComponent().requestFocusInWindow();
                } else {
                    fileFilter.setEnabled(false);
                }
            }
        });
    }

    public void doOKAction() {
        this.doOKAction(false);
    }

    private void doOKAction(boolean findAll) {
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel, findAll);
        ValidationInfo validationInfo = this.getValidationInfo(validateModel);
        if (validationInfo == null) {
            this.myHelper.getModel().copyFrom(validateModel);
            this.myHelper.updateFindSettings();
            this.rememberResultsPreviewWasOpen();
            super.doOKAction();
            this.myHelper.doOKAction();
        } else {
            String message2 = validationInfo.message;
            Messages.showMessageDialog((Project)this.myProject, (String)message2, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    @Nullable(value="null means OK")
    private ValidationInfo getValidationInfo(@NotNull FindModel model2) {
        String mask;
        VirtualFile directory;
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindDialog", "getValidationInfo"));
        }
        if (this.myRbDirectory != null && this.myRbDirectory.isEnabled() && this.myRbDirectory.isSelected() && (directory = FindInProjectUtil.getDirectory(model2)) == null) {
            return new ValidationInfo(FindBundle.message("find.directory.not.found.error", this.getDirectory()), (JComponent)this.myDirectoryComboBox);
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo("String to find is empty", (JComponent)this.myInputComboBox);
        }
        if (this.myCbRegularExpressions != null && this.myCbRegularExpressions.isSelected() && this.myCbRegularExpressions.isEnabled()) {
            String toFind = this.getStringToFind();
            try {
                boolean isCaseSensitive = this.myCbCaseSensitive != null && this.myCbCaseSensitive.isSelected() && this.myCbCaseSensitive.isEnabled();
                Pattern pattern = Pattern.compile(toFind, isCaseSensitive ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.myInputComboBox);
                }
            }
            catch (PatternSyntaxException e2) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e2.getDescription()), (JComponent)this.myInputComboBox);
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), (JComponent)this.myFileFilter);
            }
            if (mask.contains(";")) {
                return new ValidationInfo("File masks should be comma-separated", (JComponent)this.myFileFilter);
            }
            try {
                FindInProjectUtil.createFileMaskCondition(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), (JComponent)this.myFileFilter);
            }
        }
        return null;
    }

    protected ValidationInfo doValidate() {
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel, false);
        ValidationInfo result2 = this.getValidationInfo(validateModel);
        this.setOKStatus(result2 == null);
        return result2;
    }

    public void doHelpAction() {
        FindModel myModel = this.myHelper.getModel();
        String id = myModel.isReplaceState() ? (myModel.isMultipleFiles() ? "reference.dialogs.findinpath" : "find.replaceOptions") : (myModel.isMultipleFiles() ? "reference.dialogs.findinpath" : "find.findOptions");
        HelpManager.getInstance().invokeHelp(id);
    }

    @NotNull
    private JPanel createFindOptionsPanel() {
        JPanel findOptionsPanel = new JPanel();
        findOptionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.options.group", new Object[0]), (boolean)true));
        findOptionsPanel.setLayout(new BoxLayout(findOptionsPanel, 1));
        this.myCbCaseSensitive = FindDialog.createCheckbox(FindBundle.message("find.options.case.sensitive", new Object[0]));
        findOptionsPanel.add(this.myCbCaseSensitive);
        ItemListener liveResultsPreviewUpdateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
            }
        };
        this.myCbCaseSensitive.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase = FindDialog.createCheckbox(FindBundle.message("find.options.replace.preserve.case", new Object[0]));
        this.myCbPreserveCase.addItemListener(liveResultsPreviewUpdateListener);
        findOptionsPanel.add(this.myCbPreserveCase);
        this.myCbPreserveCase.setVisible(this.myHelper.isReplaceState());
        this.myCbWholeWordsOnly = FindDialog.createCheckbox(FindBundle.message("find.options.whole.words.only", new Object[0]));
        this.myCbWholeWordsOnly.addItemListener(liveResultsPreviewUpdateListener);
        findOptionsPanel.add(this.myCbWholeWordsOnly);
        this.myCbRegularExpressions = FindDialog.createCheckbox(FindBundle.message("find.options.regular.expressions", new Object[0]));
        this.myCbRegularExpressions.addItemListener(liveResultsPreviewUpdateListener);
        JPanel regExPanel = new JPanel();
        regExPanel.setAlignmentX(0.0f);
        regExPanel.setLayout(new BoxLayout(regExPanel, 0));
        regExPanel.add(this.myCbRegularExpressions);
        regExPanel.add((Component)RegExHelpPopup.createRegExLink("[Help]", regExPanel, LOG));
        findOptionsPanel.add(regExPanel);
        this.mySearchContext = new ComboBox(new Object[]{FindDialog.getPresentableName(FindModel.SearchContext.ANY), FindDialog.getPresentableName(FindModel.SearchContext.IN_COMMENTS), FindDialog.getPresentableName(FindModel.SearchContext.IN_STRING_LITERALS), FindDialog.getPresentableName(FindModel.SearchContext.EXCEPT_COMMENTS), FindDialog.getPresentableName(FindModel.SearchContext.EXCEPT_STRING_LITERALS), FindDialog.getPresentableName(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS)});
        this.mySearchContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
            }
        });
        JPanel searchContextPanel = new JPanel(new BorderLayout());
        searchContextPanel.setAlignmentX(0.0f);
        JLabel searchContextLabel = new JLabel(FindBundle.message("find.context.combo.label", new Object[0]));
        searchContextLabel.setLabelFor((Component)this.mySearchContext);
        JPanel panel2 = new JPanel();
        panel2.setAlignmentX(0.0f);
        panel2.add(searchContextLabel);
        searchContextPanel.add((Component)panel2, "West");
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.mySearchContext, "North");
        searchContextPanel.add((Component)panel2, "Center");
        findOptionsPanel.add(searchContextPanel);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.updateControls();
            }
        };
        this.myCbRegularExpressions.addActionListener(actionListener);
        this.myCbRegularExpressions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                FindDialog.this.setupRegExpSetting();
            }
        });
        this.myCbCaseSensitive.addActionListener(actionListener);
        this.myCbPreserveCase.addActionListener(actionListener);
        JPanel jPanel = findOptionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createFindOptionsPanel"));
        }
        return jPanel;
    }

    public static String getPresentableName(@NotNull FindModel.SearchContext searchContext) {
        if (searchContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchContext", "com/intellij/find/impl/FindDialog", "getPresentableName"));
        }
        String messageKey = null;
        if (searchContext == FindModel.SearchContext.ANY) {
            messageKey = "find.context.anywhere.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_COMMENTS) {
            messageKey = "find.context.except.comments.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_STRING_LITERALS) {
            messageKey = "find.context.except.literals.scope.label";
        } else if (searchContext == FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS) {
            messageKey = "find.context.except.comments.and.literals.scope.label";
        } else if (searchContext == FindModel.SearchContext.IN_COMMENTS) {
            messageKey = "find.context.in.comments.scope.label";
        } else if (searchContext == FindModel.SearchContext.IN_STRING_LITERALS) {
            messageKey = "find.context.in.literals.scope.label";
        }
        return messageKey != null ? FindBundle.message(messageKey, new Object[0]) : searchContext.toString();
    }

    @NotNull
    public static FindModel.SearchContext parseSearchContext(String presentableName) {
        FindModel.SearchContext searchContext = FindModel.SearchContext.ANY;
        if (FindBundle.message("find.context.in.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_STRING_LITERALS;
        } else if (FindBundle.message("find.context.in.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.IN_COMMENTS;
        } else if (FindBundle.message("find.context.except.comments.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS;
        } else if (FindBundle.message("find.context.except.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_STRING_LITERALS;
        } else if (FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]).equals(presentableName)) {
            searchContext = FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS;
        }
        FindModel.SearchContext searchContext2 = searchContext;
        if (searchContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "parseSearchContext"));
        }
        return searchContext2;
    }

    @NotNull
    public static String getSearchContextName(FindModel model2) {
        String searchContext = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        if (model2.isInCommentsOnly()) {
            searchContext = FindBundle.message("find.context.in.comments.scope.label", new Object[0]);
        } else if (model2.isInStringLiteralsOnly()) {
            searchContext = FindBundle.message("find.context.in.literals.scope.label", new Object[0]);
        } else if (model2.isExceptStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.literals.scope.label", new Object[0]);
        } else if (model2.isExceptComments()) {
            searchContext = FindBundle.message("find.context.except.comments.scope.label", new Object[0]);
        } else if (model2.isExceptCommentsAndStringLiterals()) {
            searchContext = FindBundle.message("find.context.except.comments.and.literals.scope.label", new Object[0]);
        }
        String string2 = searchContext;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "getSearchContextName"));
        }
        return string2;
    }

    private void setupRegExpSetting() {
        this.updateFileTypeForEditorComponent(this.myInputComboBox);
        if (this.myReplaceComboBox != null) {
            this.updateFileTypeForEditorComponent(this.myReplaceComboBox);
        }
    }

    private void updateFileTypeForEditorComponent(@NotNull ComboBox inputComboBox) {
        if (inputComboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputComboBox", "com/intellij/find/impl/FindDialog", "updateFileTypeForEditorComponent"));
        }
        Component editorComponent = inputComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            LanguageFileType regexpFileType;
            Language regexpLanguage;
            boolean isRegexp = this.myCbRegularExpressions.isSelectedWhenSelectable();
            PlainTextFileType fileType = PlainTextFileType.INSTANCE;
            if (isRegexp && (regexpLanguage = Language.findLanguageByID((String)"RegExp")) != null && (regexpFileType = regexpLanguage.getAssociatedFileType()) != null) {
                fileType = regexpFileType;
            }
            String fileName = isRegexp ? "a.regexp" : "a.txt";
            PsiFile file2 = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, (FileType)fileType, (CharSequence)((EditorTextField)((Object)editorComponent)).getText(), -1L, true);
            ((EditorTextField)((Object)editorComponent)).setNewDocumentAndFileType((FileType)fileType, PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2));
        }
    }

    private void updateControls() {
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (this.myHelper.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
        if (!this.myHelper.getModel().isMultipleFiles()) {
            this.myRbFromCursor.setEnabled(this.myRbGlobal.isSelected());
            this.myRbEntireScope.setEnabled(this.myRbGlobal.isSelected());
        }
    }

    @NotNull
    private JPanel createDirectionPanel() {
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.direction.group", new Object[0]), (boolean)true));
        directionPanel.setLayout(new BoxLayout(directionPanel, 1));
        this.myRbForward = new JRadioButton(FindBundle.message("find.direction.forward.radio", new Object[0]), true);
        directionPanel.add(this.myRbForward);
        this.myRbBackward = new JRadioButton(FindBundle.message("find.direction.backward.radio", new Object[0]));
        directionPanel.add(this.myRbBackward);
        ButtonGroup bgDirection = new ButtonGroup();
        bgDirection.add(this.myRbForward);
        bgDirection.add(this.myRbBackward);
        JPanel jPanel = directionPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createDirectionPanel"));
        }
        return jPanel;
    }

    @NotNull
    private JComponent createGlobalScopePanel() {
        JPanel scopePanel = new JPanel();
        scopePanel.setLayout(new GridBagLayout());
        scopePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.scope.group", new Object[0]), (boolean)true));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 3;
        gbConstraints.weightx = 1.0;
        boolean canAttach = ProjectAttachProcessor.canAttachToProject();
        this.myRbProject = new JRadioButton(canAttach ? FindBundle.message("find.scope.all.projects.radio", new Object[0]) : FindBundle.message("find.scope.whole.project.radio", new Object[0]), true);
        scopePanel.add((Component)this.myRbProject, gbConstraints);
        ItemListener resultsPreviewUpdateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
            }
        };
        this.myRbProject.addItemListener(resultsPreviewUpdateListener);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.myRbModule = new JRadioButton(canAttach ? FindBundle.message("find.scope.project.radio", new Object[0]) : FindBundle.message("find.scope.module.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbModule, gbConstraints);
        this.myRbModule.addItemListener(resultsPreviewUpdateListener);
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        Object[] names = new String[modules.length];
        for (int i2 = 0; i2 < modules.length; ++i2) {
            names[i2] = modules[i2].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.myModuleComboBox = new ComboBox(names);
        this.myModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
            }
        });
        scopePanel.add((Component)this.myModuleComboBox, gbConstraints);
        if (modules.length == 1) {
            this.myModuleComboBox.setVisible(false);
            this.myRbModule.setVisible(false);
        }
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.myRbDirectory = new JRadioButton(FindBundle.message("find.scope.directory.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbDirectory, gbConstraints);
        this.myRbDirectory.addItemListener(resultsPreviewUpdateListener);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        this.myDirectoryComboBox = new ComboBox(200);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setColumns(40);
        }
        this.initCombobox(this.myDirectoryComboBox);
        this.myDirectoryComboBox.setSwingPopup(false);
        this.myDirectoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
            }
        });
        scopePanel.add((Component)this.myDirectoryComboBox, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 2;
        this.mySelectDirectoryButton = new FixedSizeButton((JComponent)this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.mySelectDirectoryButton, (JComponent)this.myDirectoryComboBox);
        this.mySelectDirectoryButton.setMargin(new Insets(0, 0, 0, 0));
        scopePanel.add((Component)this.mySelectDirectoryButton, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 3;
        gbConstraints.insets = new Insets(0, 16, 0, 0);
        this.myCbWithSubdirectories = FindDialog.createCheckbox(true, FindBundle.message("find.scope.directory.recursive.checkbox", new Object[0]));
        this.myCbWithSubdirectories.setSelected(true);
        this.myCbWithSubdirectories.addItemListener(resultsPreviewUpdateListener);
        scopePanel.add((Component)this.myCbWithSubdirectories, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.myRbCustomScope = new JRadioButton(FindBundle.message("find.scope.custom.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbCustomScope, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        this.myScopeCombo = new ScopeChooserCombo();
        this.myScopeCombo.init(this.myProject, true, true, FindSettings.getInstance().getDefaultScopeName(), new Condition<ScopeDescriptor>(){
            private final String moduleFilesScopeName;
            {
                String moduleScopeName = PsiBundle.message((String)"search.scope.module", (Object[])new Object[]{""});
                int ind = moduleScopeName.indexOf(32);
                this.moduleFilesScopeName = moduleScopeName.substring(0, ind + 1);
            }

            public boolean value(ScopeDescriptor descriptor2) {
                String display = descriptor2.getDisplay();
                return !display.startsWith(this.moduleFilesScopeName);
            }
        });
        this.myScopeCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.scheduleResultsUpdate();
            }
        });
        this.myRbCustomScope.addItemListener(resultsPreviewUpdateListener);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        scopePanel.add((Component)((Object)this.myScopeCombo), gbConstraints);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(this.myRbProject);
        bgScope.add(this.myRbModule);
        bgScope.add(this.myRbDirectory);
        bgScope.add(this.myRbCustomScope);
        this.myRbProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
            }
        });
        this.myRbCustomScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
                FindDialog.this.myScopeCombo.getComboBox().requestFocusInWindow();
            }
        });
        this.myRbDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
                FindDialog.this.myDirectoryComboBox.getEditor().getEditorComponent().requestFocusInWindow();
            }
        });
        this.myRbModule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
                FindDialog.this.myModuleComboBox.requestFocusInWindow();
            }
        });
        this.mySelectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)FindDialog.this.myProject, null, files2 -> FindDialog.this.myDirectoryComboBox.setSelectedItem((Object)((VirtualFile)files2.get(0)).getPresentableUrl()));
            }
        });
        JPanel jPanel = scopePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createGlobalScopePanel"));
        }
        return jPanel;
    }

    @NotNull
    static StateRestoringCheckBox createCheckbox(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/find/impl/FindDialog", "createCheckbox"));
        }
        StateRestoringCheckBox cb2 = new StateRestoringCheckBox(message2);
        cb2.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = cb2;
        if (stateRestoringCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createCheckbox"));
        }
        return stateRestoringCheckBox;
    }

    @NotNull
    static StateRestoringCheckBox createCheckbox(boolean selected, @NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/find/impl/FindDialog", "createCheckbox"));
        }
        StateRestoringCheckBox cb2 = new StateRestoringCheckBox(message2, selected);
        cb2.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = cb2;
        if (stateRestoringCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createCheckbox"));
        }
        return stateRestoringCheckBox;
    }

    private void validateScopeControls() {
        if (this.myRbDirectory.isSelected()) {
            this.myCbWithSubdirectories.makeSelectable();
        } else {
            this.myCbWithSubdirectories.makeUnselectable(this.myCbWithSubdirectories.isSelected());
        }
        this.myDirectoryComboBox.setEnabled(this.myRbDirectory.isSelected());
        this.mySelectDirectoryButton.setEnabled(this.myRbDirectory.isSelected());
        this.myModuleComboBox.setEnabled(this.myRbModule.isSelected());
        this.myScopeCombo.setEnabled(this.myRbCustomScope.isSelected());
    }

    @NotNull
    private JPanel createScopePanel() {
        JPanel scopePanel = new JPanel();
        scopePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.scope.group", new Object[0]), (boolean)true));
        scopePanel.setLayout(new BoxLayout(scopePanel, 1));
        this.myRbGlobal = new JRadioButton(FindBundle.message("find.scope.global.radio", new Object[0]), true);
        scopePanel.add(this.myRbGlobal);
        this.myRbSelectedText = new JRadioButton(FindBundle.message("find.scope.selected.text.radio", new Object[0]));
        scopePanel.add(this.myRbSelectedText);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(this.myRbGlobal);
        bgScope.add(this.myRbSelectedText);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindDialog.this.updateControls();
            }
        };
        this.myRbGlobal.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        JPanel jPanel = scopePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createScopePanel"));
        }
        return jPanel;
    }

    @NotNull
    private JPanel createOriginPanel() {
        JPanel originPanel = new JPanel();
        originPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.origin.group", new Object[0]), (boolean)true));
        originPanel.setLayout(new BoxLayout(originPanel, 1));
        this.myRbFromCursor = new JRadioButton(FindBundle.message("find.origin.from.cursor.radio", new Object[0]), true);
        originPanel.add(this.myRbFromCursor);
        this.myRbEntireScope = new JRadioButton(FindBundle.message("find.origin.entire.scope.radio", new Object[0]));
        originPanel.add(this.myRbEntireScope);
        ButtonGroup bgOrigin = new ButtonGroup();
        bgOrigin.add(this.myRbFromCursor);
        bgOrigin.add(this.myRbEntireScope);
        JPanel jPanel = originPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "createOriginPanel"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string2 = (String)this.myInputComboBox.getEditor().getItem();
        String string3 = string2 == null ? "" : string2;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "getStringToFind"));
        }
        return string3;
    }

    @NotNull
    private String getStringToReplace() {
        String item = (String)this.myReplaceComboBox.getEditor().getItem();
        String string2 = item == null ? "" : item;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog", "getStringToReplace"));
        }
        return string2;
    }

    private String getDirectory() {
        return (String)this.myDirectoryComboBox.getEditor().getItem();
    }

    private static void setStringsToComboBox(@NotNull String[] strings, @NotNull ComboBox<String> combo, String selected) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/find/impl/FindDialog", "setStringsToComboBox"));
        }
        if (combo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "combo", "com/intellij/find/impl/FindDialog", "setStringsToComboBox"));
        }
        if (combo.getItemCount() > 0) {
            combo.removeAllItems();
        }
        if (selected != null && selected.indexOf(10) < 0) {
            strings = (String[])ArrayUtil.remove((Object[])strings, (Object)selected);
            if (!selected.isEmpty()) {
                strings = (String[])ArrayUtil.append((Object[])strings, (Object)selected);
            }
        }
        for (int i2 = strings.length - 1; i2 >= 0; --i2) {
            combo.addItem((Object)strings[i2]);
        }
    }

    private void setDirectories(@NotNull List<String> strings, String directoryName) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/find/impl/FindDialog", "setDirectories"));
        }
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myReplaceComboBox.removeAllItems();
        }
        int ignoredIdx = -1;
        if (directoryName != null && !directoryName.isEmpty()) {
            ignoredIdx = strings.indexOf(directoryName);
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i2 = strings.size() - 1; i2 >= 0; --i2) {
            if (i2 == ignoredIdx) continue;
            this.myDirectoryComboBox.addItem((Object)strings.get(i2));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    private void applyTo(@NotNull FindModel model2, boolean findAll) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindDialog", "applyTo"));
        }
        model2.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model2.isReplaceState()) {
            model2.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model2.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        String selectedSearchContextInUi = (String)this.mySearchContext.getSelectedItem();
        FindModel.SearchContext searchContext = FindDialog.parseSearchContext(selectedSearchContextInUi);
        model2.setSearchContext(searchContext);
        model2.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        String stringToFind = this.getStringToFind();
        model2.setStringToFind(stringToFind);
        if (model2.isReplaceState()) {
            model2.setPromptOnReplace(true);
            model2.setReplaceAll(false);
            String stringToReplace = this.getStringToReplace();
            model2.setStringToReplace(StringUtil.convertLineSeparators((String)stringToReplace));
        }
        if (!model2.isMultipleFiles()) {
            model2.setForward(this.myRbForward.isSelected());
            model2.setFromCursor(this.myRbFromCursor.isSelected());
            model2.setGlobal(this.myRbGlobal.isSelected());
        } else {
            if (this.myCbToOpenInNewTab != null) {
                model2.setOpenInNewTab(this.myCbToOpenInNewTab.isSelected());
            }
            model2.setProjectScope(this.myRbProject.isSelected());
            model2.setDirectoryName(null);
            model2.setModuleName(null);
            model2.setCustomScopeName(null);
            model2.setCustomScope(null);
            model2.setCustomScope(false);
            if (this.myRbDirectory.isSelected()) {
                String directory = this.getDirectory();
                model2.setDirectoryName(directory == null ? "" : directory);
                model2.setWithSubdirectories(this.myCbWithSubdirectories.isSelected());
            } else if (this.myRbModule.isSelected()) {
                model2.setModuleName((String)this.myModuleComboBox.getSelectedItem());
            } else if (this.myRbCustomScope.isSelected()) {
                SearchScope selectedScope = this.myScopeCombo.getSelectedScope();
                String customScopeName = selectedScope == null ? null : selectedScope.getDisplayName();
                model2.setCustomScopeName(customScopeName);
                model2.setCustomScope(selectedScope == null ? null : selectedScope);
                model2.setCustomScope(true);
            }
        }
        model2.setFindAll(findAll);
        String mask = this.getFileTypeMask();
        model2.setFileFilter(mask);
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.myUseFileFilter != null && this.myUseFileFilter.isSelected()) {
            mask = (String)this.myFileFilter.getEditor().getItem();
        }
        return mask;
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCbCaseSensitive.setSelected(myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(myModel.isWholeWordsOnly());
        String searchContext = FindDialog.getSearchContextName(myModel);
        this.mySearchContext.setSelectedItem((Object)searchContext);
        this.myCbRegularExpressions.setSelected(myModel.isRegularExpressions());
        if (myModel.isMultipleFiles()) {
            Module module2;
            VirtualFile dir;
            String dirName = myModel.getDirectoryName();
            this.setDirectories(FindInProjectSettings.getInstance(this.myProject).getRecentDirectories(), dirName);
            if (!StringUtil.isEmptyOrSpaces((String)dirName) && (dir = LocalFileSystem.getInstance().findFileByPath(dirName)) != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)this.myProject)) != null) {
                this.myModuleComboBox.setSelectedItem((Object)module2.getName());
            }
            if (myModel.isCustomScope()) {
                this.myRbCustomScope.setSelected(true);
                this.myScopeCombo.setEnabled(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(false);
            } else if (myModel.isProjectScope()) {
                this.myRbProject.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(false);
                this.myScopeCombo.setEnabled(false);
            } else if (dirName != null) {
                this.myRbDirectory.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(true);
                this.myDirectoryComboBox.setEnabled(true);
                this.mySelectDirectoryButton.setEnabled(true);
                this.myModuleComboBox.setEnabled(false);
                this.myScopeCombo.setEnabled(false);
            } else if (myModel.getModuleName() != null) {
                this.myRbModule.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(true);
                this.myModuleComboBox.setSelectedItem((Object)myModel.getModuleName());
                this.myScopeCombo.setEnabled(false);
                this.myRbModule.setVisible(true);
                this.myModuleComboBox.setVisible(true);
            } else assert (false) : myModel;
            this.myCbWithSubdirectories.setSelected(myModel.isWithSubdirectories());
            if (myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty()) {
                this.myFileFilter.setSelectedItem((Object)myModel.getFileFilter());
                this.myFileFilter.setEnabled(true);
                this.myUseFileFilter.setSelected(true);
            }
        } else {
            if (myModel.isForward()) {
                this.myRbForward.setSelected(true);
            } else {
                this.myRbBackward.setSelected(true);
            }
            if (myModel.isFromCursor()) {
                this.myRbFromCursor.setSelected(true);
            } else {
                this.myRbEntireScope.setSelected(true);
            }
            if (myModel.isGlobal()) {
                this.myRbGlobal.setSelected(true);
            } else {
                this.myRbSelectedText.setSelected(true);
            }
        }
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
        FindDialog.setStringsToComboBox(findInProjectSettings.getRecentFindStrings(), (ComboBox<String>)this.myInputComboBox, myModel.getStringToFind());
        if (myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(myModel.isPreserveCase());
            FindDialog.setStringsToComboBox(findInProjectSettings.getRecentReplaceStrings(), (ComboBox<String>)this.myReplaceComboBox, myModel.getStringToReplace());
        }
        this.updateControls();
    }

    private void navigateToSelectedUsage(JBTable source) {
        int[] rows = source.getSelectedRows();
        List navigations = null;
        for (int row : rows) {
            Object valueAt = source.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (navigations == null) {
                navigations = new SmartList();
            }
            Usage at = (Usage)valueAt;
            navigations.add(at);
        }
        if (navigations != null) {
            this.doCancelAction();
            ((Usage)navigations.get(0)).navigate(true);
            for (int i2 = 1; i2 < navigations.size(); ++i2) {
                ((Usage)navigations.get(i2)).highlightInEditor();
            }
        }
    }

    protected void registerNavigateToSourceShortcutOnComponent(final @NotNull JBTable c2, JComponent component) {
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/find/impl/FindDialog", "registerNavigateToSourceShortcutOnComponent"));
        }
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e2) {
                FindDialog.this.navigateToSelectedUsage(c2);
            }
        };
        anAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), component, this.myDisposable);
    }

    static {
        PREVIEW_TITLE = UIBundle.message((String)"tool.window.name.preview", (Object[])new Object[0]);
    }

    private class NavigateToSourceListener
    extends DoubleClickListener {
        private NavigateToSourceListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            Object source = event.getSource();
            if (!(source instanceof JBTable)) {
                return false;
            }
            FindDialog.this.navigateToSelectedUsage((JBTable)source);
            return true;
        }

        public void installOn(final @NotNull Component c2) {
            if (c2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/find/impl/FindDialog$NavigateToSourceListener", "installOn"));
            }
            super.installOn(c2);
            if (c2 instanceof JBTable) {
                String key = "navigate.to.usage";
                JComponent component = (JComponent)c2;
                component.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), key);
                component.getActionMap().put(key, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        FindDialog.this.navigateToSelectedUsage((JBTable)c2);
                    }
                });
                FindDialog.this.registerNavigateToSourceShortcutOnComponent((JBTable)c2, component);
            }
        }
    }

    static class UsageTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myUsageRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                if (value2 instanceof UsageInfo2UsageAdapter) {
                    if (!((UsageInfo2UsageAdapter)value2).isValid()) {
                        myUsageRenderer.append(" " + UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    }
                    TextChunk[] text2 = ((UsageInfo2UsageAdapter)value2).getPresentation().getText();
                    for (int i2 = 1; i2 < text2.length; ++i2) {
                        TextChunk textChunk = text2[i2];
                        SimpleTextAttributes attributes = this.getAttributes(textChunk);
                        myUsageRenderer.append(textChunk.getText(), attributes);
                    }
                }
                this.setBorder(null);
            }

            @NotNull
            private SimpleTextAttributes getAttributes(@NotNull TextChunk textChunk) {
                if (textChunk == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textChunk", "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$1", "getAttributes"));
                }
                SimpleTextAttributes at = textChunk.getSimpleAttributesIgnoreBackground();
                if (myUseBold) {
                    SimpleTextAttributes simpleTextAttributes = at;
                    if (simpleTextAttributes == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$1", "getAttributes"));
                    }
                    return simpleTextAttributes;
                }
                boolean highlighted = textChunk.getType() != null || at.getFontStyle() == 1;
                SimpleTextAttributes simpleTextAttributes = highlighted ? new SimpleTextAttributes(null, at.getFgColor(), at.getWaveColor(), at.getStyle() & 0xFFFFFFFE | 0x40) : at;
                if (simpleTextAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$1", "getAttributes"));
                }
                return simpleTextAttributes;
            }
        };
        private final ColoredTableCellRenderer myFileAndLineNumber = new ColoredTableCellRenderer(){
            private final SimpleTextAttributes REPEATED_FILE_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(0xCCCCCC, 0x5E5E5E));
            private final SimpleTextAttributes ORDINAL_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(0x999999, 0x999999));

            protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                if (value2 instanceof UsageInfo2UsageAdapter) {
                    UsageInfo2UsageAdapter usageAdapter = (UsageInfo2UsageAdapter)value2;
                    TextChunk[] text2 = usageAdapter.getPresentation().getText();
                    VirtualFile file2 = usageAdapter.getFile();
                    String uniqueVirtualFilePath = this.getFilePath(usageAdapter);
                    VirtualFile prevFile = this.findPrevFile(table2, row, column);
                    SimpleTextAttributes attributes = Comparing.equal((Object)file2, (Object)prevFile) ? this.REPEATED_FILE_ATTRIBUTES : this.ORDINAL_ATTRIBUTES;
                    this.append(uniqueVirtualFilePath, attributes);
                    if (text2.length > 0) {
                        this.append(" " + text2[0].getText(), this.ORDINAL_ATTRIBUTES);
                    }
                }
                this.setBorder(null);
            }

            @NotNull
            private String getFilePath(@NotNull UsageInfo2UsageAdapter ua) {
                if (ua == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ua", "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$2", "getFilePath"));
                }
                String uniquePath = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(ua.getUsageInfo().getProject(), ua.getFile());
                String string2 = myOmitFileExtension ? FileUtilRt.getNameWithoutExtension((String)uniquePath) : uniquePath;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$2", "getFilePath"));
                }
                return string2;
            }

            @Nullable
            private VirtualFile findPrevFile(@NotNull JTable table2, int row, int column) {
                if (table2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/impl/FindDialog$UsageTableCellRenderer$2", "findPrevFile"));
                }
                if (row <= 0) {
                    return null;
                }
                Object prev = table2.getValueAt(row - 1, column);
                return prev instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)prev).getFile() : null;
            }
        };
        private static final int MARGIN = 2;
        private final boolean myOmitFileExtension;
        private final boolean myUseBold;

        UsageTableCellRenderer(boolean omitFileExtension, boolean useBold) {
            this.myOmitFileExtension = omitFileExtension;
            this.myUseBold = useBold;
            this.setLayout(new BorderLayout());
            this.add((Component)this.myUsageRenderer, "Center");
            this.add((Component)this.myFileAndLineNumber, "East");
            this.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myUsageRenderer.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            this.myFileAndLineNumber.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            this.setBackground(this.myUsageRenderer.getBackground());
            if (!isSelected && value2 instanceof UsageInfo2UsageAdapter) {
                UsageInfo2UsageAdapter usageAdapter = (UsageInfo2UsageAdapter)value2;
                Color color = FileColorManager.getInstance((Project)usageAdapter.getUsageInfo().getProject()).getFileColor(usageAdapter.getFile());
                this.setBackground(color);
                this.myUsageRenderer.setBackground(color);
                this.myFileAndLineNumber.setBackground(color);
            }
            return this;
        }
    }
}

