/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindInProjectTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindInProjectTask");
    private static final int FILES_SIZE_LIMIT = 0x4600000;
    private static final int SINGLE_FILE_SIZE_LIMIT = 0x500000;
    private final FindModel myFindModel;
    private final Project myProject;
    private final PsiManager myPsiManager;
    @Nullable
    private final VirtualFile myDirectory;
    private final ProjectFileIndex myProjectFileIndex;
    private final FileIndex myFileIndex;
    private final Condition<VirtualFile> myFileMask;
    private final ProgressIndicator myProgress;
    @Nullable
    private final Module myModule;
    private final Set<VirtualFile> myLargeFiles;
    private final Set<VirtualFile> myFilesToScanInitially;
    private final AtomicBoolean myWarningShown;
    private final AtomicLong myTotalFilesSize;
    private final String myStringToFindInIndices;

    FindInProjectTask(@NotNull FindModel findModel, @NotNull Project project2, @NotNull Set<VirtualFile> filesToScanInitially) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        if (filesToScanInitially == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToScanInitially", "com/intellij/find/impl/FindInProjectTask", "<init>"));
        }
        this.myLargeFiles = Collections.synchronizedSet(ContainerUtil.newTroveSet());
        this.myWarningShown = new AtomicBoolean();
        this.myTotalFilesSize = new AtomicLong();
        this.myFindModel = findModel;
        this.myProject = project2;
        this.myFilesToScanInitially = filesToScanInitially;
        this.myDirectory = FindInProjectUtil.getDirectory(findModel);
        this.myPsiManager = PsiManager.getInstance((Project)project2);
        String moduleName = findModel.getModuleName();
        this.myModule = moduleName == null ? null : (Module)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectTask", "lambda$new$0"));
            }
            return ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
        });
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.myFileIndex = this.myModule == null ? this.myProjectFileIndex : ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        Condition<CharSequence> patternCondition = FindInProjectUtil.createFileMaskCondition(findModel.getFileFilter());
        this.myFileMask = file2 -> file2 != null && patternCondition.value((Object)file2.getNameSequence());
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        this.myProgress = progress != null ? progress : new EmptyProgressIndicator();
        String stringToFind = this.myFindModel.getStringToFind();
        if (this.myFindModel.isRegularExpressions()) {
            stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, this.myProject);
        }
        this.myStringToFindInIndices = stringToFind;
    }

    public void findUsages(@NotNull Processor<UsageInfo> consumer2, @NotNull FindUsagesProcessPresentation processPresentation) {
        block9: {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectTask", "findUsages"));
            }
            if (processPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectTask", "findUsages"));
            }
            try {
                this.myProgress.setIndeterminate(true);
                this.myProgress.setText("Scanning indexed files...");
                Set filesForFastWordSearch = (Set)ReadAction.compute(this::getFilesForFastWordSearch);
                this.myProgress.setIndeterminate(false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + this.myFindModel.getStringToFind() + " in " + filesForFastWordSearch.size() + " indexed files");
                }
                this.searchInFiles(filesForFastWordSearch, processPresentation, consumer2);
                this.myProgress.setIndeterminate(true);
                this.myProgress.setText("Scanning non-indexed files...");
                boolean canRelyOnIndices = this.canRelyOnIndices();
                Collection<VirtualFile> otherFiles = this.collectFilesInScope(filesForFastWordSearch, canRelyOnIndices);
                this.myProgress.setIndeterminate(false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + this.myFindModel.getStringToFind() + " in " + otherFiles.size() + " non-indexed files");
                }
                this.myProgress.checkCanceled();
                long start2 = System.currentTimeMillis();
                this.searchInFiles(otherFiles, processPresentation, consumer2);
                if (canRelyOnIndices && otherFiles.size() > 1000) {
                    long time = System.currentTimeMillis() - start2;
                    FindInProjectTask.logStats(otherFiles, time);
                }
            }
            catch (ProcessCanceledException e2) {
                processPresentation.setCanceled(true);
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("Usage search canceled", (Throwable)e2);
            }
        }
        if (!this.myLargeFiles.isEmpty()) {
            processPresentation.setLargeFilesWereNotScanned(this.myLargeFiles);
        }
        if (!this.myProgress.isCanceled()) {
            this.myProgress.setText(FindBundle.message("find.progress.search.completed", new Object[0]));
        }
    }

    private static void logStats(@NotNull Collection<VirtualFile> otherFiles, long time) {
        if (otherFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherFiles", "com/intellij/find/impl/FindInProjectTask", "logStats"));
        }
        HashMultiset stats = HashMultiset.create();
        for (VirtualFile file2 : otherFiles) {
            stats.add((Object)StringUtil.notNullize((String)file2.getExtension()).toLowerCase());
        }
        ArrayList extensions = ContainerUtil.newArrayList((Iterable)stats.elementSet());
        Collections.sort(extensions, (arg_0, arg_1) -> FindInProjectTask.lambda$logStats$2((Multiset)stats, arg_0, arg_1));
        String message2 = "Search in " + otherFiles.size() + " files with unknown types took " + time + "ms.\nMapping their extensions to an existing file type (e.g. Plain Text) might speed up the search.\nMost frequent non-indexed file extensions: ";
        for (int i2 = 0; i2 < Math.min(10, extensions.size()); ++i2) {
            String extension = (String)extensions.get(i2);
            message2 = message2 + extension + "(" + stats.count((Object)extension) + ") ";
        }
        LOG.info(message2);
    }

    private void searchInFiles(@NotNull Collection<VirtualFile> virtualFiles, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull Processor<UsageInfo> consumer2) {
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/find/impl/FindInProjectTask", "searchInFiles"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectTask", "searchInFiles"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectTask", "searchInFiles"));
        }
        AtomicInteger occurrenceCount = new AtomicInteger();
        AtomicInteger processedFileCount = new AtomicInteger();
        Processor processor2 = virtualFile -> {
            boolean skipProjectFile;
            if (virtualFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/find/impl/FindInProjectTask", "lambda$searchInFiles$6"));
            }
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectTask", "lambda$searchInFiles$6"));
            }
            if (processPresentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectTask", "lambda$searchInFiles$6"));
            }
            if (!virtualFile.isValid()) {
                return true;
            }
            long fileLength = UsageViewManagerImpl.getFileLength((VirtualFile)virtualFile);
            if (fileLength == -1L) {
                return true;
            }
            boolean bl = skipProjectFile = ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) && !this.myFindModel.isSearchInProjectFiles();
            if (skipProjectFile && !Registry.is((String)"find.search.in.project.files")) {
                return true;
            }
            if (fileLength > 0x500000L) {
                this.myLargeFiles.add((VirtualFile)virtualFile);
                return true;
            }
            this.myProgress.checkCanceled();
            if (this.myProgress.isRunning()) {
                double fraction = (double)processedFileCount.incrementAndGet() / (double)virtualFiles.size();
                this.myProgress.setFraction(fraction);
            }
            String text2 = FindBundle.message("find.searching.for.string.in.file.progress", this.myFindModel.getStringToFind(), virtualFile.getPresentableUrl());
            this.myProgress.setText(text2);
            this.myProgress.setText2(FindBundle.message("find.searching.for.string.in.file.occurrences.progress", occurrenceCount));
            Pair.NonNull pair = (Pair.NonNull)ReadAction.compute(() -> this.findFile((VirtualFile)virtualFile));
            if (pair == null) {
                return true;
            }
            PsiFile psiFile = (PsiFile)pair.first;
            VirtualFile sourceVirtualFile = (VirtualFile)pair.second;
            int countInFile = FindInProjectUtil.processUsagesInFile(psiFile, sourceVirtualFile, this.myFindModel, (Processor<UsageInfo>)((Processor)info -> {
                if (consumer2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectTask", "lambda$null$4"));
                }
                return skipProjectFile || consumer2.process(info);
            }));
            if (countInFile > 0 && skipProjectFile) {
                processPresentation.projectFileUsagesFound(() -> {
                    FindModel model2 = this.myFindModel.clone();
                    model2.setSearchInProjectFiles(true);
                    FindInProjectManager.getInstance(this.myProject).startFindInProject(model2);
                });
                return true;
            }
            occurrenceCount.addAndGet(countInFile);
            if (countInFile > 0 && this.myTotalFilesSize.addAndGet(fileLength) > 0x4600000L && this.myWarningShown.compareAndSet(false, true)) {
                String message2 = FindBundle.message("find.excessive.total.size.prompt", UsageViewManagerImpl.presentableSize((long)this.myTotalFilesSize.longValue()), ApplicationNamesInfo.getInstance().getProductName());
                UsageLimitUtil.showAndCancelIfAborted((Project)this.myProject, (String)message2, (UsageViewPresentation)processPresentation.getUsageViewPresentation());
            }
            return true;
        };
        PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myProject, new ArrayList<VirtualFile>(virtualFiles), this.myProgress, (Processor<VirtualFile>)processor2);
    }

    @NotNull
    private Collection<VirtualFile> collectFilesInScope(final @NotNull Set<VirtualFile> alreadySearched, final boolean skipIndexed) {
        if (alreadySearched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadySearched", "com/intellij/find/impl/FindInProjectTask", "collectFilesInScope"));
        }
        SearchScope customScope = this.myFindModel.isCustomScope() ? this.myFindModel.getCustomScope() : null;
        final GlobalSearchScope globalCustomScope = customScope == null ? null : GlobalSearchScopeUtil.toGlobalSearchScope(customScope, this.myProject);
        final ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        final boolean hasTrigrams = FindInProjectTask.hasTrigrams(this.myStringToFindInIndices);
        class EnumContentIterator
        implements ContentIterator {
            private final Set<VirtualFile> myFiles = new LinkedHashSet<VirtualFile>();

            EnumContentIterator() {
            }

            public boolean processFile(final @NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator", "processFile"));
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){
                    private final FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();

                    @Override
                    public void run() {
                        ProgressManager.checkCanceled();
                        if (virtualFile.isDirectory() || !virtualFile.isValid() || !FindInProjectTask.this.myFileMask.value((Object)virtualFile) || globalCustomScope != null && !globalCustomScope.contains(virtualFile)) {
                            return;
                        }
                        if (skipIndexed && this.isCoveredByIndex(virtualFile) && (fileIndex.isInContent(virtualFile) || fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInLibrarySource(virtualFile))) {
                            return;
                        }
                        Pair.NonNull pair = FindInProjectTask.this.findFile(virtualFile);
                        if (pair == null) {
                            return;
                        }
                        VirtualFile sourceVirtualFile = (VirtualFile)pair.second;
                        if (sourceVirtualFile != null && !alreadySearched.contains(sourceVirtualFile)) {
                            myFiles.add(sourceVirtualFile);
                        }
                    }

                    private boolean isCoveredByIndex(VirtualFile file2) {
                        FileType fileType = file2.getFileType();
                        if (hasTrigrams) {
                            return TrigramIndex.isIndexable(fileType) && this.fileBasedIndex.isIndexingCandidate(file2, TrigramIndex.INDEX_ID);
                        }
                        return IdIndex.isIndexable(fileType) && this.fileBasedIndex.isIndexingCandidate(file2, IdIndex.NAME);
                    }
                });
                return true;
            }

            @NotNull
            private Collection<VirtualFile> getFiles() {
                Set<VirtualFile> set2 = this.myFiles;
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask$1EnumContentIterator", "getFiles"));
                }
                return set2;
            }
        }
        final EnumContentIterator iterator2 = new EnumContentIterator();
        if (customScope instanceof LocalSearchScope) {
            for (VirtualFile file2 : GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)customScope)) {
                iterator2.processFile(file2);
            }
        } else if (customScope instanceof Iterable) {
            for (VirtualFile file3 : (Iterable)customScope) {
                iterator2.processFile(file3);
            }
        } else if (this.myDirectory != null) {
            final boolean checkExcluded = !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isExcluded(this.myDirectory);
            VirtualFileVisitor.Option limit = VirtualFileVisitor.limit((int)(this.myFindModel.isWithSubdirectories() ? -1 : 1));
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{limit}){
                {
                    super(arg0);
                }

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectTask$1", "visitFile"));
                    }
                    if (checkExcluded && FindInProjectTask.this.myProjectFileIndex.isExcluded(file2)) {
                        return false;
                    }
                    iterator2.processFile(file2);
                    return true;
                }
            });
        } else {
            boolean success = this.myFileIndex.iterateContent((ContentIterator)iterator2);
            if (success && globalCustomScope != null && globalCustomScope.isSearchInLibraries()) {
                VirtualFile[] librarySources = (VirtualFile[])ReadAction.compute(() -> {
                    OrderEnumerator enumerator = this.myModule == null ? OrderEnumerator.orderEntries((Project)this.myProject) : OrderEnumerator.orderEntries((Module)this.myModule);
                    return enumerator.withoutModuleSourceEntries().withoutDepModules().getSourceRoots();
                });
                FindInProjectTask.iterateAll(librarySources, globalCustomScope, iterator2);
            }
        }
        Collection collection = iterator2.getFiles();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "collectFilesInScope"));
        }
        return collection;
    }

    private static boolean iterateAll(@NotNull VirtualFile[] files2, @NotNull GlobalSearchScope searchScope, @NotNull ContentIterator iterator2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/find/impl/FindInProjectTask", "iterateAll"));
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VirtualFileFilter contentFilter = file2 -> {
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/impl/FindInProjectTask", "lambda$iterateAll$8"));
            }
            return file2.isDirectory() || !fileTypeManager.isFileIgnored(file2) && !file2.getFileType().isBinary() && searchScope.contains(file2);
        };
        for (VirtualFile file3 : files2) {
            if (VfsUtilCore.iterateChildrenRecursively((VirtualFile)file3, (VirtualFileFilter)contentFilter, (ContentIterator)iterator2)) continue;
            return false;
        }
        return true;
    }

    private boolean canRelyOnIndices() {
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
            return false;
        }
        String text2 = this.myStringToFindInIndices;
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            return false;
        }
        if (FindInProjectTask.hasTrigrams(text2)) {
            return true;
        }
        return this.myFindModel.isWholeWordsOnly() && text2.indexOf(36) < 0 && !StringUtil.getWordsInStringLongestFirst((String)text2).isEmpty();
    }

    private static boolean hasTrigrams(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindInProjectTask", "hasTrigrams"));
        }
        return TrigramIndex.ENABLED && !TrigramBuilder.processTrigrams((CharSequence)text2, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor(){

            public boolean execute(int value2) {
                return false;
            }
        });
    }

    @NotNull
    private Set<VirtualFile> getFilesForFastWordSearch() {
        VirtualFile[] filesWithWord;
        String stringToFind = this.myStringToFindInIndices;
        if (stringToFind.isEmpty() || DumbService.getInstance((Project)this.myProject).isDumb()) {
            Set<VirtualFile> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
            }
            return set2;
        }
        LinkedHashSet<VirtualFile> resultFiles = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file3 : this.myFilesToScanInitially) {
            if (!this.myFileMask.value((Object)file3)) continue;
            resultFiles.add(file3);
        }
        GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel), this.myProject);
        if (TrigramIndex.ENABLED) {
            THashSet keys = ContainerUtil.newTroveSet();
            TrigramBuilder.processTrigrams((CharSequence)stringToFind, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((Set)keys){
                final /* synthetic */ Set val$keys;
                {
                    this.val$keys = set2;
                }

                public boolean execute(int value2) {
                    this.val$keys.add(value2);
                    return true;
                }
            });
            if (!keys.isEmpty()) {
                ArrayList hits = new ArrayList();
                ApplicationManager.getApplication().runReadAction(() -> FindInProjectTask.lambda$getFilesForFastWordSearch$9((Set)keys, hits, scope));
                for (VirtualFile hit : hits) {
                    if (!this.myFileMask.value((Object)hit)) continue;
                    resultFiles.add(hit);
                }
                LinkedHashSet<VirtualFile> linkedHashSet = resultFiles;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
                }
                return linkedHashSet;
            }
        }
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)this.myProject);
        helper.processFilesWithText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, (Processor<VirtualFile>)((Processor)file2 -> {
            if (this.myFileMask.value(file2)) {
                ContainerUtil.addIfNotNull((Collection)resultFiles, (Object)file2);
            }
            return true;
        }));
        CacheManager cacheManager = CacheManager.SERVICE.getInstance(this.myProject);
        for (VirtualFile file4 : filesWithWord = cacheManager.getVirtualFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive())) {
            if (!this.myFileMask.value((Object)file4)) continue;
            resultFiles.add(file4);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = resultFiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectTask", "getFilesForFastWordSearch"));
        }
        return linkedHashSet;
    }

    private Pair.NonNull<PsiFile, VirtualFile> findFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/find/impl/FindInProjectTask", "findFile"));
        }
        PsiFile psiFile = this.myPsiManager.findFile(virtualFile);
        if (psiFile != null && !(psiFile instanceof PsiBinaryFile)) {
            PsiFile sourceFile = (PsiFile)psiFile.getNavigationElement();
            if (sourceFile != null) {
                psiFile = sourceFile;
            }
            if (psiFile.getFileType().isBinary()) {
                psiFile = null;
            }
        }
        VirtualFile sourceVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile == null || psiFile.getFileType().isBinary() || sourceVirtualFile == null) {
            return null;
        }
        return Pair.createNonNull((Object)psiFile, (Object)sourceVirtualFile);
    }

    private static /* synthetic */ void lambda$getFilesForFastWordSearch$9(Set keys, List hits, GlobalSearchScope scope) {
        FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, keys, Processors.cancelableCollectProcessor((Collection)hits), scope);
    }

    private static /* synthetic */ int lambda$logStats$2(Multiset stats, String o1, String o2) {
        return stats.count((Object)o2) - stats.count((Object)o1);
    }
}

