/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExReplacementBuilder;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.impl.SyntaxHighlighterOverEditorHighlighter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindManagerImpl
extends FindManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindManagerImpl");
    private final FindUsagesManager myFindUsagesManager;
    private boolean isFindWasPerformed = false;
    private boolean isSelectNextOccurrenceWasPerformed = false;
    private Point myReplaceInFilePromptPos = new Point(-1, -1);
    private Point myReplaceInProjectPromptPos = new Point(-1, -1);
    private final FindModel myFindInProjectModel = new FindModel();
    private final FindModel myFindInFileModel = new FindModel();
    private FindModel myFindNextModel = null;
    private FindModel myPreviousFindModel = null;
    private static final FindResultImpl NOT_FOUND_RESULT = new FindResultImpl();
    private final Project myProject;
    private final MessageBus myBus;
    private static final Key<Boolean> HIGHLIGHTER_WAS_NOT_FOUND_KEY = Key.create((String)"com.intellij.find.impl.FindManagerImpl.HighlighterNotFoundKey");
    private FindUIHelper myHelper;
    private static Key<FindExceptCommentsOrLiteralsData> ourExceptCommentsOrLiteralsDataKey = Key.create((String)"except.comments.literals.search.data");
    private static final Key<CommentsLiteralsSearchData> ourCommentsLiteralsSearchDataKey = Key.create((String)"comments.literals.search.data");

    public FindManagerImpl(Project project2, FindSettings findSettings, UsageViewManager anotherManager, MessageBus bus) {
        this.myProject = project2;
        this.myBus = bus;
        findSettings.initModelBySetings(this.myFindInProjectModel);
        this.myFindInFileModel.setCaseSensitive(findSettings.isLocalCaseSensitive());
        this.myFindInFileModel.setWholeWordsOnly(findSettings.isLocalWholeWordsOnly());
        this.myFindInFileModel.setRegularExpressions(findSettings.isLocalRegularExpressions());
        this.myFindUsagesManager = new FindUsagesManager(this.myProject, anotherManager);
        this.myFindInProjectModel.setMultipleFiles(true);
        NotificationsConfigurationImpl.remove("FindInPath");
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                if (FindManagerImpl.this.myHelper != null) {
                    Disposer.dispose((Disposable)FindManagerImpl.this.myHelper);
                }
            }
        });
    }

    public FindModel createReplaceInFileModel() {
        FindModel model2 = new FindModel();
        model2.copyFrom(this.getFindInFileModel());
        model2.setReplaceState(true);
        model2.setPromptOnReplace(false);
        return model2;
    }

    public int showPromptDialog(@NotNull FindModel model2, String title) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "showPromptDialog"));
        }
        return this.showPromptDialogImpl(model2, title, null);
    }

    @FindManager.PromptResultValue
    public int showPromptDialogImpl(final @NotNull FindModel model2, String title, @Nullable FindManager.MalformedReplacementStringException exception) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "showPromptDialogImpl"));
        }
        ReplacePromptDialog replacePromptDialog = new ReplacePromptDialog(model2.isMultipleFiles(), title, this.myProject, exception){

            @Nullable
            public Point getInitialLocation() {
                if (model2.isMultipleFiles() && ((FindManagerImpl)FindManagerImpl.this).myReplaceInProjectPromptPos.x >= 0 && ((FindManagerImpl)FindManagerImpl.this).myReplaceInProjectPromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInProjectPromptPos;
                }
                if (!model2.isMultipleFiles() && ((FindManagerImpl)FindManagerImpl.this).myReplaceInFilePromptPos.x >= 0 && ((FindManagerImpl)FindManagerImpl.this).myReplaceInFilePromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInFilePromptPos;
                }
                return null;
            }
        };
        replacePromptDialog.show();
        if (model2.isMultipleFiles()) {
            this.myReplaceInProjectPromptPos = replacePromptDialog.getLocation();
        } else {
            this.myReplaceInFilePromptPos = replacePromptDialog.getLocation();
        }
        return replacePromptDialog.getExitCode();
    }

    void changeGlobalSettings(FindModel findModel) {
        String stringToFind = findModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
        if (!StringUtil.isEmpty((String)stringToFind)) {
            findInProjectSettings.addStringToFind(stringToFind);
        }
        if (!findModel.isMultipleFiles()) {
            this.setFindWasPerformed();
        }
        if (findModel.isReplaceState()) {
            findInProjectSettings.addStringToReplace(findModel.getStringToReplace());
        }
        if (findModel.isMultipleFiles() && !findModel.isProjectScope() && findModel.getDirectoryName() != null) {
            findInProjectSettings.addDirectory(findModel.getDirectoryName());
            this.myFindInProjectModel.setWithSubdirectories(findModel.isWithSubdirectories());
        }
        FindSettings.getInstance().setShowResultsInSeparateView(findModel.isOpenInNewTab());
    }

    public void showFindDialog(@NotNull FindModel model2, @NotNull Runnable okHandler) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "showFindDialog"));
        }
        if (okHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okHandler", "com/intellij/find/impl/FindManagerImpl", "showFindDialog"));
        }
        if (this.myHelper == null || Disposer.isDisposed((Disposable)this.myHelper)) {
            this.myHelper = new FindUIHelper(this.myProject, model2, okHandler);
            Disposer.register((Disposable)this.myHelper, (Disposable)new Disposable(){

                public void dispose() {
                    FindManagerImpl.this.myHelper = null;
                }
            });
        } else {
            this.myHelper.setModel(model2);
            this.myHelper.setOkHandler(okHandler);
        }
        this.myHelper.showUI();
    }

    @NotNull
    public FindModel getFindInFileModel() {
        FindModel findModel = this.myFindInFileModel;
        if (findModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "getFindInFileModel"));
        }
        return findModel;
    }

    @NotNull
    public FindModel getFindInProjectModel() {
        this.myFindInProjectModel.setFromCursor(false);
        this.myFindInProjectModel.setForward(true);
        this.myFindInProjectModel.setGlobal(true);
        FindModel findModel = this.myFindInProjectModel;
        if (findModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "getFindInProjectModel"));
        }
        return findModel;
    }

    public boolean findWasPerformed() {
        return this.isFindWasPerformed;
    }

    public void setFindWasPerformed() {
        this.isFindWasPerformed = true;
        this.isSelectNextOccurrenceWasPerformed = false;
    }

    public boolean selectNextOccurrenceWasPerformed() {
        return this.isSelectNextOccurrenceWasPerformed;
    }

    public void setSelectNextOccurrenceWasPerformed() {
        this.isSelectNextOccurrenceWasPerformed = true;
        this.isFindWasPerformed = false;
    }

    public FindModel getFindNextModel() {
        return this.myFindNextModel;
    }

    public FindModel getFindNextModel(@NotNull Editor editor) {
        String textInField;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/FindManagerImpl", "getFindNextModel"));
        }
        if (this.myFindNextModel == null) {
            return null;
        }
        EditorSearchSession search = EditorSearchSession.get(editor);
        if (!(search == null || this.isSelectNextOccurrenceWasPerformed || Comparing.equal((String)(textInField = search.getTextInField()), (String)this.myFindInFileModel.getStringToFind()) || textInField.isEmpty())) {
            FindModel patched = new FindModel();
            patched.copyFrom(this.myFindNextModel);
            patched.setStringToFind(textInField);
            return patched;
        }
        return this.myFindNextModel;
    }

    public void setFindNextModel(FindModel findNextModel) {
        this.myFindNextModel = findNextModel;
        ((FindModelListener)this.myBus.syncPublisher(FIND_MODEL_TOPIC)).findNextModelChanged();
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text2, int offset, @NotNull FindModel model2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindManagerImpl", "findString"));
        }
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "findString"));
        }
        FindResult findResult = this.findString(text2, offset, model2, null);
        if (findResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "findString"));
        }
        return findResult;
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text2, int offset, @NotNull FindModel model2, @Nullable VirtualFile file2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindManagerImpl", "findString"));
        }
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "findString"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("offset=" + offset);
            LOG.debug("textlength=" + text2.length());
            LOG.debug(model2.toString());
        }
        FindResult findResult = this.findStringLoop(text2, offset, model2, file2, this.getFindContextPredicate(model2, file2, text2));
        if (findResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "findString"));
        }
        return findResult;
    }

    private FindResult findStringLoop(CharSequence text2, int offset, FindModel model2, VirtualFile file2, @Nullable Predicate<FindResult> filter2) {
        char[] textArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text2);
        do {
            FindResult result2 = this.doFindString(text2, textArray, offset, model2, file2);
            if (filter2 == null || filter2.apply((Object)result2)) {
                if (!model2.isWholeWordsOnly()) {
                    return result2;
                }
                if (!result2.isStringFound()) {
                    return result2;
                }
                if (FindManagerImpl.isWholeWord(text2, result2.getStartOffset(), result2.getEndOffset())) {
                    return result2;
                }
            }
            int n2 = offset = model2.isForward() ? result2.getStartOffset() + 1 : result2.getEndOffset() - 1;
        } while (offset <= text2.length() && offset >= 0);
        return NOT_FOUND_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Predicate<FindResult> getFindContextPredicate(@NotNull FindModel model2, VirtualFile file2, CharSequence text2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "getFindContextPredicate"));
        }
        if (file2 == null) {
            return null;
        }
        FindModel.SearchContext context2 = model2.getSearchContext();
        if (context2 == FindModel.SearchContext.ANY || context2 == FindModel.SearchContext.IN_COMMENTS || context2 == FindModel.SearchContext.IN_STRING_LITERALS) {
            return null;
        }
        FindModel findModel = model2;
        synchronized (findModel) {
            FindExceptCommentsOrLiteralsData data = (FindExceptCommentsOrLiteralsData)model2.getUserData(ourExceptCommentsOrLiteralsDataKey);
            if (data == null || !data.isAcceptableFor(model2, file2, text2)) {
                data = new FindExceptCommentsOrLiteralsData(file2, model2, text2);
                model2.putUserData(ourExceptCommentsOrLiteralsDataKey, (Object)data);
            }
            return data;
        }
    }

    public int showMalformedReplacementPrompt(@NotNull FindModel model2, String title, FindManager.MalformedReplacementStringException exception) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "showMalformedReplacementPrompt"));
        }
        return this.showPromptDialogImpl(model2, title, exception);
    }

    public FindModel getPreviousFindModel() {
        return this.myPreviousFindModel;
    }

    public void setPreviousFindModel(FindModel previousFindModel) {
        this.myPreviousFindModel = previousFindModel;
    }

    private static boolean isWholeWord(CharSequence text2, int startOffset, int endOffset) {
        boolean isWordEnd;
        boolean isWordStart;
        if (startOffset != 0) {
            boolean previousCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(startOffset - 1)) && (startOffset <= 1 || text2.charAt(startOffset - 2) != '\\');
            boolean previousCharacterIsSameAsNext = text2.charAt(startOffset - 1) == text2.charAt(startOffset);
            boolean firstCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(startOffset));
            isWordStart = !firstCharacterIsIdentifier && !previousCharacterIsSameAsNext || firstCharacterIsIdentifier && !previousCharacterIsIdentifier;
        } else {
            isWordStart = true;
        }
        if (endOffset != text2.length()) {
            boolean nextCharacterIsIdentifier = Character.isJavaIdentifierPart(text2.charAt(endOffset));
            boolean nextCharacterIsSameAsPrevious = endOffset > 0 && text2.charAt(endOffset) == text2.charAt(endOffset - 1);
            boolean lastSearchedCharacterIsIdentifier = endOffset > 0 && Character.isJavaIdentifierPart(text2.charAt(endOffset - 1));
            isWordEnd = lastSearchedCharacterIsIdentifier && !nextCharacterIsIdentifier || !lastSearchedCharacterIsIdentifier && !nextCharacterIsSameAsPrevious;
        } else {
            isWordEnd = true;
        }
        return isWordStart && isWordEnd;
    }

    @NotNull
    private static FindModel normalizeIfMultilined(@NotNull FindModel findmodel) {
        if (findmodel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findmodel", "com/intellij/find/impl/FindManagerImpl", "normalizeIfMultilined"));
        }
        if (findmodel.isMultiline()) {
            String newStringToFind;
            FindModel model2 = new FindModel();
            model2.copyFrom(findmodel);
            String s2 = model2.getStringToFind();
            if (findmodel.isRegularExpressions()) {
                newStringToFind = StringUtil.replace((String)s2, (String)"\n", (String)"\\n\\s*");
            } else {
                newStringToFind = StringUtil.escapeToRegexp((String)s2);
                model2.setRegularExpressions(true);
            }
            model2.setStringToFind(newStringToFind);
            FindModel findModel = model2;
            if (findModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "normalizeIfMultilined"));
            }
            return findModel;
        }
        FindModel findModel = findmodel;
        if (findModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "normalizeIfMultilined"));
        }
        return findModel;
    }

    @NotNull
    private FindResult doFindString(@NotNull CharSequence text2, @Nullable char[] textArray, int offset, @NotNull FindModel findmodel, @Nullable VirtualFile file2) {
        int index;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
        }
        if (findmodel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findmodel", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
        }
        FindModel model2 = FindManagerImpl.normalizeIfMultilined(findmodel);
        String toFind = model2.getStringToFind();
        if (toFind.isEmpty()) {
            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
            if (findResultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
            }
            return findResultImpl;
        }
        if (model2.isInCommentsOnly() || model2.isInStringLiteralsOnly()) {
            if (file2 == null) {
                FindResultImpl findResultImpl = NOT_FOUND_RESULT;
                if (findResultImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
                }
                return findResultImpl;
            }
            FindResult findResult = this.findInCommentsAndLiterals(text2, textArray, offset, model2, file2);
            if (findResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
            }
            return findResult;
        }
        if (model2.isRegularExpressions()) {
            FindResult findResult = FindManagerImpl.findStringByRegularExpression(text2, offset, model2);
            if (findResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
            }
            return findResult;
        }
        StringSearcher searcher = FindManagerImpl.createStringSearcher(model2);
        if (model2.isForward()) {
            int res2 = searcher.scan(text2, textArray, offset, text2.length());
            index = res2 < 0 ? -1 : res2;
        } else {
            int n2 = index = offset == 0 ? -1 : searcher.scan(text2, textArray, 0, offset - 1);
        }
        if (index < 0) {
            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
            if (findResultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
            }
            return findResultImpl;
        }
        FindResultImpl findResultImpl = new FindResultImpl(index, index + toFind.length());
        if (findResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "doFindString"));
        }
        return findResultImpl;
    }

    @NotNull
    private static StringSearcher createStringSearcher(@NotNull FindModel model2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "createStringSearcher"));
        }
        StringSearcher stringSearcher = new StringSearcher(model2.getStringToFind(), model2.isCaseSensitive(), model2.isForward());
        if (stringSearcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "createStringSearcher"));
        }
        return stringSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPreviousFindData(FindModel model2) {
        FindModel findModel = model2;
        synchronized (findModel) {
            model2.putUserData(ourCommentsLiteralsSearchDataKey, null);
            model2.putUserData(ourExceptCommentsOrLiteralsDataKey, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FindResult findInCommentsAndLiterals(@NotNull CharSequence text2, char[] textArray, int offset, @NotNull FindModel model2, final @NotNull VirtualFile file2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
        }
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
        }
        FindModel findModel = model2;
        synchronized (findModel) {
            CommentsLiteralsSearchData data;
            Language lang;
            block40: {
                Set<Language> relevantLanguages;
                TokenSet tokensOfInterest;
                SyntaxHighlighter highlighter2;
                block42: {
                    FileType ftype;
                    block41: {
                        ftype = file2.getFileType();
                        lang = null;
                        if (ftype instanceof LanguageFileType) {
                            lang = ((LanguageFileType)ftype).getLanguage();
                        }
                        if ((data = (CommentsLiteralsSearchData)model2.getUserData(ourCommentsLiteralsSearchDataKey)) != null && Comparing.equal((Object)data.lastFile, (Object)file2) && data.model.equals((Object)model2)) break block40;
                        highlighter2 = FindManagerImpl.getHighlighter(file2, lang);
                        if (highlighter2 == null) {
                            FindResultImpl findResultImpl = NOT_FOUND_RESULT;
                            // MONITOREXIT @DISABLED, blocks:[4, 27] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                            if (findResultImpl == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
                            }
                            return findResultImpl;
                        }
                        tokensOfInterest = TokenSet.EMPTY;
                        if (lang == null) break block41;
                        final Language finalLang = lang;
                        relevantLanguages = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<Language>>(){

                            public Set<Language> compute() {
                                THashSet result2 = new THashSet();
                                FileViewProvider viewProvider = PsiManager.getInstance((Project)FindManagerImpl.this.myProject).findViewProvider(file2);
                                if (viewProvider != null) {
                                    result2.addAll((Collection)viewProvider.getLanguages());
                                }
                                if (result2.isEmpty()) {
                                    result2.add((Object)finalLang);
                                }
                                return result2;
                            }
                        });
                        for (Language relevantLanguage : relevantLanguages) {
                            tokensOfInterest = FindManagerImpl.addTokenTypesForLanguage(model2, relevantLanguage, tokensOfInterest);
                        }
                        if (model2.isInStringLiteralsOnly()) {
                            IElementType convenienceXmlAttrType;
                            Lexer xmlLexer = FindManagerImpl.getHighlighter(null, Language.findLanguageByID((String)"XML")).getHighlightingLexer();
                            String marker = "xxx";
                            xmlLexer.start((CharSequence)"<a href=\"xxx\" />");
                            while (!"xxx".equals(xmlLexer.getTokenText())) {
                                xmlLexer.advance();
                                if (xmlLexer.getTokenType() != null) continue;
                            }
                            if ((convenienceXmlAttrType = xmlLexer.getTokenType()) != null) {
                                tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, TokenSet.create((IElementType[])new IElementType[]{convenienceXmlAttrType})});
                            }
                        }
                        break block42;
                    }
                    relevantLanguages = ContainerUtil.newHashSet();
                    if (ftype instanceof AbstractFileType) {
                        if (model2.isInCommentsOnly()) {
                            tokensOfInterest = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});
                        }
                        if (model2.isInStringLiteralsOnly()) {
                            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING})});
                        }
                    }
                }
                Matcher matcher = model2.isRegularExpressions() ? FindManagerImpl.compileRegExp(model2, "") : null;
                StringSearcher searcher = matcher != null ? null : new StringSearcher(model2.getStringToFind(), model2.isCaseSensitive(), true);
                SyntaxHighlighterOverEditorHighlighter highlighterAdapter = new SyntaxHighlighterOverEditorHighlighter(highlighter2, file2, this.myProject);
                data = new CommentsLiteralsSearchData(file2, relevantLanguages, highlighterAdapter, tokensOfInterest, searcher, matcher, model2.clone());
                data.highlighter.restart(text2);
                model2.putUserData(ourCommentsLiteralsSearchDataKey, (Object)data);
            }
            int initialStartOffset = model2.isForward() && data.startOffset < offset ? data.startOffset : 0;
            data.highlighter.resetPosition(initialStartOffset);
            Lexer lexer = data.highlighter.getHighlightingLexer();
            TokenSet tokens = data.tokensOfInterest;
            int lastGoodOffset = 0;
            boolean scanningForward = model2.isForward();
            FindResultImpl prevFindResult = NOT_FOUND_RESULT;
            while (true) {
                block46: {
                    int end;
                    int start2;
                    block45: {
                        block43: {
                            IElementType tokenType;
                            block44: {
                                char c2;
                                if ((tokenType = lexer.getTokenType()) == null) break block43;
                                if (lexer.getState() == 0) {
                                    lastGoodOffset = lexer.getTokenStart();
                                }
                                TextAttributesKey[] keys = data.highlighter.getTokenHighlights(tokenType);
                                if (!tokens.contains(tokenType) && (!model2.isInStringLiteralsOnly() || !ChunkExtractor.isHighlightedAsString((TextAttributesKey[])keys)) && (!model2.isInCommentsOnly() || !ChunkExtractor.isHighlightedAsComment((TextAttributesKey[])keys))) break block44;
                                start2 = lexer.getTokenStart();
                                end = lexer.getTokenEnd();
                                if (model2.isInStringLiteralsOnly() && ((c2 = text2.charAt(start2)) == '\"' || c2 == '\'')) {
                                    while (start2 < end && c2 == text2.charAt(start2)) {
                                        if (c2 != text2.charAt(end - 1) || ++start2 >= end) continue;
                                        --end;
                                    }
                                }
                                break block45;
                            }
                            Language tokenLang = tokenType.getLanguage();
                            if (tokenLang != lang && tokenLang != Language.ANY && !data.relevantLanguages.contains(tokenLang)) {
                                data.tokensOfInterest = tokens = FindManagerImpl.addTokenTypesForLanguage(model2, tokenLang, tokens);
                                data.relevantLanguages.add(tokenLang);
                            }
                            break block46;
                        }
                        FindResultImpl findResultImpl = prevFindResult;
                        // MONITOREXIT @DISABLED, blocks:[4, 7] lbl84 : MonitorExitStatement: MONITOREXIT : var6_6
                        if (findResultImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
                        }
                        return findResultImpl;
                    }
                    while (true) {
                        FindResultImpl findResult = null;
                        if (data.searcher != null) {
                            int matchStart = data.searcher.scan(text2, textArray, start2, end);
                            if (matchStart != -1 && matchStart >= start2) {
                                int matchEnd = matchStart + model2.getStringToFind().length();
                                if (matchStart >= offset || !scanningForward) {
                                    findResult = new FindResultImpl(matchStart, matchEnd);
                                } else {
                                    start2 = matchEnd;
                                    continue;
                                }
                            }
                        } else if (start2 <= end) {
                            data.matcher.reset(StringPattern.newBombedCharSequence((CharSequence)text2.subSequence(start2, end)));
                            if (data.matcher.find()) {
                                int matchEnd = start2 + data.matcher.end();
                                int matchStart = start2 + data.matcher.start();
                                if (matchStart >= offset || !scanningForward) {
                                    findResult = new FindResultImpl(matchStart, matchEnd);
                                } else {
                                    int diff = 0;
                                    if (start2 == end) {
                                        diff = scanningForward ? 1 : -1;
                                    }
                                    start2 = matchEnd + diff;
                                    continue;
                                }
                            }
                        }
                        if (findResult == null) break;
                        if (scanningForward) {
                            data.startOffset = lastGoodOffset;
                            FindResultImpl findResultImpl = findResult;
                            // MONITOREXIT @DISABLED, blocks:[4, 7, 9, 13] lbl118 : MonitorExitStatement: MONITOREXIT : var6_6
                            if (findResultImpl == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
                            }
                            return findResultImpl;
                        }
                        if (findResult.getEndOffset() >= offset) {
                            FindResultImpl findResultImpl = prevFindResult;
                            // MONITOREXIT @DISABLED, blocks:[4, 7, 9, 11] lbl124 : MonitorExitStatement: MONITOREXIT : var6_6
                            if (findResultImpl == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "findInCommentsAndLiterals"));
                            }
                            return findResultImpl;
                        }
                        prevFindResult = findResult;
                        start2 = findResult.getEndOffset();
                    }
                }
                lexer.advance();
            }
        }
    }

    private static TokenSet addTokenTypesForLanguage(FindModel model2, Language lang, TokenSet tokensOfInterest) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (definition != null) {
            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, model2.isInCommentsOnly() ? definition.getCommentTokens() : TokenSet.EMPTY});
            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, model2.isInStringLiteralsOnly() ? definition.getStringLiteralElements() : TokenSet.EMPTY});
        }
        return tokensOfInterest;
    }

    @Nullable
    private static SyntaxHighlighter getHighlighter(VirtualFile file2, @Nullable Language lang) {
        SyntaxHighlighter syntaxHighlighter;
        SyntaxHighlighter syntaxHighlighter2 = syntaxHighlighter = lang != null ? SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, null, (VirtualFile)file2) : null;
        if (lang == null || syntaxHighlighter instanceof PlainSyntaxHighlighter) {
            syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)file2.getFileType(), null, (VirtualFile)file2);
        }
        return syntaxHighlighter;
    }

    private static FindResult findStringByRegularExpression(CharSequence text2, int startOffset, FindModel model2) {
        Matcher matcher = FindManagerImpl.compileRegExp(model2, text2);
        if (matcher == null) {
            return NOT_FOUND_RESULT;
        }
        try {
            if (model2.isForward()) {
                if (matcher.find(startOffset) && matcher.end() <= text2.length()) {
                    return new FindResultImpl(matcher.start(), matcher.end());
                }
                return NOT_FOUND_RESULT;
            }
            int start2 = -1;
            int end = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start2 = matcher.start();
                end = matcher.end();
            }
            if (start2 < 0) {
                return NOT_FOUND_RESULT;
            }
            return new FindResultImpl(start2, end);
        }
        catch (StackOverflowError soe) {
            return NOT_FOUND_RESULT;
        }
    }

    private static Matcher compileRegExp(FindModel model2, CharSequence text2) {
        Pattern pattern = model2.compileRegExp();
        return pattern == null ? null : pattern.matcher(StringPattern.newBombedCharSequence((CharSequence)text2));
    }

    public String getStringToReplace(@NotNull String foundString, @NotNull FindModel model2, int startOffset, @NotNull CharSequence documentText) throws FindManager.MalformedReplacementStringException {
        if (foundString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundString", "com/intellij/find/impl/FindManagerImpl", "getStringToReplace"));
        }
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "getStringToReplace"));
        }
        if (documentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentText", "com/intellij/find/impl/FindManagerImpl", "getStringToReplace"));
        }
        String toReplace = model2.getStringToReplace();
        if (model2.isRegularExpressions()) {
            return FindManagerImpl.getStringToReplaceByRegexp(model2, documentText, startOffset);
        }
        if (model2.isPreserveCase()) {
            return FindManagerImpl.replaceWithCaseRespect(toReplace, foundString);
        }
        return toReplace;
    }

    private static String getStringToReplaceByRegexp(@NotNull FindModel model2, @NotNull CharSequence text2, int startOffset) throws FindManager.MalformedReplacementStringException {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "getStringToReplaceByRegexp"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/impl/FindManagerImpl", "getStringToReplaceByRegexp"));
        }
        Matcher matcher = FindManagerImpl.compileRegexAndFindFirst(model2, text2, startOffset);
        return FindManagerImpl.getStringToReplaceByRegexp(model2, matcher);
    }

    private static String getStringToReplaceByRegexp(@NotNull FindModel model2, Matcher matcher) throws FindManager.MalformedReplacementStringException {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindManagerImpl", "getStringToReplaceByRegexp"));
        }
        if (matcher == null) {
            return null;
        }
        try {
            String toReplace = model2.getStringToReplace();
            return new RegExReplacementBuilder(matcher).createReplacement(toReplace);
        }
        catch (Exception e2) {
            throw FindManagerImpl.createMalformedReplacementException(model2, e2);
        }
    }

    private static Matcher compileRegexAndFindFirst(FindModel model2, CharSequence text2, int startOffset) {
        model2 = FindManagerImpl.normalizeIfMultilined(model2);
        Matcher matcher = FindManagerImpl.compileRegExp(model2, text2);
        if (model2.isForward()) {
            if (!matcher.find(startOffset)) {
                return null;
            }
            if (matcher.end() > text2.length()) {
                return null;
            }
        } else {
            int start2 = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start2 = matcher.start();
            }
            if (start2 < 0) {
                return null;
            }
        }
        return matcher;
    }

    private static FindManager.MalformedReplacementStringException createMalformedReplacementException(FindModel model2, Exception e2) {
        return new FindManager.MalformedReplacementStringException(FindBundle.message("find.replace.invalid.replacement.string", model2.getStringToReplace()), (Throwable)e2);
    }

    private static String replaceWithCaseRespect(String toReplace, String foundString) {
        char foundChar;
        char replacementChar;
        if (foundString.isEmpty() || toReplace.isEmpty()) {
            return toReplace;
        }
        StringBuilder buffer = new StringBuilder();
        if (Character.isUpperCase(foundString.charAt(0))) {
            buffer.append(Character.toUpperCase(toReplace.charAt(0)));
        } else {
            buffer.append(Character.toLowerCase(toReplace.charAt(0)));
        }
        if (toReplace.length() == 1) {
            return buffer.toString();
        }
        if (foundString.length() == 1) {
            buffer.append(toReplace.substring(1));
            return buffer.toString();
        }
        boolean isReplacementLowercase = true;
        boolean isReplacementUppercase = true;
        for (int i2 = 1; i2 < toReplace.length() && (!Character.isLetter(replacementChar = toReplace.charAt(i2)) || (isReplacementLowercase &= Character.isLowerCase(replacementChar)) || (isReplacementUppercase &= Character.isUpperCase(replacementChar))); ++i2) {
        }
        boolean isTailUpper = true;
        boolean isTailLower = true;
        for (int i3 = 1; i3 < foundString.length() && (!Character.isLetter(foundChar = foundString.charAt(i3)) || (isTailUpper &= Character.isUpperCase(foundChar)) || (isTailLower &= Character.isLowerCase(foundChar))); ++i3) {
        }
        if (isTailUpper && (isReplacementLowercase || isReplacementUppercase)) {
            buffer.append(StringUtil.toUpperCase((String)toReplace.substring(1)));
        } else if (isTailLower && (isReplacementLowercase || isReplacementUppercase)) {
            buffer.append(toReplace.substring(1).toLowerCase());
        } else {
            buffer.append(toReplace.substring(1));
        }
        return buffer.toString();
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindManagerImpl", "canFindUsages"));
        }
        return element.isValid() && this.myFindUsagesManager.canFindUsages(element);
    }

    public void findUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindManagerImpl", "findUsages"));
        }
        this.findUsages(element, false);
    }

    public void findUsagesInScope(@NotNull PsiElement element, @NotNull SearchScope searchScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindManagerImpl", "findUsagesInScope"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/impl/FindManagerImpl", "findUsagesInScope"));
        }
        this.myFindUsagesManager.findUsages(element, null, null, false, searchScope);
    }

    public void findUsages(@NotNull PsiElement element, boolean showDialog2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindManagerImpl", "findUsages"));
        }
        this.myFindUsagesManager.findUsages(element, null, null, showDialog2, null);
    }

    public void showSettingsAndFindUsages(@NotNull NavigationItem[] targets) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/find/impl/FindManagerImpl", "showSettingsAndFindUsages"));
        }
        FindUsagesManager.showSettingsAndFindUsages(targets);
    }

    public void clearFindingNextUsageInFile() {
        this.myFindUsagesManager.clearFindingNextUsageInFile();
    }

    public void findUsagesInEditor(@NotNull PsiElement element, @NotNull FileEditor fileEditor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindManagerImpl", "findUsagesInEditor"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/find/impl/FindManagerImpl", "findUsagesInEditor"));
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            Document document = editor.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            this.myFindUsagesManager.findUsages(element, psiFile, fileEditor, false, null);
        }
    }

    private static boolean tryToFindNextUsageViaEditorSearchComponent(Editor editor, SearchResults.Direction forwardOrBackward) {
        EditorSearchSession search = EditorSearchSession.get(editor);
        if (search != null && search.hasMatches()) {
            if (forwardOrBackward == SearchResults.Direction.UP) {
                search.searchBackward();
            } else {
                search.searchForward();
            }
            return true;
        }
        return false;
    }

    public boolean findNextUsageInEditor(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/find/impl/FindManagerImpl", "findNextUsageInEditor"));
        }
        return this.findNextUsageInFile(fileEditor, SearchResults.Direction.DOWN);
    }

    private boolean findNextUsageInFile(@NotNull FileEditor fileEditor, @NotNull SearchResults.Direction direction) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/find/impl/FindManagerImpl", "findNextUsageInFile"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/intellij/find/impl/FindManagerImpl", "findNextUsageInFile"));
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            editor.getCaretModel().removeSecondaryCarets();
            if (FindManagerImpl.tryToFindNextUsageViaEditorSearchComponent(editor, direction)) {
                return true;
            }
            RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)this.myProject)).getHighlighters(editor);
            if (highlighters.length > 0) {
                return FindManagerImpl.highlightNextHighlighter(highlighters, editor, editor.getCaretModel().getOffset(), direction == SearchResults.Direction.DOWN, false);
            }
        }
        if (direction == SearchResults.Direction.DOWN) {
            return this.myFindUsagesManager.findNextUsageInFile(fileEditor);
        }
        return this.myFindUsagesManager.findPreviousUsageInFile(fileEditor);
    }

    public boolean findPreviousUsageInEditor(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/find/impl/FindManagerImpl", "findPreviousUsageInEditor"));
        }
        return this.findNextUsageInFile(fileEditor, SearchResults.Direction.UP);
    }

    private static boolean highlightNextHighlighter(RangeHighlighter[] highlighters, Editor editor, int offset, boolean isForward, boolean secondPass) {
        RangeHighlighter highlighterToSelect = null;
        Object wasNotFound = editor.getUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY);
        for (RangeHighlighter highlighter2 : highlighters) {
            int start2 = highlighter2.getStartOffset();
            int end = highlighter2.getEndOffset();
            if (!highlighter2.isValid() || start2 >= end) continue;
            if (isForward && (start2 > offset || start2 == offset && secondPass) && (highlighterToSelect == null || highlighterToSelect.getStartOffset() > start2)) {
                highlighterToSelect = highlighter2;
            }
            if (isForward || end >= offset && (end != offset || !secondPass) || highlighterToSelect != null && highlighterToSelect.getEndOffset() >= end) continue;
            highlighterToSelect = highlighter2;
        }
        if (highlighterToSelect != null) {
            FindManagerImpl.expandFoldRegionsIfNecessary(editor, highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor.getSelectionModel().setSelection(highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor.getCaretModel().moveToOffset(highlighterToSelect.getStartOffset());
            ScrollType scrollType = secondPass ? (isForward ? ScrollType.CENTER_UP : ScrollType.CENTER_DOWN) : (isForward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP);
            editor.getScrollingModel().scrollToCaret(scrollType);
            editor.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, null);
            return true;
        }
        if (wasNotFound == null) {
            AnAction action2;
            String shortcutsText;
            editor.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, (Object)Boolean.TRUE);
            String message2 = FindBundle.message("find.highlight.no.more.highlights.found", new Object[0]);
            message2 = isForward ? ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message2) : FindBundle.message("find.search.again.from.top.hotkey.message", message2, shortcutsText)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindPrevious")))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message2) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message2, shortcutsText));
            JComponent component = HintUtil.createInformationLabel(message2);
            LightweightHint hint = new LightweightHint(component);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
            return true;
        }
        if (!secondPass) {
            offset = isForward ? 0 : editor.getDocument().getTextLength();
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor, offset, isForward, true);
        }
        return false;
    }

    private static void expandFoldRegionsIfNecessary(@NotNull Editor editor, int startOffset, int endOffset) {
        FoldRegion region;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/FindManagerImpl", "expandFoldRegionsIfNecessary"));
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        FoldRegion[] regions = foldingModel instanceof FoldingModelEx ? ((FoldingModelEx)foldingModel).fetchTopLevel() : foldingModel.getAllFoldRegions();
        if (regions == null) {
            return;
        }
        int i2 = Arrays.binarySearch(regions, null, (o1, o2) -> {
            if (o1 == null) {
                return startOffset - o2.getEndOffset();
            }
            return o1.getEndOffset() - startOffset;
        });
        i2 = i2 < 0 ? -i2 - 1 : ++i2;
        if (i2 >= regions.length) {
            return;
        }
        ArrayList<FoldRegion> toExpand = new ArrayList<FoldRegion>();
        while (i2 < regions.length && (region = regions[i2]).getStartOffset() < endOffset) {
            if (!region.isExpanded()) {
                toExpand.add(region);
            }
            ++i2;
        }
        if (toExpand.isEmpty()) {
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> {
            for (FoldRegion region : toExpand) {
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public FindUsagesManager getFindUsagesManager() {
        FindUsagesManager findUsagesManager = this.myFindUsagesManager;
        if (findUsagesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindManagerImpl", "getFindUsagesManager"));
        }
        return findUsagesManager;
    }

    private static class CommentsLiteralsSearchData {
        final VirtualFile lastFile;
        int startOffset = 0;
        final SyntaxHighlighterOverEditorHighlighter highlighter;
        TokenSet tokensOfInterest;
        final StringSearcher searcher;
        final Matcher matcher;
        final Set<Language> relevantLanguages;
        final FindModel model;

        public CommentsLiteralsSearchData(VirtualFile lastFile, Set<Language> relevantLanguages, SyntaxHighlighterOverEditorHighlighter highlighter2, TokenSet tokensOfInterest, StringSearcher searcher, Matcher matcher, FindModel model2) {
            this.lastFile = lastFile;
            this.highlighter = highlighter2;
            this.tokensOfInterest = tokensOfInterest;
            this.searcher = searcher;
            this.matcher = matcher;
            this.relevantLanguages = relevantLanguages;
            this.model = model2;
        }
    }

    private class FindExceptCommentsOrLiteralsData
    implements Predicate<FindResult> {
        private final VirtualFile myFile;
        private final FindModel myFindModel;
        private final TreeMap<Integer, Integer> mySkipRangesSet;
        private final CharSequence myText;

        private FindExceptCommentsOrLiteralsData(VirtualFile file2, FindModel model2, CharSequence text2) {
            this.myFile = file2;
            this.myFindModel = model2.clone();
            this.myText = ImmutableCharSequence.asImmutable((CharSequence)text2);
            TreeMap<Integer, Integer> result2 = new TreeMap<Integer, Integer>();
            if (model2.isExceptComments() || model2.isExceptCommentsAndStringLiterals()) {
                this.addRanges(file2, model2, text2, result2, FindModel.SearchContext.IN_COMMENTS);
            }
            if (model2.isExceptStringLiterals() || model2.isExceptCommentsAndStringLiterals()) {
                this.addRanges(file2, model2, text2, result2, FindModel.SearchContext.IN_STRING_LITERALS);
            }
            this.mySkipRangesSet = result2;
        }

        private void addRanges(VirtualFile file2, FindModel model2, CharSequence text2, TreeMap<Integer, Integer> result2, FindModel.SearchContext searchContext) {
            FindResult customResult;
            FindModel clonedModel = model2.clone();
            clonedModel.setSearchContext(searchContext);
            clonedModel.setForward(true);
            int offset = 0;
            while ((customResult = FindManagerImpl.this.findStringLoop(text2, offset, clonedModel, file2, (Predicate<FindResult>)null)).isStringFound()) {
                result2.put(customResult.getStartOffset(), customResult.getEndOffset());
                offset = Math.max(customResult.getEndOffset(), offset + 1);
                if (offset < text2.length()) continue;
                break;
            }
        }

        boolean isAcceptableFor(FindModel model2, VirtualFile file2, CharSequence text2) {
            return Comparing.equal((Object)this.myFile, (Object)file2) && this.myFindModel.equals((Object)model2) && this.myText.length() == text2.length();
        }

        public boolean apply(@Nullable FindResult input) {
            if (input == null || !input.isStringFound()) {
                return true;
            }
            NavigableMap<Integer, Integer> map2 = this.mySkipRangesSet.headMap(input.getStartOffset(), true);
            for (Map.Entry e2 : map2.descendingMap().entrySet()) {
                if ((Integer)e2.getKey() <= input.getStartOffset() && (input.getStartOffset() <= (Integer)e2.getValue() || (Integer)e2.getValue() >= input.getEndOffset())) {
                    return false;
                }
                if ((Integer)e2.getValue() > input.getStartOffset()) continue;
                break;
            }
            return true;
        }
    }
}

