/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupDirectoryChooser
extends JPanel {
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FindPopupPanel myFindPopupPanel;
    @NotNull
    private final ComboBox<String> myDirectoryComboBox;

    public FindPopupDirectoryChooser(@NotNull FindPopupPanel panel2) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/find/impl/FindPopupDirectoryChooser", "<init>"));
        }
        super(new BorderLayout());
        this.myHelper = panel2.getHelper();
        this.myProject = panel2.getProject();
        this.myFindPopupPanel = panel2;
        this.myDirectoryComboBox = new ComboBox(200);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setColumns(40);
        }
        this.myDirectoryComboBox.setEditable(true);
        this.myDirectoryComboBox.setMaximumRowCount(8);
        ActionListener restartSearchListener2 = e2 -> this.myFindPopupPanel.scheduleResultsUpdate();
        this.myDirectoryComboBox.addActionListener(restartSearchListener2);
        FixedSizeButton mySelectDirectoryButton = new FixedSizeButton(this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)mySelectDirectoryButton, this.myDirectoryComboBox);
        mySelectDirectoryButton.setMargin((Insets)JBUI.emptyInsets());
        mySelectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(false);
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)FindPopupDirectoryChooser.this.myProject, (Component)((Object)FindPopupDirectoryChooser.this.myFindPopupPanel), null, (Consumer)new FileChooser.FileChooserConsumer(){

                    public void consume(List<VirtualFile> files2) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(true);
                            IdeFocusManager.getInstance((Project)FindPopupDirectoryChooser.this.myProject).requestFocus(FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().getEditorComponent(), true);
                            FindPopupDirectoryChooser.this.myHelper.getModel().setDirectoryName(((VirtualFile)files2.get(0)).getPresentableUrl());
                            FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().setItem(((VirtualFile)files2.get(0)).getPresentableUrl());
                        });
                    }

                    public void cancelled() {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(true);
                            IdeFocusManager.getInstance((Project)FindPopupDirectoryChooser.this.myProject).requestFocus(FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().getEditorComponent(), true);
                        });
                    }
                });
            }
        });
        MyRecursiveDirectoryAction recursiveDirectoryAction = new MyRecursiveDirectoryAction();
        int mnemonicModifiers = SystemInfo.isMac ? 640 : 512;
        recursiveDirectoryAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(89, mnemonicModifiers)), (JComponent)((Object)this.myFindPopupPanel));
        this.add((Component)this.myDirectoryComboBox, "Center");
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        buttonsPanel.add((Component)mySelectDirectoryButton);
        buttonsPanel.add(FindPopupPanel.createToolbar(new AnAction[]{recursiveDirectoryAction}).getComponent());
        this.add((Component)buttonsPanel, "East");
    }

    public void initByModel(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindPopupDirectoryChooser", "initByModel"));
        }
        String directoryName = findModel.getDirectoryName();
        List<String> strings = FindInProjectSettings.getInstance(this.myProject).getRecentDirectories();
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myDirectoryComboBox.removeAllItems();
        }
        if (directoryName != null && !directoryName.isEmpty()) {
            if (strings.contains(directoryName)) {
                strings.remove(directoryName);
            }
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i2 = strings.size() - 1; i2 >= 0; --i2) {
            this.myDirectoryComboBox.addItem((Object)strings.get(i2));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    @NotNull
    public ComboBox getComboBox() {
        ComboBox<String> comboBox = this.myDirectoryComboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupDirectoryChooser", "getComboBox"));
        }
        return comboBox;
    }

    @NotNull
    public String getDirectory() {
        String string2 = (String)this.myDirectoryComboBox.getSelectedItem();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupDirectoryChooser", "getDirectory"));
        }
        return string2;
    }

    @Nullable
    public ValidationInfo validate(@NotNull FindModel model2) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupDirectoryChooser", "validate"));
        }
        VirtualFile directory = FindInProjectUtil.getDirectory(model2);
        if (directory == null) {
            return new ValidationInfo(FindBundle.message("find.directory.not.found.error", this.getDirectory()), this.myDirectoryComboBox);
        }
        return null;
    }

    private class MyRecursiveDirectoryAction
    extends ToggleAction {
        MyRecursiveDirectoryAction() {
            super(FindBundle.message("find.scope.directory.recursive.checkbox", new Object[0]), null, AllIcons.General.Recursive);
        }

        public boolean isSelected(AnActionEvent e2) {
            return FindPopupDirectoryChooser.this.myHelper.getModel().isWithSubdirectories();
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            FindPopupDirectoryChooser.this.myHelper.getModel().setWithSubdirectories(state);
            FindPopupDirectoryChooser.this.myFindPopupPanel.scheduleResultsUpdate();
        }
    }
}

