/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindPopupScopeUIProvider;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.UIBundle;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupPanel
extends JBPanel
implements FindUI {
    private static final Logger LOG = Logger.getInstance(FindPopupPanel.class);
    private static final KeyStroke NEW_LINE = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke OK_FIND = KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128);
    private static final String SERVICE_KEY = "find.popup";
    private static final String SPLITTER_SERVICE_KEY = "find.popup.splitter";
    private JComponent myCodePreviewComponent;
    private SearchTextArea mySearchTextArea;
    private SearchTextArea myReplaceTextArea;
    private ActionListener myOkActionListener;
    private AtomicBoolean myCanClose;
    private JBLabel myOKHintLabel;
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final FindPopupScopeUI myScopeUI;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;
    private JLabel myTitleLabel;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private StateRestoringCheckBox myCbRegularExpressions;
    private StateRestoringCheckBox myCbFileFilter;
    private ActionToolbarImpl myScopeSelectionToolbar;
    private TextFieldWithAutoCompletion<String> myFileMaskField;
    private ArrayList<String> myFileMasks;
    private ActionButton myFilterContextButton;
    private ActionButton myTabResultsButton;
    private JButton myOKButton;
    private JTextArea mySearchComponent;
    private JTextArea myReplaceComponent;
    private String mySelectedContextName;
    private FindPopupScopeUI.ScopeType mySelectedScope;
    private JPanel myScopeDetailsPanel;
    private JBTable myResultsPreviewTable;
    private UsagePreviewPanel myUsagePreviewPanel;
    private JBPopup myBalloon;

    @Override
    public void showUI() {
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            return;
        }
        if (this.myBalloon != null && !this.myBalloon.isDisposed()) {
            this.myBalloon.cancel();
        }
        if (this.myBalloon == null || this.myBalloon.isDisposed()) {
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this), (JComponent)this.mySearchComponent);
            this.myBalloon = builder.setProject(this.myHelper.getProject()).setMovable(true).setResizable(true).setMayBeParent(true).setCancelOnClickOutside(true).setModalContext(false).setRequestFocus(true).setCancelCallback(() -> {
                if (!this.myCanClose.get()) {
                    return false;
                }
                List popups = JBPopupFactory.getInstance().getChildPopups((Component)((Object)this));
                if (!popups.isEmpty()) {
                    for (JBPopup popup2 : popups) {
                        popup2.cancel();
                    }
                    return false;
                }
                if (this.myScopeUI.hideAllPopups()) {
                    return false;
                }
                DimensionService.getInstance().setSize(SERVICE_KEY, this.myBalloon.getSize(), this.myHelper.getProject());
                DimensionService.getInstance().setLocation(SERVICE_KEY, this.myBalloon.getLocationOnScreen(), this.myHelper.getProject());
                return true;
            }).createPopup();
            Disposer.register((Disposable)this.myBalloon, (Disposable)this.myDisposable);
            this.registerCloseAction(this.myBalloon);
            Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
            Component parent = UIUtil.findUltimateParent((Component)window);
            RelativePoint showPoint = null;
            Point screenPoint = DimensionService.getInstance().getLocation(SERVICE_KEY);
            if (screenPoint != null) {
                showPoint = new RelativePoint(screenPoint);
            }
            if (parent != null && showPoint == null) {
                int height;
                int n2 = height = UISettings.getInstance().getShowNavigationBar() ? 135 : 115;
                if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                    height -= 20;
                }
                showPoint = new RelativePoint(parent, new Point((parent.getSize().width - this.getPreferredSize().width) / 2, height));
            }
            this.mySearchComponent.selectAll();
            WindowMoveListener windowListener = new WindowMoveListener((Component)((Object)this));
            this.myTitleLabel.addMouseListener(windowListener);
            this.myTitleLabel.addMouseMotionListener(windowListener);
            Dimension panelSize = this.getPreferredSize();
            Dimension prev = DimensionService.getInstance().getSize(SERVICE_KEY);
            if (!this.myCbPreserveCase.isVisible()) {
                panelSize.width += this.myCbPreserveCase.getPreferredSize().width + 8;
            }
            panelSize.height *= 2;
            if (prev != null && prev.height < panelSize.height) {
                prev.height = panelSize.height;
            }
            this.myBalloon.setMinimumSize(panelSize);
            if (prev == null) {
                panelSize.height = panelSize.height * 3 / 2;
            }
            this.myBalloon.setSize(prev != null ? prev : panelSize);
            if (showPoint != null && showPoint.getComponent() != null) {
                this.myBalloon.show(showPoint);
            } else {
                this.myBalloon.showCenteredInCurrentWindow(this.myProject);
            }
        }
    }

    FindPopupPanel(@NotNull FindUIHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/find/impl/FindPopupPanel", "<init>"));
        }
        this.myCanClose = new AtomicBoolean(true);
        this.myFileMasks = new ArrayList();
        this.mySelectedContextName = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.myDisposable = Disposer.newDisposable();
        this.myScopeUI = FindPopupScopeUIProvider.getInstance().create(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FindPopupPanel.this.finishPreviousPreviewSearch();
                if (FindPopupPanel.this.mySearchRescheduleOnCancellationsAlarm != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.mySearchRescheduleOnCancellationsAlarm);
                }
                if (FindPopupPanel.this.myUsagePreviewPanel != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.myUsagePreviewPanel);
                }
            }
        });
        this.initComponents();
        this.initByModel();
        ApplicationManager.getApplication().invokeLater(() -> this.scheduleResultsUpdate(), ModalityState.any());
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getDisposable"));
        }
        return disposable;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getProject"));
        }
        return project2;
    }

    @NotNull
    public FindUIHelper getHelper() {
        FindUIHelper findUIHelper = this.myHelper;
        if (findUIHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getHelper"));
        }
        return findUIHelper;
    }

    @NotNull
    public JBPopup getBalloon() {
        JBPopup jBPopup = this.myBalloon;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getBalloon"));
        }
        return jBPopup;
    }

    @NotNull
    public AtomicBoolean getCanClose() {
        AtomicBoolean atomicBoolean = this.myCanClose;
        if (atomicBoolean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getCanClose"));
        }
        return atomicBoolean;
    }

    private void initComponents() {
        this.myTitleLabel = new JBLabel(FindBundle.message("find.in.path.dialog.title", new Object[0]), UIUtil.ComponentStyle.REGULAR);
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(1));
        this.myTitleLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)0, (int)16));
        this.myCbCaseSensitive = FindPopupPanel.createCheckBox("find.popup.case.sensitive");
        ItemListener liveResultsPreviewUpdateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        };
        this.myCbCaseSensitive.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase = FindPopupPanel.createCheckBox("find.options.replace.preserve.case");
        this.myCbPreserveCase.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase.setVisible(this.myHelper.getModel().isReplaceState());
        this.myCbWholeWordsOnly = FindPopupPanel.createCheckBox("find.popup.whole.words");
        this.myCbWholeWordsOnly.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbRegularExpressions = FindPopupPanel.createCheckBox("find.popup.regex");
        this.myCbRegularExpressions.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbFileFilter = FindPopupPanel.createCheckBox("find.popup.filemask");
        this.myCbFileFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (FindPopupPanel.this.myCbFileFilter.isSelected()) {
                    FindPopupPanel.this.myFileMaskField.setEnabled(true);
                    if (FindPopupPanel.this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                        FindPopupPanel.this.myFileMaskField.selectAll();
                        IdeFocusManager.getInstance((Project)FindPopupPanel.this.myProject).requestFocus((Component)((Object)FindPopupPanel.this.myFileMaskField), true);
                    }
                } else {
                    FindPopupPanel.this.myFileMaskField.setEnabled(false);
                    if (FindPopupPanel.this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                        IdeFocusManager.getInstance((Project)FindPopupPanel.this.myProject).requestFocus((Component)FindPopupPanel.this.mySearchComponent, true);
                    }
                }
            }
        });
        this.myCbFileFilter.addItemListener(liveResultsPreviewUpdateListener);
        this.myFileMaskField = new TextFieldWithAutoCompletion<String>(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(this.myFileMasks, null), false, null){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setBackground(enabled ? JBColor.background() : UIUtil.getComboBoxDisabledBackground());
            }
        };
        this.myFileMaskField.setPreferredWidth(JBUI.scale((int)100));
        this.myFileMaskField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e2) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        final DefaultActionGroup switchContextGroup = new DefaultActionGroup();
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.ANY));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_COMMENTS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_STRING_LITERALS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_STRING_LITERALS));
        switchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS));
        switchContextGroup.setPopup(true);
        Presentation filterPresentation = new Presentation();
        filterPresentation.setIcon(AllIcons.General.Filter);
        AnAction myShowFilterPopupAction = new AnAction(){

            public void actionPerformed(AnActionEvent e2) {
                if (PlatformDataKeys.CONTEXT_COMPONENT.getData(e2.getDataContext()) == null) {
                    return;
                }
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)switchContextGroup, e2.getDataContext(), false, null, 10);
                listPopup.showUnderneathOf((Component)FindPopupPanel.this.myFilterContextButton);
            }
        };
        this.myFilterContextButton = new ActionButton(myShowFilterPopupAction, filterPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            public int getPopState() {
                int state = super.getPopState();
                if (state != 0) {
                    return state;
                }
                return FindPopupPanel.this.mySelectedContextName.equals(FindDialog.getPresentableName(FindModel.SearchContext.ANY)) ? 0 : -1;
            }
        };
        FindPopupPanel.registerPostProcessor("EditSource", (JComponent)((Object)this), () -> {
            if (this.myBalloon != null && !this.myBalloon.isDisposed()) {
                this.myBalloon.cancel();
            }
        });
        DefaultActionGroup tabResultsContextGroup = new DefaultActionGroup();
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0])){

            public boolean isSelected(AnActionEvent e2) {
                return FindSettings.getInstance().isSkipResultsWithOneUsage();
            }

            public void setSelected(AnActionEvent e2, boolean state) {
                FindPopupPanel.this.myHelper.setSkipResultsWithOneUsage(state);
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$8", "update"));
                }
                super.update(e2);
                e2.getPresentation().setVisible(!FindPopupPanel.this.myHelper.isReplaceState());
            }
        });
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0])){

            public boolean isSelected(AnActionEvent e2) {
                return FindSettings.getInstance().isShowResultsInSeparateView();
            }

            public void setSelected(AnActionEvent e2, boolean state) {
                FindPopupPanel.this.myHelper.setUseSeparateView(state);
            }
        });
        tabResultsContextGroup.setPopup(true);
        Presentation tabSettingsPresentation = new Presentation();
        tabSettingsPresentation.setIcon(AllIcons.General.SecondaryGroup);
        this.myTabResultsButton = new ActionButton((AnAction)tabResultsContextGroup, tabSettingsPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myOKButton = new JButton(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myOkActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FindModel validateModel = FindPopupPanel.this.myHelper.getModel().clone();
                FindPopupPanel.this.applyTo(validateModel, false);
                ValidationInfo validationInfo = FindPopupPanel.this.getValidationInfo(validateModel);
                if (validationInfo != null) {
                    String message2 = validationInfo.message;
                    Messages.showMessageDialog((Component)((Object)FindPopupPanel.this), (String)message2, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return;
                }
                FindPopupPanel.this.myHelper.getModel().copyFrom(validateModel);
                FindPopupPanel.this.myHelper.updateFindSettings();
                FindPopupPanel.this.myHelper.doOKAction();
                Disposer.dispose((Disposable)FindPopupPanel.this.myBalloon);
            }
        };
        this.myOKButton.addActionListener(this.myOkActionListener);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!FindPopupPanel.this.myHelper.isReplaceState()) {
                    FindPopupPanel.this.navigateToSelectedUsage();
                    return;
                }
                FindPopupPanel.this.myOkActionListener.actionPerformed(e2);
            }
        }, NEW_LINE, 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (FindPopupPanel.this.myHelper.isReplaceState()) {
                    return;
                }
                FindPopupPanel.this.myOkActionListener.actionPerformed(e2);
            }
        }, OK_FIND, 2);
        this.mySearchComponent = new JTextArea();
        this.mySearchComponent.setColumns(25);
        this.mySearchComponent.setRows(1);
        this.myReplaceComponent = new JTextArea();
        this.myReplaceComponent.setColumns(25);
        this.myReplaceComponent.setRows(1);
        this.mySearchTextArea = new SearchTextArea(this.mySearchComponent, true, true);
        this.myReplaceTextArea = new SearchTextArea(this.myReplaceComponent, false, false);
        com.intellij.ui.DocumentAdapter documentAdapter = new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(DocumentEvent e2) {
                FindPopupPanel.this.mySearchComponent.setRows(Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)FindPopupPanel.this.mySearchComponent.getText(), (char)'\n') + 1)));
                FindPopupPanel.this.myReplaceComponent.setRows(Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)FindPopupPanel.this.myReplaceComponent.getText(), (char)'\n') + 1)));
                if (FindPopupPanel.this.myBalloon == null) {
                    return;
                }
                if (e2.getDocument() == FindPopupPanel.this.mySearchComponent.getDocument()) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }
        };
        this.mySearchComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.myReplaceComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        Pair<FindPopupScopeUI.ScopeType, JComponent>[] scopeComponents = this.myScopeUI.getComponents();
        LinkedList<MySelectScopeToggleAction> scopeActions = new LinkedList<MySelectScopeToggleAction>();
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        for (Pair<FindPopupScopeUI.ScopeType, JComponent> scopeComponent : scopeComponents) {
            FindPopupScopeUI.ScopeType scopeType = (FindPopupScopeUI.ScopeType)scopeComponent.first;
            scopeActions.add(new MySelectScopeToggleAction(scopeType));
            this.myScopeDetailsPanel.add(scopeType.name, (Component)scopeComponent.second);
        }
        this.myScopeSelectionToolbar = FindPopupPanel.createToolbar(scopeActions.toArray(AnAction.EMPTY_ARRAY));
        this.mySelectedScope = (FindPopupScopeUI.ScopeType)scopeComponents[0].first;
        this.myResultsPreviewTable = new JBTable(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getWidth(), 1 + this.getRowHeight() * 4);
            }
        };
        this.myResultsPreviewTable.setFocusable(false);
        this.myResultsPreviewTable.getEmptyText().setShowAboveCenter(false);
        this.myResultsPreviewTable.setShowColumns(false);
        this.myResultsPreviewTable.getSelectionModel().setSelectionMode(0);
        this.myResultsPreviewTable.setShowGrid(false);
        this.myResultsPreviewTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (event.getSource() != FindPopupPanel.this.myResultsPreviewTable) {
                    return false;
                }
                FindPopupPanel.this.navigateToSelectedUsage();
                return true;
            }
        }.installOn((Component)this.myResultsPreviewTable);
        FindPopupPanel.applyFont(JBUI.Fonts.label(), new Component[]{this.myCbCaseSensitive, this.myCbPreserveCase, this.myCbWholeWordsOnly, this.myCbRegularExpressions, this.myResultsPreviewTable});
        ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)this.mySearchComponent);
        ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)this.myReplaceComponent);
        UIUtil.redirectKeystrokes((Disposable)this.myDisposable, (JComponent)this.mySearchComponent, (JComponent)this.myResultsPreviewTable, (KeyStroke[])new KeyStroke[]{NEW_LINE});
        UIUtil.redirectKeystrokes((Disposable)this.myDisposable, (JComponent)this.myReplaceComponent, (JComponent)this.myResultsPreviewTable, (KeyStroke[])new KeyStroke[]{NEW_LINE});
        ActionListener helpAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                HelpManager.getInstance().invokeHelp("reference.dialogs.findinpath");
            }
        };
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation(), true){

            public Dimension getPreferredSize() {
                return new Dimension(FindPopupPanel.this.myResultsPreviewTable.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 15));
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUsagePreviewPanel);
        this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    return;
                }
                int index = FindPopupPanel.this.myResultsPreviewTable.getSelectedRow();
                if (index != -1) {
                    UsageInfo usageInfo = ((UsageInfo2UsageAdapter)FindPopupPanel.this.myResultsPreviewTable.getModel().getValueAt(index, 0)).getUsageInfo();
                    FindPopupPanel.this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                    VirtualFile file2 = usageInfo.getVirtualFile();
                    String path = "";
                    if (file2 != null) {
                        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)FindPopupPanel.this.myProject.getBaseDir());
                        if (relativePath == null) {
                            relativePath = file2.getPath();
                        }
                        path = "<html><body>&nbsp;&nbsp;&nbsp;" + relativePath.replace(file2.getName(), "<b>" + file2.getName() + "</b>") + "</body></html>";
                    }
                    FindPopupPanel.this.myUsagePreviewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)path, (boolean)false, (Insets)new JBInsets(8, 0, 0, 0)).setShowLine(false));
                } else {
                    FindPopupPanel.this.myUsagePreviewPanel.updateLayout(null);
                    FindPopupPanel.this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder());
                }
            }
        });
        this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
        JBSplitter splitter = new JBSplitter(true, 0.33f);
        splitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
        splitter.setDividerWidth(JBUI.scale((int)2));
        splitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myResultsPreviewTable){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.height = ((FindPopupPanel)FindPopupPanel.this).myResultsPreviewTable.getPreferredScrollableViewportSize().height;
                return size;
            }
        };
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        splitter.setFirstComponent((JComponent)scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 4 4 0 4, fillx, hidemode 2, gap 0"));
        bottomPanel.add(this.myTabResultsButton);
        bottomPanel.add(Box.createHorizontalGlue(), "growx, pushx");
        this.myOKHintLabel = new JBLabel(KeymapUtil.getShortcutsText((Shortcut[])new Shortcut[]{new KeyboardShortcut(OK_FIND, null)}));
        this.myOKHintLabel.setEnabled(false);
        bottomPanel.add((Component)this.myOKHintLabel, "gapright 10");
        bottomPanel.add(this.myOKButton);
        this.myCodePreviewComponent = this.myUsagePreviewPanel.createComponent();
        splitter.setSecondComponent(this.myCodePreviewComponent);
        JPanel scopesPanel = new JPanel((LayoutManager)new MigLayout("flowx, gap 26, ins 0"));
        scopesPanel.add(this.myScopeSelectionToolbar.getComponent());
        scopesPanel.add((Component)this.myScopeDetailsPanel, "growx, pushx");
        this.setLayout((LayoutManager)new MigLayout("flowx, ins 4, gap 0, fillx, hidemode 3"));
        int cbGapLeft = this.myCbCaseSensitive.getInsets().left;
        int cbGapRight = this.myCbCaseSensitive.getInsets().right;
        String cbGap = cbGapLeft + cbGapRight < 16 ? "gapright " + (16 - cbGapLeft - cbGapRight) : "";
        this.add(this.myTitleLabel, "sx 2, growx, pushx, growy");
        this.add(this.myCbCaseSensitive, cbGap);
        this.add(this.myCbPreserveCase, cbGap);
        this.add(this.myCbWholeWordsOnly, cbGap);
        this.add(this.myCbRegularExpressions, "gapright 0");
        this.add((Component)RegExHelpPopup.createRegExLink("<html><body><b>?</b></body></html>", this.myCbRegularExpressions, LOG), "gapright " + (16 - cbGapLeft));
        this.add(this.myCbFileFilter);
        this.add((Component)((Object)this.myFileMaskField), "gapright 16");
        this.add(this.myFilterContextButton, "wrap");
        this.add((Component)((Object)this.mySearchTextArea), "pushx, growx, sx 10, gaptop 4, wrap");
        this.add((Component)((Object)this.myReplaceTextArea), "pushx, growx, sx 10, gaptop 4, wrap");
        this.add(scopesPanel, "sx 10, pushx, growx, ax left, wrap, gaptop 4, gapbottom 4");
        this.add((Component)splitter, "pushx, growx, growy, pushy, sx 10, wrap, pad -4 -4 4 4");
        this.add(bottomPanel, "pushx, growx, dock south, sx 10");
        MnemonicHelper.init((Component)((Object)this));
        this.setFocusCycleRoot(true);
    }

    public static ActionToolbarImpl createToolbar(AnAction ... actions2) {
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(actions2), true);
        toolbar.setForceMinimumSize(true);
        toolbar.setLayoutPolicy(0);
        return toolbar;
    }

    @NotNull
    private static StateRestoringCheckBox createCheckBox(String message2) {
        StateRestoringCheckBox checkBox2 = new StateRestoringCheckBox(FindBundle.message(message2, new Object[0]));
        checkBox2.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = checkBox2;
        if (stateRestoringCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "createCheckBox"));
        }
        return stateRestoringCheckBox;
    }

    private void registerCloseAction(JBPopup popup2) {
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction closeAction = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e2) {
                if (FindPopupPanel.this.myBalloon != null && FindPopupPanel.this.myBalloon.isVisible()) {
                    FindPopupPanel.this.myBalloon.cancel();
                }
            }
        };
        closeAction.registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), popup2.getContent(), (Disposable)popup2);
    }

    public void addNotify() {
        super.addNotify();
        ApplicationManager.getApplication().invokeLater(() -> ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable), ModalityState.any());
        this.myScopeSelectionToolbar.updateActionsImmediately();
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCbCaseSensitive.setSelected(myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(myModel.isWholeWordsOnly());
        this.myCbRegularExpressions.setSelected(myModel.isRegularExpressions());
        this.mySelectedContextName = FindDialog.getSearchContextName(myModel);
        if (myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(myModel.isPreserveCase());
        }
        this.mySelectedScope = this.myScopeUI.initByModel(myModel);
        boolean isThereFileFilter = myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty();
        try {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", Boolean.TRUE);
            this.myCbFileFilter.setSelected(isThereFileFilter);
        }
        finally {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", null);
        }
        List<Object> variants = Arrays.asList(ArrayUtil.reverseArray((Object[])FindSettings.getInstance().getRecentFileMasks()));
        this.myFileMaskField.setVariants(variants);
        if (!variants.isEmpty()) {
            this.myFileMaskField.setText((String)variants.get(0));
        }
        this.myFileMaskField.setEnabled(isThereFileFilter);
        String toSearch = myModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
        if (StringUtil.isEmpty((String)toSearch)) {
            String[] history = findInProjectSettings.getRecentFindStrings();
            toSearch = history.length > 0 ? history[history.length - 1] : "";
        }
        this.mySearchComponent.setText(toSearch);
        String toReplace = myModel.getStringToReplace();
        if (StringUtil.isEmpty((String)toReplace)) {
            String[] history = findInProjectSettings.getRecentReplaceStrings();
            toReplace = history.length > 0 ? history[history.length - 1] : "";
        }
        this.myReplaceComponent.setText(toReplace);
        this.updateControls();
        this.updateScopeDetailsPanel();
        this.updateReplaceVisibility();
    }

    private void updateControls() {
        FindModel myModel = this.myHelper.getModel();
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (myModel.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
    }

    @Override
    public void updateReplaceVisibility() {
        boolean isReplaceState = this.myHelper.isReplaceState();
        this.myTitleLabel.setText(this.myHelper.getTitle());
        this.myReplaceTextArea.setVisible(isReplaceState);
        this.myCbPreserveCase.setVisible(isReplaceState);
        this.myOKHintLabel.setVisible(!isReplaceState);
        this.myOKButton.setText(isReplaceState ? "Replace in Find Window..." : FindBundle.message("find.popup.find.button", new Object[0]));
    }

    private static void applyFont(JBFont font, Component ... components) {
        for (Component component : components) {
            component.setFont((Font)font);
        }
    }

    private void updateScopeDetailsPanel() {
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.mySelectedScope.name);
        Component firstFocusableComponent = (Component)UIUtil.uiTraverser((Component)this.myScopeDetailsPanel).bfsTraversal().find(c2 -> c2.isFocusable() && c2.isEnabled() && c2.isShowing() && (c2 instanceof JComboBox || c2 instanceof AbstractButton || c2 instanceof JTextComponent));
        this.myScopeDetailsPanel.revalidate();
        this.myScopeDetailsPanel.repaint();
        if (firstFocusableComponent != null) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(firstFocusableComponent, true));
        }
    }

    public void scheduleResultsUpdate() {
        if (this.myBalloon == null || !this.myBalloon.isVisible()) {
            return;
        }
        if (this.mySearchRescheduleOnCancellationsAlarm == null || this.mySearchRescheduleOnCancellationsAlarm.isDisposed()) {
            return;
        }
        this.updateControls();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.mySearchRescheduleOnCancellationsAlarm.addRequest(() -> this.findSettingsChanged(), 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void findSettingsChanged() {
        ProgressIndicatorBase progressIndicatorWhenSearchStarted;
        if (this.isShowing()) {
            ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
        }
        final ModalityState state = ModalityState.current();
        this.finishPreviousPreviewSearch();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.applyTo(this.myHelper.getModel(), false);
        this.myHelper.updateFindSettings();
        FindModel findInProjectModel = FindManager.getInstance((Project)this.myProject).getFindInProjectModel();
        FindModel copy = new FindModel();
        copy.copyFrom(findInProjectModel);
        findInProjectModel.copyFrom(this.myHelper.getModel());
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).changeGlobalSettings(this.myHelper.getModel());
        final FindSettings findSettings = FindSettings.getInstance();
        this.myScopeUI.applyTo(findSettings, this.mySelectedScope);
        findSettings.setFileMask(this.myHelper.getModel().getFileFilter());
        ValidationInfo result2 = this.getValidationInfo(this.myHelper.getModel());
        this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase();
        final DefaultTableModel model2 = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model2.addColumn("Usages");
        final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
        if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < this.myHelper.getModel().getStringToFind().length()) {
            DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
            int len = previousModel.getRowCount();
            for (int i2 = 0; i2 < len; ++i2) {
                UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)previousModel.getValueAt(i2, 0);
                VirtualFile file2 = usage.getFile();
                if (file2 == null) continue;
                filesToScanInitially.add(file2);
            }
        }
        this.myHelper.myPreviousModel = this.myHelper.getModel().clone();
        this.myCodePreviewComponent.setVisible(false);
        this.mySearchTextArea.setInfoText(null);
        this.myResultsPreviewTable.setModel((TableModel)model2);
        if (result2 != null) {
            this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]) + " (" + result2.message + ")");
            return;
        }
        this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new FindDialog.UsageTableCellRenderer(this.myCbFileFilter.isSelected(), false));
        this.myResultsPreviewTable.getEmptyText().setText("Searching...");
        final AtomicInteger resultsCount = new AtomicInteger();
        final AtomicInteger resultsFilesCount = new AtomicInteger();
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myResultsPreviewSearchProgress, new ReadTask(){

            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                boolean succeeded;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$22", "computeInReadAction"));
                }
                UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(findSettings.isShowResultsInSeparateView(), FindPopupPanel.this.myHelper.getModel().clone());
                boolean showPanelIfOnlyOneUsage = !findSettings.isSkipResultsWithOneUsage();
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindPopupPanel.this.myProject, showPanelIfOnlyOneUsage, presentation);
                Ref lastUsageFileRef = new Ref();
                FindInProjectUtil.findUsages(FindPopupPanel.this.myHelper.getModel().clone(), FindPopupPanel.this.myProject, (Processor<UsageInfo>)((Processor)info -> {
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    VirtualFile file2 = (VirtualFile)lastUsageFileRef.get();
                    VirtualFile usageFile = info.getVirtualFile();
                    if (file2 == null || !file2.equals(usageFile)) {
                        resultsFilesCount.incrementAndGet();
                        lastUsageFileRef.set((Object)usageFile);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        model2.addRow(new Object[]{usage});
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(true);
                        if (model2.getRowCount() == 1 && FindPopupPanel.this.myResultsPreviewTable.getModel() == model2) {
                            FindPopupPanel.this.myResultsPreviewTable.setRowSelectionInterval(0, 0);
                        }
                    }, state);
                    return resultsCount.incrementAndGet() < 100;
                }), processPresentation, filesToScanInitially);
                boolean bl = succeeded = !progressIndicatorWhenSearchStarted.isCanceled();
                if (succeeded) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress && !FindPopupPanel.this.myResultsPreviewSearchProgress.isCanceled()) {
                            int occurrences = resultsCount.get();
                            int filesWithOccurrences = resultsFilesCount.get();
                            if (occurrences == 0) {
                                FindPopupPanel.this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                            }
                            FindPopupPanel.this.myCodePreviewComponent.setVisible(occurrences > 0);
                            StringBuilder info = new StringBuilder();
                            if (occurrences > 0) {
                                boolean foundAllUsages;
                                info.append(Math.min(100, occurrences));
                                boolean bl = foundAllUsages = occurrences < 100;
                                if (!foundAllUsages) {
                                    info.append("+");
                                }
                                info.append(UIBundle.message((String)"message.matches", (Object[])new Object[]{occurrences}));
                                info.append(" in ");
                                info.append(filesWithOccurrences);
                                if (!foundAllUsages) {
                                    info.append("+");
                                }
                                info.append(UIBundle.message((String)"message.files", (Object[])new Object[]{filesWithOccurrences}));
                            }
                            FindPopupPanel.this.mySearchTextArea.setInfoText(info.toString());
                        }
                    }, state);
                }
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$22", "onCanceled"));
                }
                if (FindPopupPanel.this.isShowing() && progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }
        });
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.myCbFileFilter != null && this.myCbFileFilter.isSelected()) {
            mask = this.myFileMaskField.getText();
        }
        return mask;
    }

    @Nullable(value="null means OK")
    private ValidationInfo getValidationInfo(@NotNull FindModel model2) {
        String mask;
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "getValidationInfo"));
        }
        ValidationInfo scopeValidationInfo = this.myScopeUI.validate(model2, this.mySelectedScope);
        if (scopeValidationInfo != null) {
            return scopeValidationInfo;
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo("String to find is empty", (JComponent)this.mySearchComponent);
        }
        if (this.myCbRegularExpressions != null && this.myCbRegularExpressions.isSelected() && this.myCbRegularExpressions.isEnabled()) {
            String toFind = this.getStringToFind();
            try {
                boolean isCaseSensitive = this.myCbCaseSensitive != null && this.myCbCaseSensitive.isSelected() && this.myCbCaseSensitive.isEnabled();
                Pattern pattern = Pattern.compile(toFind, isCaseSensitive ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.mySearchComponent);
                }
            }
            catch (PatternSyntaxException e2) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e2.getDescription()), (JComponent)this.mySearchComponent);
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), this.myFileMaskField);
            }
            if (mask.contains(";")) {
                return new ValidationInfo("File masks should be comma-separated", this.myFileMaskField);
            }
            try {
                FindInProjectUtil.createFileMaskRegExp(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), this.myFileMaskField);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string2 = this.mySearchComponent.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getStringToFind"));
        }
        return string2;
    }

    @NotNull
    private String getStringToReplace() {
        String string2 = this.myReplaceComponent.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getStringToReplace"));
        }
        return string2;
    }

    private void applyTo(@NotNull FindModel model2, boolean findAll) {
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "applyTo"));
        }
        model2.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model2.isReplaceState()) {
            model2.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model2.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        String selectedSearchContextInUi = this.mySelectedContextName;
        FindModel.SearchContext searchContext = FindDialog.parseSearchContext(selectedSearchContextInUi);
        model2.setSearchContext(searchContext);
        model2.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        String stringToFind = this.getStringToFind();
        model2.setStringToFind(stringToFind);
        if (model2.isReplaceState()) {
            model2.setPromptOnReplace(true);
            model2.setReplaceAll(false);
            String stringToReplace = this.getStringToReplace();
            model2.setStringToReplace(StringUtil.convertLineSeparators((String)stringToReplace));
        }
        model2.setProjectScope(false);
        model2.setDirectoryName(null);
        model2.setModuleName(null);
        model2.setCustomScopeName(null);
        model2.setCustomScope(null);
        model2.setCustomScope(false);
        this.myScopeUI.applyTo(model2, this.mySelectedScope);
        model2.setFindAll(findAll);
        String mask = this.getFileTypeMask();
        model2.setFileFilter(mask);
    }

    private void navigateToSelectedUsage() {
        Usage[] usages = this.getSelectedUsages();
        if (usages != null) {
            this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel(), false);
            this.myBalloon.cancel();
            usages[0].navigate(true);
            for (int i2 = 1; i2 < usages.length; ++i2) {
                usages[i2].highlightInEditor();
            }
        }
    }

    @Nullable
    private Usage[] getSelectedUsages() {
        int[] rows = this.myResultsPreviewTable.getSelectedRows();
        SmartList usages = null;
        for (int row : rows) {
            Object valueAt = this.myResultsPreviewTable.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (usages == null) {
                usages = new SmartList();
            }
            Usage at = (Usage)valueAt;
            usages.add(at);
        }
        return usages != null ? (Usage[])ContainerUtil.toArray(usages, (Object[])Usage.EMPTY_ARRAY) : null;
    }

    private static boolean registerPostProcessor(@NotNull String actionId, @NotNull JComponent component, final @NotNull Runnable postProcessor) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/find/impl/FindPopupPanel", "registerPostProcessor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/find/impl/FindPopupPanel", "registerPostProcessor"));
        }
        if (postProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postProcessor", "com/intellij/find/impl/FindPopupPanel", "registerPostProcessor"));
        }
        final AnAction action2 = ActionManager.getInstance().getAction(actionId);
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        if (action2 == null || shortcuts.length == 0) {
            return false;
        }
        AnAction wrapper = new AnAction(){

            public void actionPerformed(AnActionEvent e2) {
                action2.beforeActionPerformedUpdate(e2);
                if (e2.getPresentation().isEnabled()) {
                    action2.actionPerformed(e2);
                    postProcessor.run();
                }
            }
        };
        wrapper.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), component);
        return true;
    }

    private class MySelectScopeToggleAction
    extends ToggleAction
    implements CustomComponentAction {
        private final FindPopupScopeUI.ScopeType myScope;

        public MySelectScopeToggleAction(FindPopupScopeUI.ScopeType scope) {
            super(scope.text, null, scope.icon);
            this.getTemplatePresentation().setHoveredIcon(scope.icon);
            this.getTemplatePresentation().setDisabledIcon(scope.icon);
            this.myScope = scope;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return new ActionButtonWithText((AnAction)this, presentation, "EditorToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean isSelected(AnActionEvent e2) {
            return FindPopupPanel.this.mySelectedScope == this.myScope;
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            if (state) {
                FindPopupPanel.this.mySelectedScope = this.myScope;
                FindPopupPanel.this.myScopeSelectionToolbar.updateActionsImmediately();
                FindPopupPanel.this.updateScopeDetailsPanel();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }
    }

    private class MySwitchContextToggleAction
    extends ToggleAction {
        public MySwitchContextToggleAction(FindModel.SearchContext context2) {
            super(FindDialog.getPresentableName(context2));
        }

        public void beforeActionPerformedUpdate(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction", "beforeActionPerformedUpdate"));
            }
            super.beforeActionPerformedUpdate(e2);
        }

        public boolean isSelected(AnActionEvent e2) {
            return Comparing.equal((String)FindPopupPanel.this.mySelectedContextName, (String)this.getTemplatePresentation().getText());
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            if (state) {
                FindPopupPanel.this.mySelectedContextName = this.getTemplatePresentation().getText();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }
    }
}

