/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;

class FindResultUsageInfo
extends UsageInfo {
    private final FindManager myFindManager;
    private final FindModel myFindModel;
    private final SmartPsiFileRange myAnchor;
    private Boolean myCachedResult;
    private long myTimestamp;
    private static final Key<Long> DOCUMENT_TIMESTAMP_KEY = Key.create((String)"FindResultUsageInfo.DOCUMENT_TIMESTAMP_KEY");

    FindResultUsageInfo(@NotNull FindManager finder, @NotNull PsiFile file2, int offset, @NotNull FindModel findModel, @NotNull FindResult result2) {
        if (finder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "com/intellij/find/impl/FindResultUsageInfo", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindResultUsageInfo", "<init>"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindResultUsageInfo", "<init>"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/find/impl/FindResultUsageInfo", "<init>"));
        }
        super((PsiElement)file2, result2.getStartOffset(), result2.getEndOffset());
        this.myFindManager = finder;
        this.myFindModel = findModel;
        assert (result2.isStringFound());
        this.myAnchor = this.myFindModel.isRegularExpressions() || this.myFindModel.isInCommentsOnly() || this.myFindModel.isInStringLiteralsOnly() || this.myFindModel.isExceptStringLiterals() || this.myFindModel.isExceptCommentsAndStringLiterals() || this.myFindModel.isExceptComments() ? SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiFileRangePointer(file2, TextRange.from((int)offset, (int)0)) : null;
    }

    public boolean isValid() {
        FindResult result2;
        Segment searchOffset;
        if (!super.isValid()) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getPsiFile());
        if (document == null) {
            this.myCachedResult = null;
            return false;
        }
        Boolean cachedResult = this.myCachedResult;
        if (document.getModificationStamp() == this.myTimestamp && cachedResult != null) {
            return cachedResult;
        }
        this.myTimestamp = document.getModificationStamp();
        Segment segment = this.getSegment();
        if (segment == null && !this.isFileUsage()) {
            this.myCachedResult = false;
            return false;
        }
        VirtualFile file2 = this.getPsiFile().getVirtualFile();
        if (this.isFileUsage()) {
            this.myCachedResult = file2.isValid();
            return this.myCachedResult;
        }
        if (this.myAnchor != null) {
            searchOffset = this.myAnchor.getRange();
            if (searchOffset == null) {
                this.myCachedResult = false;
                return false;
            }
        } else {
            searchOffset = segment;
        }
        int offset = searchOffset.getStartOffset();
        Long data = (Long)this.myFindModel.getUserData(DOCUMENT_TIMESTAMP_KEY);
        if (data == null || data != this.myTimestamp) {
            data = this.myTimestamp;
            FindManagerImpl.clearPreviousFindData(this.myFindModel);
        }
        this.myFindModel.putUserData(DOCUMENT_TIMESTAMP_KEY, (Object)data);
        do {
            int n2 = offset = (result2 = this.myFindManager.findString(document.getCharsSequence(), offset, this.myFindModel, file2)).getEndOffset() == offset ? offset + 1 : result2.getEndOffset();
            if (result2.isStringFound()) continue;
            this.myCachedResult = false;
            return false;
        } while (result2.getStartOffset() < segment.getStartOffset());
        boolean ret = segment.getStartOffset() == result2.getStartOffset() && segment.getEndOffset() == result2.getEndOffset();
        this.myCachedResult = ret;
        return ret;
    }

    private PsiFile getPsiFile() {
        return (PsiFile)this.getElement();
    }
}

