/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.formatting.IndentInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatterEx {
    private static FormatterEx myTestInstance;

    public static FormatterEx getInstance() {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            return (FormatterEx)application.getComponent(FormatterEx.class);
        }
        return FormatterEx.getTestInstance();
    }

    private static FormatterEx getTestInstance() {
        if (myTestInstance == null) {
            try {
                myTestInstance = (FormatterEx)Class.forName("com.intellij.formatting.FormatterImpl").newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return myTestInstance;
    }

    public abstract void format(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, FormatTextRanges var4) throws IncorrectOperationException;

    public abstract void format(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, CommonCodeStyleSettings.IndentOptions var4, FormatTextRanges var5) throws IncorrectOperationException;

    public abstract void format(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, FormatTextRanges var4, boolean var5) throws IncorrectOperationException;

    public abstract IndentInfo getWhiteSpaceBefore(FormattingDocumentModel var1, Block var2, CodeStyleSettings var3, CommonCodeStyleSettings.IndentOptions var4, TextRange var5, boolean var6);

    public abstract int adjustLineIndent(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, int var4, TextRange var5) throws IncorrectOperationException;

    @Nullable
    public abstract String getLineIndent(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, int var4, TextRange var5);

    public abstract void adjustTextRange(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, TextRange var4, boolean var5, boolean var6, boolean var7, boolean var8, IndentInfoStorage var9);

    public abstract void saveIndents(FormattingModel var1, TextRange var2, IndentInfoStorage var3, CodeStyleSettings var4, CommonCodeStyleSettings.IndentOptions var5);

    public abstract boolean isDisabled();

    public abstract void adjustLineIndentsForRange(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, TextRange var4);

    public abstract void formatAroundRange(FormattingModel var1, CodeStyleSettings var2, PsiFile var3, TextRange var4);

    public abstract void adjustTextRange(FormattingModel var1, CodeStyleSettings var2, CommonCodeStyleSettings.IndentOptions var3, TextRange var4);

    public abstract void setProgressTask(@NotNull FormattingProgressTask var1);

    public abstract int getSpacingForBlockAtOffset(FormattingModel var1, int var2);

    public static FormatterEx getInstanceEx() {
        return FormatterEx.getInstance();
    }

    public static interface IndentInfoStorage {
        public void saveIndentInfo(@Nullable IndentInfo var1, int var2);

        public IndentInfo getIndentInfo(int var1);
    }
}

