/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockAlignmentProcessor;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.BlockAlignmentProcessor;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import org.jetbrains.annotations.NotNull;

public class LeftEdgeAlignmentProcessor
extends AbstractBlockAlignmentProcessor {
    @Override
    protected IndentData calculateAlignmentAnchorIndent(@NotNull BlockAlignmentProcessor.Context context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/formatting/LeftEdgeAlignmentProcessor", "calculateAlignmentAnchorIndent"));
        }
        LeafBlockWrapper offsetResponsibleBlock = context2.alignment.getOffsetRespBlockBefore(context2.targetBlock);
        if (offsetResponsibleBlock == null) {
            return null;
        }
        WhiteSpace whiteSpace = offsetResponsibleBlock.getWhiteSpace();
        if (whiteSpace.containsLineFeeds()) {
            return new IndentData(whiteSpace.getIndentSpaces(), whiteSpace.getSpaces());
        }
        int offsetBeforeBlock = CoreFormatterUtil.getStartColumn(offsetResponsibleBlock);
        AbstractBlockWrapper prevIndentedBlock = CoreFormatterUtil.getIndentedParentBlock(context2.targetBlock);
        if (prevIndentedBlock == null) {
            return new IndentData(0, offsetBeforeBlock);
        }
        int parentIndent = prevIndentedBlock.getWhiteSpace().getIndentOffset();
        if (parentIndent > offsetBeforeBlock) {
            return new IndentData(0, offsetBeforeBlock);
        }
        return new IndentData(parentIndent, offsetBeforeBlock - parentIndent);
    }

    @Override
    protected boolean applyIndentToTheFirstBlockOnLine(@NotNull IndentData alignmentAnchorIndent, @NotNull BlockAlignmentProcessor.Context context2) {
        if (alignmentAnchorIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignmentAnchorIndent", "com/intellij/formatting/LeftEdgeAlignmentProcessor", "applyIndentToTheFirstBlockOnLine"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/formatting/LeftEdgeAlignmentProcessor", "applyIndentToTheFirstBlockOnLine"));
        }
        WhiteSpace whiteSpace = context2.targetBlock.getWhiteSpace();
        whiteSpace.setSpaces(alignmentAnchorIndent.getSpaces(), alignmentAnchorIndent.getIndentSpaces());
        return true;
    }

    @Override
    protected int getAlignmentIndentDiff(@NotNull IndentData alignmentAnchorIndent, @NotNull BlockAlignmentProcessor.Context context2) {
        if (alignmentAnchorIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alignmentAnchorIndent", "com/intellij/formatting/LeftEdgeAlignmentProcessor", "getAlignmentIndentDiff"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/formatting/LeftEdgeAlignmentProcessor", "getAlignmentIndentDiff"));
        }
        IndentData indentBeforeBlock = context2.targetBlock.getNumberOfSymbolsBeforeBlock();
        return alignmentAnchorIndent.getTotalSpaces() - indentBeforeBlock.getTotalSpaces();
    }
}

