/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProbablyIncreasingLowerboundAlgorithm<T extends AbstractBlockWrapper> {
    private List<T> myBlocks;
    private int myLastCalculatedOffset;
    private int myLastCalculatedAnswerIndex;

    public ProbablyIncreasingLowerboundAlgorithm(@NotNull List<T> blocks) {
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/formatting/ProbablyIncreasingLowerboundAlgorithm", "<init>"));
        }
        this.myLastCalculatedOffset = -1;
        this.myLastCalculatedAnswerIndex = -1;
        this.myBlocks = blocks;
    }

    public void reset() {
        this.myLastCalculatedAnswerIndex = -1;
        this.myLastCalculatedOffset = -1;
    }

    public List<T> getLeftSubList(@Nullable AbstractBlockWrapper block) {
        return this.myBlocks.subList(0, this.getLeftRespNeighborIndex(block) + 1);
    }

    public void setBlocksList(List<T> blocks) {
        this.myBlocks = blocks;
        this.reset();
    }

    @Nullable
    public AbstractBlockWrapper getLeftRespNeighbor(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/ProbablyIncreasingLowerboundAlgorithm", "getLeftRespNeighbor"));
        }
        int index = this.getLeftRespNeighborIndex(block);
        if (index == -1) {
            return null;
        }
        return (AbstractBlockWrapper)this.myBlocks.get(index);
    }

    private int getLeftRespNeighborIndex(@Nullable AbstractBlockWrapper block) {
        if (block == null) {
            return this.myBlocks.size() - 1;
        }
        int offset = block.getStartOffset();
        if (this.myLastCalculatedOffset != -1) {
            if (offset >= this.myLastCalculatedOffset) {
                this.myLastCalculatedAnswerIndex = this.calcLeftRespNeighborIndexLinear(this.myLastCalculatedAnswerIndex, offset);
                this.myLastCalculatedOffset = offset;
                return this.myLastCalculatedAnswerIndex;
            }
            this.myLastCalculatedOffset = -1;
        }
        this.myLastCalculatedOffset = offset;
        this.myLastCalculatedAnswerIndex = this.calcLeftRespNeighborIndex(offset);
        return this.myLastCalculatedAnswerIndex;
    }

    private int calcLeftRespNeighborIndexLinear(int lastAnswerIndex, int blockOffset) {
        int index = lastAnswerIndex;
        while (index + 1 < this.myBlocks.size() && blockOffset > ((AbstractBlockWrapper)this.myBlocks.get(index + 1)).getStartOffset()) {
            ++index;
        }
        return index;
    }

    private int calcLeftRespNeighborIndex(int blockOffset) {
        int l2 = -1;
        int r2 = this.myBlocks.size();
        while (r2 - l2 > 1) {
            int m2 = (l2 + r2) / 2;
            if (((AbstractBlockWrapper)this.myBlocks.get(m2)).getStartOffset() >= blockOffset) {
                r2 = m2;
                continue;
            }
            l2 = m2;
        }
        return l2;
    }
}

