/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.DebugUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RangesAssert {
    private static final Logger LOG = Logger.getInstance(RangesAssert.class);

    RangesAssert() {
    }

    public void assertInvalidRanges(int startOffset, int newEndOffset, FormattingDocumentModel model2, String message2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Invalid formatting blocks:").append(message2).append("\n");
        buffer.append("Start offset:");
        buffer.append(startOffset);
        buffer.append(" end offset:");
        buffer.append(newEndOffset);
        buffer.append("\n");
        int minOffset = Math.max(Math.min(startOffset, newEndOffset) - 20, 0);
        int maxOffset = Math.min(Math.max(startOffset, newEndOffset) + 20, model2.getTextLength());
        buffer.append("Affected text fragment:[").append(minOffset).append(",").append(maxOffset).append("] - '").append(model2.getText(new TextRange(minOffset, maxOffset))).append("'\n");
        StringBuilder messageBuffer = new StringBuilder();
        messageBuffer.append("Invalid ranges during formatting");
        if (model2 instanceof FormattingDocumentModelImpl) {
            messageBuffer.append(" in ").append(((FormattingDocumentModelImpl)model2).getFile().getLanguage());
        }
        buffer.append("File text:(").append(model2.getTextLength()).append(")\n'");
        buffer.append(model2.getText(new TextRange(0, model2.getTextLength())).toString());
        buffer.append("'\n");
        buffer.append("model (").append(model2.getClass()).append("): ").append(model2);
        Throwable currentThrowable = new Throwable();
        if (model2 instanceof FormattingDocumentModelImpl) {
            FormattingDocumentModelImpl modelImpl = (FormattingDocumentModelImpl)model2;
            buffer.append("Psi Tree:\n");
            PsiFile file2 = modelImpl.getFile();
            List roots = file2.getViewProvider().getAllFiles();
            for (PsiFile root : roots) {
                buffer.append("Root ");
                DebugUtil.treeToBuffer(buffer, (ASTNode)root.getNode(), 0, false, true, true, true);
            }
            buffer.append('\n');
            currentThrowable = RangesAssert.makeLanguageStackTrace(currentThrowable, file2);
        }
        LogMessageEx.error(LOG, messageBuffer.toString(), currentThrowable, buffer.toString());
    }

    private static Throwable makeLanguageStackTrace(@NotNull Throwable currentThrowable, @NotNull PsiFile file2) {
        if (currentThrowable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThrowable", "com/intellij/formatting/RangesAssert", "makeLanguageStackTrace"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/RangesAssert", "makeLanguageStackTrace"));
        }
        Throwable langThrowable = new Throwable();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2);
        if (builder == null) {
            return currentThrowable;
        }
        Class<?> builderClass = builder.getClass();
        Class<?> declaringClass = builderClass.getDeclaringClass();
        String guessedFileName = (declaringClass == null ? builderClass.getSimpleName() : declaringClass.getSimpleName()) + ".java";
        StackTraceElement ste = new StackTraceElement(builder.getClass().getName(), "createModel", guessedFileName, 1);
        StackTraceElement[] originalStackTrace = currentThrowable.getStackTrace();
        StackTraceElement[] modifiedStackTrace = new StackTraceElement[originalStackTrace.length + 1];
        System.arraycopy(originalStackTrace, 0, modifiedStackTrace, 1, originalStackTrace.length);
        modifiedStackTrace[0] = ste;
        langThrowable.setStackTrace(modifiedStackTrace);
        return langThrowable;
    }
}

