/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;

public class SelectedTextFormatter {
    private Project myProject;
    private Editor myEditor;
    private PsiFile myFile;
    private final String myTextBefore;
    private final int mySelectionStart;
    private final int mySelectionEnd;

    public SelectedTextFormatter(Project project2, Editor editor, PsiFile file2) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myFile = file2;
        this.myTextBefore = this.myEditor.getSelectionModel().getSelectedText();
        this.mySelectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        this.mySelectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
    }

    public void restoreSelectedText() {
        Document document = this.myEditor.getDocument();
        int start2 = this.myEditor.getSelectionModel().getSelectionStart();
        int end = this.myEditor.getSelectionModel().getSelectionEnd();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> document.replaceString(start2, end, (CharSequence)this.myTextBefore), "Configure code style on selected fragment: restore text before", null));
        this.myEditor.getSelectionModel().setSelection(this.mySelectionStart, this.mySelectionEnd);
    }

    void reformatSelectedText(@NotNull CodeStyleSettings reformatSettings) {
        if (reformatSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reformatSettings", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "reformatSelectedText"));
        }
        SelectionModel model2 = this.myEditor.getSelectionModel();
        if (model2.hasSelection()) {
            try {
                CodeStyleSettingsManager.getInstance((Project)this.myProject).setTemporarySettings(reformatSettings);
                SelectedTextFormatter.reformatRange(this.myFile, this.getSelectedRange());
            }
            finally {
                CodeStyleSettingsManager.getInstance((Project)this.myProject).dropTemporarySettings();
            }
        }
    }

    void reformatWholeFile() {
        SelectedTextFormatter.reformatRange(this.myFile, this.myFile.getTextRange());
    }

    private static void reformatRange(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "reformatRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "reformatRange"));
        }
        Project project2 = file2.getProject();
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "lambda$reformatRange$3"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "lambda$reformatRange$3"));
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "lambda$null$2"));
                }
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "lambda$null$2"));
                }
                CodeStyleManager.getInstance((Project)project2).reformatText(file2, range.getStartOffset(), range.getEndOffset());
            });
        }, "Reformat", null);
    }

    @NotNull
    TextRange getSelectedRange() {
        SelectionModel model2 = this.myEditor.getSelectionModel();
        int start2 = model2.getSelectionStart();
        int end = model2.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start2, (int)end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "getSelectedRange"));
        }
        return textRange;
    }
}

