/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class FormatProcessorUtils {
    private static int calcShift(@NotNull IndentInside oldIndent, @NotNull IndentInside newIndent, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (oldIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldIndent", "com/intellij/formatting/engine/FormatProcessorUtils", "calcShift"));
        }
        if (newIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newIndent", "com/intellij/formatting/engine/FormatProcessorUtils", "calcShift"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/formatting/engine/FormatProcessorUtils", "calcShift"));
        }
        if (oldIndent.equals(newIndent)) {
            return 0;
        }
        return newIndent.getSpacesCount(options) - oldIndent.getSpacesCount(options);
    }

    public static int replaceWhiteSpace(FormattingModel model2, @NotNull LeafBlockWrapper block, int shift, CharSequence _newWhiteSpace, CommonCodeStyleSettings.IndentOptions options) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/engine/FormatProcessorUtils", "replaceWhiteSpace"));
        }
        WhiteSpace whiteSpace = block.getWhiteSpace();
        TextRange textRange = whiteSpace.getTextRange();
        TextRange wsRange = textRange.shiftRight(shift);
        String newWhiteSpace = _newWhiteSpace.toString();
        TextRange newWhiteSpaceRange = model2 instanceof FormattingModelEx ? ((FormattingModelEx)model2).replaceWhiteSpace(wsRange, block.getNode(), newWhiteSpace) : model2.replaceWhiteSpace(wsRange, newWhiteSpace);
        shift += newWhiteSpaceRange.getLength() - textRange.getLength();
        if (block.isLeaf() && whiteSpace.containsLineFeeds() && block.containsLineFeeds()) {
            IndentInside whiteSpaceIndent;
            TextRange currentBlockRange = block.getTextRange().shiftRight(shift);
            IndentInside oldBlockIndent = whiteSpace.getInitialLastLineIndent();
            int shiftInside = FormatProcessorUtils.calcShift(oldBlockIndent, whiteSpaceIndent = IndentInside.createIndentOn(IndentInside.getLastLine(newWhiteSpace)), options);
            if (shiftInside != 0 || !oldBlockIndent.equals(whiteSpaceIndent)) {
                TextRange newBlockRange = model2.shiftIndentInsideRange(block.getNode(), currentBlockRange, shiftInside);
                shift += newBlockRange.getLength() - block.getLength();
            }
        }
        return shift;
    }
}

