/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectorRegistryImpl
extends FrameworkDetectorRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FrameworkDetectorRegistryImpl");
    private static final int REGISTRY_VERSION = 0;
    private TObjectIntHashMap<String> myDetectorIds;
    private TIntObjectHashMap<FrameworkDetector> myDetectorById;
    private MultiMap<FileType, Integer> myDetectorsByFileType;
    private int myDetectorsVersion;

    public FrameworkDetectorRegistryImpl() {
        this.loadDetectors();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.saveDetectors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDetectors() {
        HashMap<String, FrameworkDetector> newDetectors = new HashMap<String, FrameworkDetector>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            newDetectors.put(detector.getDetectorId(), detector);
        }
        this.myDetectorIds = new TObjectIntHashMap();
        File file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        int maxId = 0;
        if (file2.exists()) {
            LOG.debug("loading framework detectors registry from " + file2.getAbsolutePath());
            ArrayList<String> unknownIds = new ArrayList<String>();
            boolean versionChanged = false;
            try (DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
                input.readInt();
                this.myDetectorsVersion = input.readInt();
                int size = input.readInt();
                while (size-- > 0) {
                    String stringId = input.readUTF();
                    int intId = input.readInt();
                    maxId = Math.max(maxId, intId);
                    int version = input.readInt();
                    FrameworkDetector detector = (FrameworkDetector)newDetectors.remove(stringId);
                    if (detector != null) {
                        if (version != detector.getDetectorVersion()) {
                            LOG.info("Version of framework detector '" + stringId + "' changed: " + version + " -> " + detector.getDetectorVersion());
                            versionChanged = true;
                        }
                        this.myDetectorIds.put((Object)stringId, intId);
                        continue;
                    }
                    unknownIds.add(stringId);
                }
            }
            catch (IOException e2) {
                LOG.info((Throwable)e2);
            }
            if (!unknownIds.isEmpty()) {
                LOG.debug("Unknown framework detectors: " + unknownIds);
            }
            if (versionChanged || !newDetectors.isEmpty()) {
                if (!newDetectors.isEmpty()) {
                    LOG.info("New framework detectors: " + newDetectors.keySet());
                }
                ++this.myDetectorsVersion;
                LOG.info("Framework detection index version changed to " + this.myDetectorsVersion);
            }
        }
        int nextId = maxId + 1;
        for (String newDetector : newDetectors.keySet()) {
            this.myDetectorIds.put((Object)newDetector, nextId++);
        }
        this.myDetectorById = new TIntObjectHashMap();
        this.myDetectorsByFileType = new MultiMap();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            int id = this.myDetectorIds.get((Object)detector.getDetectorId());
            this.myDetectorsByFileType.putValue((Object)detector.getFileType(), (Object)id);
            this.myDetectorById.put(id, (Object)detector);
            LOG.debug("'" + detector.getDetectorId() + "' framework detector: id = " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDetectors() {
        File file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        FileUtil.createIfDoesntExist((File)file2);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));){
            output.writeInt(0);
            output.writeInt(this.myDetectorsVersion);
            FrameworkDetector[] detectors = (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions();
            output.writeInt(detectors.length);
            for (FrameworkDetector detector : detectors) {
                output.writeUTF(detector.getDetectorId());
                output.writeInt(this.myDetectorIds.get((Object)detector.getDetectorId()));
                output.writeInt(detector.getDetectorVersion());
            }
        }
        catch (IOException e2) {
            LOG.info((Throwable)e2);
        }
    }

    private static File getDetectorsRegistryFile() {
        return new File(FrameworkDetectorRegistryImpl.getDetectionDirPath() + File.separator + "detectors-registry.dat");
    }

    public static String getDetectionDirPath() {
        return PathManager.getSystemPath() + File.separator + "frameworks" + File.separator + "detection";
    }

    @Override
    public FrameworkType findFrameworkType(@NotNull String typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl", "findFrameworkType"));
        }
        for (FrameworkType frameworkType : this.getFrameworkTypes()) {
            if (!typeId.equals(frameworkType.getId())) continue;
            return frameworkType;
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends FrameworkType> getFrameworkTypes() {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            types.add(detector.getFrameworkType());
        }
        ArrayList<FrameworkType> arrayList = types;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl", "getFrameworkTypes"));
        }
        return arrayList;
    }

    @Override
    public int getDetectorsVersion() {
        return this.myDetectorsVersion;
    }

    @Override
    public int getDetectorId(@NotNull FrameworkDetector detector) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl", "getDetectorId"));
        }
        return this.myDetectorIds.get((Object)detector.getDetectorId());
    }

    @Override
    public FrameworkDetector getDetectorById(int id) {
        return (FrameworkDetector)this.myDetectorById.get(id);
    }

    @Override
    @NotNull
    public Collection<Integer> getDetectorIds(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl", "getDetectorIds"));
        }
        Collection collection = this.myDetectorsByFileType.get((Object)fileType);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl", "getDetectorIds"));
        }
        return collection;
    }

    @Override
    public Collection<Integer> getAllDetectorIds() {
        int[] ids = this.myDetectorIds.getValues();
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        for (int id : ids) {
            result2.add(id);
        }
        return result2;
    }
}

