/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;

@Tag(value="module")
public class DisabledAutodetectionInModuleElement {
    public static final Comparator<DisabledAutodetectionInModuleElement> COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getModuleName(), (String)o2.getModuleName(), (boolean)true);
    private String myModuleName;
    private Set<String> myFiles = new LinkedHashSet<String>();
    private Set<String> myDirectories = new LinkedHashSet<String>();

    public DisabledAutodetectionInModuleElement() {
    }

    public DisabledAutodetectionInModuleElement(String moduleName) {
        this.myModuleName = moduleName;
    }

    public DisabledAutodetectionInModuleElement(String moduleName, String url, boolean recursively) {
        this.myModuleName = moduleName;
        if (recursively) {
            this.myDirectories.add(url);
        } else {
            this.myFiles.add(url);
        }
    }

    @Attribute(value="name")
    public String getModuleName() {
        return this.myModuleName;
    }

    @Tag(value="files")
    @AbstractCollection(surroundWithTag=false, elementTag="file", elementValueAttribute="url")
    public Set<String> getFiles() {
        return this.myFiles;
    }

    @Tag(value="directories")
    @AbstractCollection(surroundWithTag=false, elementTag="directory", elementValueAttribute="url")
    public Set<String> getDirectories() {
        return this.myDirectories;
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    public void setFiles(Set<String> files2) {
        this.myFiles = files2;
    }

    public void setDirectories(Set<String> directories) {
        this.myDirectories = directories;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DisabledAutodetectionInModuleElement that = (DisabledAutodetectionInModuleElement)o2;
        return this.myDirectories.equals(that.myDirectories) && this.myFiles.equals(that.myFiles) && this.myModuleName.equals(that.myModuleName);
    }

    public int hashCode() {
        return 31 * (31 * this.myModuleName.hashCode() + this.myFiles.hashCode()) + this.myDirectories.hashCode();
    }

    public boolean isDisableInWholeModule() {
        return this.myFiles.isEmpty() && this.myDirectories.isEmpty();
    }
}

