/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.ui;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.impl.ui.DetectedFrameworkTreeNodeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class DetectedFrameworkNode
extends DetectedFrameworkTreeNodeBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.ui.DetectedFrameworkNode");
    private final DetectedFrameworkDescription myDescription;
    private final FrameworkDetectionContext myContext;

    public DetectedFrameworkNode(DetectedFrameworkDescription description, FrameworkDetectionContext context2) {
        super(description);
        this.myDescription = description;
        this.myContext = context2;
    }

    @Override
    public void renderNode(ColoredTreeCellRenderer renderer) {
        renderer.setIcon(this.myDescription.getDetector().getFrameworkType().getIcon());
        Collection files2 = this.myDescription.getRelatedFiles();
        VirtualFile firstFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)files2);
        LOG.assertTrue(firstFile != null);
        if (files2.size() == 1) {
            renderer.append(firstFile.getName());
            this.appendDirectoryPath(renderer, firstFile.getParent());
        } else {
            String commonName = firstFile.getName();
            VirtualFile commonParent = firstFile.getParent();
            for (VirtualFile file2 : files2) {
                if (commonName != null && !commonName.equals(file2.getName())) {
                    commonName = null;
                }
                if (commonParent == null || commonParent.equals(file2.getParent())) continue;
                commonParent = null;
            }
            renderer.append(files2.size() + " " + (commonName != null ? commonName : firstFile.getFileType().getDefaultExtension()) + " files");
            if (commonParent != null) {
                this.appendDirectoryPath(renderer, commonParent);
            }
        }
    }

    @Override
    public String getCheckedDescription() {
        return this.myDescription.getSetupText();
    }

    @Override
    public String getUncheckedDescription() {
        return null;
    }

    @Override
    public void disableDetection(DetectionExcludesConfiguration configuration) {
        for (VirtualFile file2 : this.myDescription.getRelatedFiles()) {
            configuration.addExcludedFile(file2, this.myDescription.getDetector().getFrameworkType());
        }
    }

    private void appendDirectoryPath(ColoredTreeCellRenderer renderer, VirtualFile dir) {
        String path = this.getRelativePath(dir);
        renderer.append(" (" + (path.isEmpty() ? "/" : path) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @NotNull
    private String getRelativePath(@NotNull VirtualFile file2) {
        String path;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode", "getRelativePath"));
        }
        VirtualFile dir = this.myContext.getBaseDir();
        if (dir != null && (path = VfsUtilCore.getRelativePath((VirtualFile)dir, (VirtualFile)file2, (char)File.separatorChar)) != null) {
            String string2 = path;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode", "getRelativePath"));
            }
            return string2;
        }
        String string3 = file2.getPresentableUrl();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/impl/ui/DetectedFrameworkNode", "getRelativePath"));
        }
        return string3;
    }
}

