/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;

public class KeymapGenerator
implements ApplicationStarter {
    public String getCommandName() {
        return "keymap";
    }

    public void premain(String[] args) {
    }

    public void main(String[] args) {
        ActionManager actionManager = ActionManager.getInstance();
        StringBuilder xml = new StringBuilder();
        xml.append("<Keymaps>\n");
        for (Keymap keymap : KeymapManagerEx.getInstanceEx().getAllKeymaps()) {
            xml.append("  <Keymap name=\"").append(keymap.getPresentableName()).append("\">\n");
            for (String id : keymap.getActionIdList()) {
                String text2;
                String shortcuts = KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts(id));
                if (StringUtil.isEmpty((String)shortcuts)) continue;
                AnAction action2 = actionManager.getAction(id);
                xml.append("    <Action id=\"").append(id).append("\">\n");
                THashSet addedShortcuts = new THashSet();
                for (Shortcut shortcut : keymap.getShortcuts(id)) {
                    String shortcutText = KeymapUtil.getShortcutText((Shortcut)shortcut);
                    if (!addedShortcuts.add(shortcutText)) continue;
                    xml.append("      <Shortcut>").append(shortcutText).append("</Shortcut>\n");
                }
                if (action2 != null && (text2 = action2.getTemplatePresentation().getText()) != null) {
                    xml.append("      <Text>").append(StringUtil.escapeXml((String)text2)).append("</Text>\n");
                }
                xml.append("    </Action>\n");
            }
            xml.append("  </Keymap>\n");
        }
        xml.append("</Keymaps>");
        String path = args.length == 2 ? args[1] : PathManager.getHomePath() + File.separator + "AllKeymaps.xml";
        File out = new File(path);
        try {
            FileUtil.writeToFile((File)out, (String)xml.toString());
            System.out.println("Saved to: " + out.getAbsolutePath());
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

