/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.core.ChangeSetsProcessor;
import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;

public class ByteContentRetriever
extends ChangeSetsProcessor {
    private final LocalHistoryFacade myVcs;
    private final FileRevisionTimestampComparator myComparator;
    private long myCurrentFileTimestamp;
    private Content myCurrentFileContent;

    public ByteContentRetriever(IdeaGateway gateway, LocalHistoryFacade vcs, VirtualFile file2, FileRevisionTimestampComparator c2) {
        super(file2.getPath());
        this.myVcs = vcs;
        this.myComparator = c2;
        Entry e2 = gateway.createTransientEntry(file2);
        this.myCurrentFileContent = e2.getContent();
        this.myCurrentFileTimestamp = e2.getTimestamp();
    }

    public byte[] getResult() {
        try {
            this.checkCurrentRevision();
            this.process();
        }
        catch (ContentFoundException ignore) {
            return this.myCurrentFileContent.getBytesIfAvailable();
        }
        return null;
    }

    @Override
    protected Pair<String, List<ChangeSet>> collectChanges() {
        final ArrayList result2 = new ArrayList();
        this.myVcs.accept(new ChangeVisitor(){

            @Override
            public void begin(ChangeSet c2) throws ChangeVisitor.StopVisitingException {
                if (c2.affectsPath(ByteContentRetriever.this.myPath)) {
                    result2.add(c2);
                }
            }
        });
        return Pair.create((Object)this.myPath, result2);
    }

    @Override
    protected void nothingToVisit() {
        this.checkCurrentRevision();
    }

    @Override
    public void visit(ChangeSet changeSet) {
        this.checkCurrentRevision();
        this.recordContentAndTimestamp(changeSet);
    }

    private void checkCurrentRevision() {
        if (this.myComparator.isSuitable(this.myCurrentFileTimestamp)) {
            throw new ContentFoundException();
        }
    }

    private void recordContentAndTimestamp(ChangeSet c2) {
        for (Change each : c2.getChanges()) {
            ContentChange cc2;
            if (!(each instanceof ContentChange) || !(cc2 = (ContentChange)each).affectsPath(this.myPath)) continue;
            this.myCurrentFileTimestamp = cc2.getOldTimestamp();
            this.myCurrentFileContent = cc2.getOldContent();
        }
    }

    private static class ContentFoundException
    extends RuntimeException {
        private ContentFoundException() {
        }
    }
}

