/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.ByteContent;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.Content;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.revisions.ChangeRevision;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryFacade {
    private final ChangeList myChangeList;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public LocalHistoryFacade(ChangeList changeList) {
        this.myChangeList = changeList;
    }

    public void beginChangeSet() {
        this.myChangeList.beginChangeSet();
    }

    public void forceBeginChangeSet() {
        if (this.myChangeList.forceBeginChangeSet()) {
            this.fireChangeSetFinished();
        }
    }

    public void endChangeSet(String name) {
        if (this.myChangeList.endChangeSet(name)) {
            this.fireChangeSetFinished();
        }
    }

    public void created(String path, boolean isDirectory) {
        this.addChange(isDirectory ? new CreateDirectoryChange(this.myChangeList.nextId(), path) : new CreateFileChange(this.myChangeList.nextId(), path));
    }

    public void contentChanged(String path, Content oldContent, long oldTimestamp) {
        this.addChange(new ContentChange(this.myChangeList.nextId(), path, oldContent, oldTimestamp));
    }

    public void renamed(String path, String oldName) {
        this.addChange(new RenameChange(this.myChangeList.nextId(), path, oldName));
    }

    public void readOnlyStatusChanged(String path, boolean oldStatus) {
        this.addChange(new ROStatusChange(this.myChangeList.nextId(), path, oldStatus));
    }

    public void moved(String path, String oldParent) {
        this.addChange(new MoveChange(this.myChangeList.nextId(), path, oldParent));
    }

    public void deleted(String path, Entry deletedEntry) {
        this.addChange(new DeleteChange(this.myChangeList.nextId(), path, deletedEntry));
    }

    public LabelImpl putSystemLabel(String name, String projectId, int color) {
        return this.putLabel(new PutSystemLabelChange(this.myChangeList.nextId(), name, projectId, color));
    }

    public LabelImpl putUserLabel(String name, String projectId) {
        return this.putLabel(new PutLabelChange(this.myChangeList.nextId(), name, projectId));
    }

    private void addChange(@NotNull Change c2) {
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/history/core/LocalHistoryFacade", "addChange"));
        }
        this.beginChangeSet();
        this.myChangeList.addChange(c2);
        this.fireChangeAdded(c2);
        this.endChangeSet(null);
    }

    public void addChangeInTests(@NotNull StructuralChange c2) {
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/history/core/LocalHistoryFacade", "addChangeInTests"));
        }
        this.addChange(c2);
    }

    private LabelImpl putLabel(final @NotNull PutLabelChange c2) {
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/history/core/LocalHistoryFacade", "putLabel"));
        }
        this.addChange(c2);
        return new LabelImpl(){

            @Override
            public long getLabelChangeId() {
                return c2.getId();
            }

            @Override
            public ByteContent getByteContent(RootEntry root, String path) {
                return LocalHistoryFacade.this.getByteContentBefore(root, path, c2);
            }
        };
    }

    public void putLabelInTests(PutLabelChange c2) {
        this.putLabel(c2);
    }

    public ChangeList getChangeListInTests() {
        return this.myChangeList;
    }

    private ByteContent getByteContentBefore(RootEntry root, String path, Change change) {
        String newPath;
        Entry entry = (root = root.copy()).findEntry(newPath = this.revertUpTo(root, path, null, change, false, false));
        if (entry == null) {
            return new ByteContent(false, null);
        }
        if (entry.isDirectory()) {
            return new ByteContent(true, null);
        }
        return new ByteContent(false, entry.getContent().getBytesIfAvailable());
    }

    public List<RecentChange> getRecentChanges(RootEntry root) {
        ArrayList<RecentChange> result2 = new ArrayList<RecentChange>();
        for (ChangeSet c2 : this.myChangeList.iterChanges()) {
            if (c2.isContentChangeOnly() || c2.isLabelOnly() || c2.getName() == null) continue;
            ChangeRevision before = new ChangeRevision(this, root, "", c2, true);
            ChangeRevision after2 = new ChangeRevision(this, root, "", c2, false);
            result2.add(new RecentChange(before, after2));
            if (result2.size() < 20) continue;
            break;
        }
        return result2;
    }

    public void accept(ChangeVisitor v2) {
        this.myChangeList.accept(v2);
    }

    public String revertUpTo(final @NotNull RootEntry root, @NotNull String path, final ChangeSet targetChangeSet, final Change targetChange, final boolean revertTargetChange, final boolean warnOnFileNotFound) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/history/core/LocalHistoryFacade", "revertUpTo"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/core/LocalHistoryFacade", "revertUpTo"));
        }
        final String[] result2 = new String[]{path};
        this.myChangeList.accept(new ChangeVisitor(){

            @Override
            public void begin(ChangeSet c2) throws ChangeVisitor.StopVisitingException {
                if (!revertTargetChange && c2.equals(targetChangeSet)) {
                    this.stop();
                }
            }

            @Override
            public void end(ChangeSet c2) throws ChangeVisitor.StopVisitingException {
                if (c2.equals(targetChangeSet)) {
                    this.stop();
                }
            }

            @Override
            public void visit(PutLabelChange c2) throws ChangeVisitor.StopVisitingException {
                if (c2.equals(targetChange)) {
                    this.stop();
                }
            }

            @Override
            public void visit(StructuralChange c2) throws ChangeVisitor.StopVisitingException {
                if (!revertTargetChange && c2.equals(targetChange)) {
                    this.stop();
                }
                c2.revertOn(root, warnOnFileNotFound);
                result2[0] = c2.revertPath(result2[0]);
                if (c2.equals(targetChange)) {
                    this.stop();
                }
            }
        });
        return result2[0];
    }

    public void addListener(final @NotNull Listener l2, @Nullable Disposable parent) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/history/core/LocalHistoryFacade", "addListener"));
        }
        this.myListeners.add(l2);
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)new Disposable(){

                public void dispose() {
                    LocalHistoryFacade.this.myListeners.remove(l2);
                }
            });
        }
    }

    public void removeListener(@NotNull Listener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/history/core/LocalHistoryFacade", "removeListener"));
        }
        this.myListeners.remove(l2);
    }

    private void fireChangeAdded(Change c2) {
        for (Listener each : this.myListeners) {
            each.changeAdded(c2);
        }
    }

    private void fireChangeSetFinished() {
        for (Listener each : this.myListeners) {
            each.changeSetFinished();
        }
    }

    public static abstract class Listener {
        public void changeAdded(Change c2) {
        }

        public void changeSetFinished() {
        }
    }
}

