/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.LocalHistoryRecordsTable;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Pair;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import java.io.File;
import java.io.IOException;

public class LocalHistoryStorage
extends AbstractStorage {
    public LocalHistoryStorage(String storageFilePath) throws IOException {
        super(storageFilePath);
    }

    public LocalHistoryStorage(String storageFilePath, PagePool pool) throws IOException {
        super(storageFilePath, pool);
    }

    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
        return new LocalHistoryRecordsTable(recordsFile, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFSTimestamp() {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getFSTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFSTimestamp(long timestamp) {
        Object object = this.myLock;
        synchronized (object) {
            ((LocalHistoryRecordsTable)this.myRecordsTable).setFSTimestamp(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastId() {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getLastId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastId(long lastId) {
        Object object = this.myLock;
        synchronized (object) {
            ((LocalHistoryRecordsTable)this.myRecordsTable).setLastId(lastId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstRecord() {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getFirstRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastRecord() {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getLastRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrevRecord(int record) {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getPrevRecord(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextRecord(int record) {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getNextRecord(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestamp(int record) {
        Object object = this.myLock;
        synchronized (object) {
            return ((LocalHistoryRecordsTable)this.myRecordsTable).getTimestamp(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, Integer> getOffsetAndSize(int id) {
        Object object = this.myLock;
        synchronized (object) {
            return Pair.create((Object)this.myRecordsTable.getAddress(id), (Object)this.myRecordsTable.getSize(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createNextRecord() throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            LocalHistoryRecordsTable table2 = (LocalHistoryRecordsTable)this.myRecordsTable;
            int id = table2.createNewRecord();
            int prev = table2.getLastRecord();
            if (prev > 0) {
                table2.setPrevRecord(id, prev);
                table2.setNextRecord(prev, id);
            } else {
                table2.setFirstRecord(id);
            }
            table2.setLastRecord(id);
            table2.setTimestamp(id, Clock.getTime());
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecordsUpTo(int idInclusively) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            LocalHistoryRecordsTable table2 = (LocalHistoryRecordsTable)this.myRecordsTable;
            int each = table2.getFirstRecord();
            if (each == 0) {
                return;
            }
            while (each != 0) {
                boolean stop2 = each == idInclusively;
                int next = table2.getNextRecord(each);
                this.doDeleteRecord(each);
                each = next;
                if (!stop2) continue;
                break;
            }
            if (each == 0) {
                table2.setFirstRecord(0);
                table2.setLastRecord(0);
            } else {
                table2.setFirstRecord(each);
                table2.setPrevRecord(each, 0);
            }
        }
    }
}

