/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamUtil {
    public static Entry readEntry(DataInput in) throws IOException {
        int type = DataInputOutputUtil.readINT((DataInput)in);
        switch (type) {
            case 0: {
                return new FileEntry(in, true);
            }
            case 1: {
                return new DirectoryEntry(in, true);
            }
        }
        throw new IOException("unexpected entry type: " + type);
    }

    public static void writeEntry(DataOutput out, Entry e2) throws IOException {
        int id = -1;
        Class<?> c2 = e2.getClass();
        if (c2.equals(FileEntry.class)) {
            id = 0;
        }
        if (c2.equals(DirectoryEntry.class)) {
            id = 1;
        }
        if (id == -1) {
            throw new IOException("unexpected entry type: " + c2);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)id);
        e2.write(out);
    }

    public static Change readChange(DataInput in) throws IOException {
        int type = DataInputOutputUtil.readINT((DataInput)in);
        switch (type) {
            case 1: {
                return new CreateFileChange(in);
            }
            case 2: {
                return new CreateDirectoryChange(in);
            }
            case 3: {
                return new ContentChange(in);
            }
            case 4: {
                return new RenameChange(in);
            }
            case 5: {
                return new ROStatusChange(in);
            }
            case 6: {
                return new MoveChange(in);
            }
            case 7: {
                return new DeleteChange(in);
            }
            case 8: {
                return new PutLabelChange(in);
            }
            case 9: {
                return new PutSystemLabelChange(in);
            }
        }
        throw new IOException("unexpected change type: " + type);
    }

    public static void writeChange(DataOutput out, Change change) throws IOException {
        int id = -1;
        Class<?> c2 = change.getClass();
        if (c2.equals(CreateFileChange.class)) {
            id = 1;
        }
        if (c2.equals(CreateDirectoryChange.class)) {
            id = 2;
        }
        if (c2.equals(ContentChange.class)) {
            id = 3;
        }
        if (c2.equals(RenameChange.class)) {
            id = 4;
        }
        if (c2.equals(ROStatusChange.class)) {
            id = 5;
        }
        if (c2.equals(MoveChange.class)) {
            id = 6;
        }
        if (c2.equals(DeleteChange.class)) {
            id = 7;
        }
        if (c2.equals(PutLabelChange.class)) {
            id = 8;
        }
        if (c2.equals(PutSystemLabelChange.class)) {
            id = 9;
        }
        if (id == -1) {
            throw new IOException("unexpected change type: " + c2);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)id);
        change.write(out);
    }

    @NotNull
    public static String readString(DataInput in) throws IOException {
        String string2 = IOUtil.readUTF((DataInput)in);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/StreamUtil", "readString"));
        }
        return string2;
    }

    public static void writeString(DataOutput out, @NotNull String s2) throws IOException {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/history/core/StreamUtil", "writeString"));
        }
        IOUtil.writeUTF((DataOutput)out, (String)s2);
    }

    @Nullable
    public static String readStringOrNull(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return StreamUtil.readString(in);
    }

    public static void writeStringOrNull(DataOutput out, @Nullable String s2) throws IOException {
        out.writeBoolean(s2 != null);
        if (s2 != null) {
            StreamUtil.writeString(out, s2);
        }
    }
}

