/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeleteChange
extends StructuralChange {
    private final Entry myDeletedEntry;

    public DeleteChange(long id, String path, Entry deletedEntry) {
        super(id, path);
        this.myDeletedEntry = deletedEntry;
    }

    public DeleteChange(DataInput in) throws IOException {
        super(in);
        this.myDeletedEntry = StreamUtil.readEntry(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        StreamUtil.writeEntry(out, this.myDeletedEntry);
    }

    public Entry getDeletedEntry() {
        return this.myDeletedEntry;
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        String parentPath = Paths.getParentOf(this.myPath);
        Entry parent = root.findEntry(parentPath);
        if (parent == null) {
            this.cannotRevert(parentPath, warnOnFileNotFound);
            return;
        }
        parent.addChild(this.myDeletedEntry.copy());
    }

    public boolean isDeletionOf(String p2) {
        String relative = Paths.relativeIfUnder(p2, this.myPath);
        if (relative == null) {
            return false;
        }
        return this.myDeletedEntry.hasEntry(relative);
    }

    @Override
    public List<Content> getContentsToPurge() {
        ArrayList<Content> result2 = new ArrayList<Content>();
        this.collectContentsRecursively(this.myDeletedEntry, result2);
        return result2;
    }

    private void collectContentsRecursively(Entry e2, List<Content> result2) {
        if (e2.isDirectory()) {
            for (Entry child : e2.getChildren()) {
                this.collectContentsRecursively(child, result2);
            }
        } else {
            result2.add(e2.getContent());
        }
    }

    @Override
    public void accept(ChangeVisitor v2) throws ChangeVisitor.StopVisitingException {
        v2.visit(this);
    }
}

