/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Paths;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MoveChange
extends StructuralChange {
    private final String myOldPath;

    public MoveChange(long id, String path, String oldParent) {
        super(id, path);
        this.myOldPath = Paths.appended(oldParent, Paths.getNameOf(path));
    }

    public MoveChange(DataInput in) throws IOException {
        super(in);
        this.myOldPath = StreamUtil.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        StreamUtil.writeString(out, this.myOldPath);
    }

    @Override
    public String getOldPath() {
        return this.myOldPath;
    }

    public String getOldParent() {
        return Paths.getParentOf(this.myOldPath);
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        Entry e2 = root.findEntry(this.myPath);
        if (e2 == null) {
            this.cannotRevert(this.myPath, warnOnFileNotFound);
            return;
        }
        this.removeEntry(e2);
        Entry oldParent = root.findEntry(this.getOldParent());
        if (oldParent == null) {
            this.cannotRevert(this.getOldParent(), warnOnFileNotFound);
            return;
        }
        oldParent.addChild(e2);
    }

    @Override
    protected String[] getAffectedPaths() {
        return new String[]{this.myPath, this.myOldPath};
    }

    @Override
    public void accept(ChangeVisitor v2) throws ChangeVisitor.StopVisitingException {
        v2.visit(this);
    }
}

