/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ROStatusChange
extends StructuralChange {
    private final boolean myOldStatus;

    public ROStatusChange(long id, String path, boolean oldStatus) {
        super(id, path);
        this.myOldStatus = oldStatus;
    }

    public ROStatusChange(DataInput in) throws IOException {
        super(in);
        this.myOldStatus = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.myOldStatus);
    }

    public boolean getOldStatus() {
        return this.myOldStatus;
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        Entry e2 = root.findEntry(this.myPath);
        if (e2 == null) {
            this.cannotRevert(this.myPath, warnOnFileNotFound);
            return;
        }
        e2.setReadOnly(this.myOldStatus);
    }

    @Override
    public void accept(ChangeVisitor v2) throws ChangeVisitor.StopVisitingException {
        v2.visit(this);
    }
}

