/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Paths;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RenameChange
extends StructuralChange {
    private final String myOldName;

    public RenameChange(long id, String path, String oldName) {
        super(id, path);
        this.myOldName = oldName;
    }

    public RenameChange(DataInput in) throws IOException {
        super(in);
        this.myOldName = StreamUtil.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        StreamUtil.writeString(out, this.myOldName);
    }

    @Override
    public String getOldPath() {
        return Paths.renamed(this.myPath, this.myOldName);
    }

    public String getOldName() {
        return this.myOldName;
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        Entry e2 = root.findEntry(this.myPath);
        if (e2 == null) {
            this.cannotRevert(this.myPath, warnOnFileNotFound);
            return;
        }
        e2.setName(this.myOldName);
    }

    @Override
    protected String[] getAffectedPaths() {
        return new String[]{this.myPath, this.getOldPath()};
    }

    @Override
    public void accept(ChangeVisitor v2) throws ChangeVisitor.StopVisitingException {
        v2.visit(this);
    }
}

