/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGateway {
    private static final Key<ContentAndTimestamps> SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY = Key.create((String)"LocalHistory.SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY");
    private static final ThreadLocal<VfsEventDispatchContext> ourCurrentEventDispatchContext = new ThreadLocal();

    public boolean isVersioned(@NotNull VirtualFile f2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "isVersioned"));
        }
        return this.isVersioned(f2, false);
    }

    public boolean isVersioned(@NotNull VirtualFile f2, boolean shouldBeInContent) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "isVersioned"));
        }
        if (!f2.isInLocalFileSystem()) {
            return false;
        }
        if (!f2.isDirectory() && StringUtil.endsWith((CharSequence)f2.getNameSequence(), (CharSequence)".class")) {
            return false;
        }
        VersionedFilterData versionedFilterData = IdeaGateway.getVersionedFilterData();
        boolean isInContent = false;
        int numberOfOpenProjects = versionedFilterData.myOpenedProjects.size();
        for (int i2 = 0; i2 < numberOfOpenProjects; ++i2) {
            if (f2.equals(versionedFilterData.myWorkspaceFiles.get(i2))) {
                return false;
            }
            ProjectFileIndex index = versionedFilterData.myProjectFileIndices.get(i2);
            if (index.isExcluded(f2)) {
                return false;
            }
            isInContent |= index.isInContent(f2);
        }
        if (shouldBeInContent && !isInContent) {
            return false;
        }
        return numberOfOpenProjects != 0 || !FileTypeManager.getInstance().isFileIgnored(f2);
    }

    @NotNull
    protected static VersionedFilterData getVersionedFilterData() {
        VersionedFilterData versionedFilterData;
        VfsEventDispatchContext vfsEventDispatchContext = ourCurrentEventDispatchContext.get();
        if (vfsEventDispatchContext != null) {
            versionedFilterData = vfsEventDispatchContext.myFilterData;
            if (versionedFilterData == null) {
                versionedFilterData = vfsEventDispatchContext.myFilterData = new VersionedFilterData();
            }
        } else {
            versionedFilterData = new VersionedFilterData();
        }
        VersionedFilterData versionedFilterData2 = versionedFilterData;
        if (versionedFilterData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getVersionedFilterData"));
        }
        return versionedFilterData2;
    }

    public void runWithVfsEventsDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents, Runnable action2) {
        try (VfsEventDispatchContext ignored = new VfsEventDispatchContext(events, beforeEvents);){
            action2.run();
        }
    }

    public boolean areContentChangesVersioned(@NotNull VirtualFile f2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "areContentChangesVersioned"));
        }
        return this.isVersioned(f2) && !f2.isDirectory() && !f2.getFileType().isBinary();
    }

    public boolean areContentChangesVersioned(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/history/integration/IdeaGateway", "areContentChangesVersioned"));
        }
        return !FileTypeManager.getInstance().getFileTypeByFileName(fileName).isBinary();
    }

    public boolean ensureFilesAreWritable(@NotNull Project p2, @NotNull List<VirtualFile> ff) {
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/history/integration/IdeaGateway", "ensureFilesAreWritable"));
        }
        if (ff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ff", "com/intellij/history/integration/IdeaGateway", "ensureFilesAreWritable"));
        }
        ReadonlyStatusHandler h2 = ReadonlyStatusHandler.getInstance((Project)p2);
        return !h2.ensureFilesWritable(VfsUtilCore.toVirtualFileArray(ff)).hasReadonlyFiles();
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "findVirtualFile"));
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        VirtualFile f2 = parent.findChild(name);
        if (f2 != null && f2.isDirectory() != isDirectory) {
            f2.delete((Object)this);
            f2 = null;
        }
        if (f2 == null) {
            f2 = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f2;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull String path, boolean isDirectory) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        VirtualFile f2 = this.findVirtualFile(path);
        if (f2 != null && f2.isDirectory() != isDirectory) {
            f2.delete((Object)this);
            f2 = null;
        }
        if (f2 == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path), true);
            String name = Paths.getNameOf(path);
            f2 = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f2;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "findOrCreateFileSafely"));
        }
        return virtualFile;
    }

    public List<VirtualFile> getAllFilesFrom(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "getAllFilesFrom"));
        }
        VirtualFile f2 = this.findVirtualFile(path);
        if (f2 == null) {
            return Collections.emptyList();
        }
        return IdeaGateway.collectFiles(f2, new ArrayList<VirtualFile>());
    }

    @NotNull
    private static List<VirtualFile> collectFiles(@NotNull VirtualFile f2, @NotNull List<VirtualFile> result2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "collectFiles"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/history/integration/IdeaGateway", "collectFiles"));
        }
        if (f2.isDirectory()) {
            for (VirtualFile child : IdeaGateway.iterateDBChildren(f2)) {
                IdeaGateway.collectFiles(child, result2);
            }
        } else {
            result2.add(f2);
        }
        List<VirtualFile> list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "collectFiles"));
        }
        return list2;
    }

    @NotNull
    public static Iterable<VirtualFile> iterateDBChildren(VirtualFile f2) {
        if (!(f2 instanceof NewVirtualFile)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "iterateDBChildren"));
            }
            return list2;
        }
        NewVirtualFile nf = (NewVirtualFile)f2;
        Iterable iterable = nf.iterInDbChildren();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "iterateDBChildren"));
        }
        return iterable;
    }

    @NotNull
    public static Iterable<VirtualFile> loadAndIterateChildren(VirtualFile f2) {
        if (!(f2 instanceof NewVirtualFile)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "loadAndIterateChildren"));
            }
            return list2;
        }
        NewVirtualFile nf = (NewVirtualFile)f2;
        List<VirtualFile> list3 = Arrays.asList(nf.getChildren());
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "loadAndIterateChildren"));
        }
        return list3;
    }

    @NotNull
    public RootEntry createTransientRootEntry() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false);
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "createTransientRootEntry"));
        }
        return rootEntry;
    }

    @NotNull
    public RootEntry createTransientRootEntryForPathOnly(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "createTransientRootEntryForPathOnly"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildrenForPathOnly(root, path, IdeaGateway.getLocalRoots());
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "createTransientRootEntryForPathOnly"));
        }
        return rootEntry;
    }

    private static List<VirtualFile> getLocalRoots() {
        return Arrays.asList(ManagingFS.getInstance().getLocalRoots());
    }

    private void doCreateChildrenForPathOnly(@NotNull DirectoryEntry parent, @NotNull String path, @NotNull Iterable<VirtualFile> children2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/history/integration/IdeaGateway", "doCreateChildrenForPathOnly"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "doCreateChildrenForPathOnly"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/history/integration/IdeaGateway", "doCreateChildrenForPathOnly"));
        }
        for (VirtualFile child : children2) {
            Entry e2;
            String rest;
            String name = StringUtil.trimStart((String)child.getName(), (String)"/");
            if (!path.startsWith(name) || !(rest = path.substring(name.length())).isEmpty() && rest.charAt(0) != '/') continue;
            if (!rest.isEmpty() && rest.charAt(0) == '/') {
                rest = rest.substring(1);
            }
            if ((e2 = this.doCreateEntryForPathOnly(child, rest)) == null) continue;
            parent.addChild(e2);
        }
    }

    @Nullable
    private Entry doCreateEntryForPathOnly(@NotNull VirtualFile file2, @NotNull String path) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "doCreateEntryForPathOnly"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "doCreateEntryForPathOnly"));
        }
        if (!file2.isDirectory()) {
            if (!this.isVersioned(file2)) {
                return null;
            }
            return this.doCreateFileEntry(file2, IdeaGateway.getActualContentNoAcquire(file2));
        }
        DirectoryEntry newDir = new DirectoryEntry(file2.getName());
        this.doCreateChildrenForPathOnly(newDir, path, IdeaGateway.iterateDBChildren(file2));
        if (!this.isVersioned(file2) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @Nullable
    public Entry createTransientEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "createTransientEntry"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file2, false);
    }

    @Nullable
    public Entry createEntryForDeletion(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "createEntryForDeletion"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file2, true);
    }

    @Nullable
    private Entry doCreateEntry(@NotNull VirtualFile file2, boolean forDeletion) {
        int nameId;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "doCreateEntry"));
        }
        if (!file2.isDirectory()) {
            Pair<StoredContent, Long> contentAndStamps;
            if (!this.isVersioned(file2)) {
                return null;
            }
            if (forDeletion) {
                FileDocumentManager m2 = FileDocumentManager.getInstance();
                Document d2 = m2.isFileModified(file2) ? m2.getCachedDocument(file2) : null;
                contentAndStamps = this.acquireAndClearCurrentContent(file2, d2);
            } else {
                contentAndStamps = IdeaGateway.getActualContentNoAcquire(file2);
            }
            return this.doCreateFileEntry(file2, contentAndStamps);
        }
        DirectoryEntry newDir = null;
        if (file2 instanceof VirtualFileSystemEntry && (nameId = ((VirtualFileSystemEntry)file2).getNameId()) > 0) {
            newDir = new DirectoryEntry(nameId);
        }
        if (newDir == null) {
            newDir = new DirectoryEntry(file2.getName());
        }
        this.doCreateChildren(newDir, IdeaGateway.iterateDBChildren(file2), forDeletion);
        if (!this.isVersioned(file2) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @NotNull
    private Entry doCreateFileEntry(@NotNull VirtualFile file2, Pair<StoredContent, Long> contentAndStamps) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/history/integration/IdeaGateway", "doCreateFileEntry"));
        }
        if (file2 instanceof VirtualFileSystemEntry) {
            FileEntry fileEntry = new FileEntry(((VirtualFileSystemEntry)file2).getNameId(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file2.isWritable());
            if (fileEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "doCreateFileEntry"));
            }
            return fileEntry;
        }
        FileEntry fileEntry = new FileEntry(file2.getName(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file2.isWritable());
        if (fileEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "doCreateFileEntry"));
        }
        return fileEntry;
    }

    private void doCreateChildren(@NotNull DirectoryEntry parent, Iterable<VirtualFile> children2, boolean forDeletion) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/history/integration/IdeaGateway", "doCreateChildren"));
        }
        List entries = ContainerUtil.mapNotNull(children2, (Function)((NullableFunction)each -> this.doCreateEntry((VirtualFile)each, forDeletion)));
        parent.addChildren(entries);
    }

    public void registerUnsavedDocuments(@NotNull LocalHistoryFacade vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/IdeaGateway", "registerUnsavedDocuments"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/IdeaGateway", "lambda$registerUnsavedDocuments$1"));
            }
            vcs.beginChangeSet();
            for (Document d2 : FileDocumentManager.getInstance().getUnsavedDocuments()) {
                VirtualFile f2 = IdeaGateway.getFile(d2);
                if (!this.shouldRegisterDocument(f2)) continue;
                this.registerDocumentContents(vcs, f2, d2);
            }
            vcs.endChangeSet(null);
        });
    }

    private boolean shouldRegisterDocument(@Nullable VirtualFile f2) {
        return f2 != null && f2.isValid() && this.areContentChangesVersioned(f2);
    }

    private void registerDocumentContents(@NotNull LocalHistoryFacade vcs, @NotNull VirtualFile f2, Document d2) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/history/integration/IdeaGateway", "registerDocumentContents"));
        }
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "registerDocumentContents"));
        }
        Pair<StoredContent, Long> contentAndStamp = this.acquireAndUpdateActualContent(f2, d2);
        if (contentAndStamp != null) {
            vcs.contentChanged(f2.getPath(), (Content)contentAndStamp.first, (Long)contentAndStamp.second);
        }
    }

    @Nullable
    public Pair<StoredContent, Long> acquireAndUpdateActualContent(@NotNull VirtualFile f2, @Nullable Document d2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "acquireAndUpdateActualContent"));
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f2.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        if (contentAndStamp == null) {
            if (d2 != null) {
                IdeaGateway.saveDocumentContent(f2, d2);
            }
            return Pair.create((Object)StoredContent.acquireContent(f2), (Object)f2.getTimeStamp());
        }
        if (d2 == null) {
            f2.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
            return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
        }
        if (d2.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        IdeaGateway.saveDocumentContent(f2, d2);
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    private static void saveDocumentContent(@NotNull VirtualFile f2, @NotNull Document d2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "saveDocumentContent"));
        }
        if (d2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/history/integration/IdeaGateway", "saveDocumentContent"));
        }
        f2.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, (Object)new ContentAndTimestamps(Clock.getTime(), StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d2)), d2.getModificationStamp()));
    }

    @NotNull
    public Pair<StoredContent, Long> acquireAndClearCurrentContent(@NotNull VirtualFile f2, @Nullable Document d2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f2.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        f2.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d2 != null && contentAndStamp != null && d2.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            Pair pair = Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
            }
            return pair;
        }
        if (contentAndStamp != null) {
            contentAndStamp.content.release();
        }
        if (d2 != null) {
            Pair pair = Pair.create((Object)StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d2)), (Object)Clock.getTime());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)StoredContent.acquireContent(f2), (Object)f2.getTimeStamp());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "acquireAndClearCurrentContent"));
        }
        return pair;
    }

    @NotNull
    private static Pair<StoredContent, Long> getActualContentNoAcquire(@NotNull VirtualFile f2) {
        if (f2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/IdeaGateway", "getActualContentNoAcquire"));
        }
        ContentAndTimestamps result2 = (ContentAndTimestamps)f2.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        if (result2 == null) {
            Pair pair = Pair.create((Object)StoredContent.transientContent(f2), (Object)f2.getTimeStamp());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getActualContentNoAcquire"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)result2.content, (Object)result2.registeredTimestamp);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getActualContentNoAcquire"));
        }
        return pair;
    }

    private static byte[] bytesFromDocument(@NotNull Document d2) {
        if (d2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/history/integration/IdeaGateway", "bytesFromDocument"));
        }
        try {
            return d2.getText().getBytes(IdeaGateway.getFile(d2).getCharset().name());
        }
        catch (UnsupportedEncodingException e2) {
            return d2.getText().getBytes();
        }
    }

    public String stringFromBytes(@NotNull byte[] bytes, @NotNull String path) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/history/integration/IdeaGateway", "stringFromBytes"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "stringFromBytes"));
        }
        try {
            VirtualFile file2 = this.findVirtualFile(path);
            if (file2 == null) {
                return CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
            }
            return new String(bytes, file2.getCharset().name());
        }
        catch (UnsupportedEncodingException e1) {
            return new String(bytes);
        }
    }

    public void saveAllUnsavedDocuments() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Document d2) {
        if (d2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/history/integration/IdeaGateway", "getFile"));
        }
        return FileDocumentManager.getInstance().getFile(d2);
    }

    @Nullable
    public Document getDocument(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/history/integration/IdeaGateway", "getDocument"));
        }
        return FileDocumentManager.getInstance().getDocument(this.findVirtualFile(path));
    }

    @NotNull
    public FileType getFileType(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/history/integration/IdeaGateway", "getFileType"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/integration/IdeaGateway", "getFileType"));
        }
        return fileType;
    }

    private static class ContentAndTimestamps {
        long registeredTimestamp;
        StoredContent content;
        long documentModificationStamp;

        private ContentAndTimestamps(long registeredTimestamp, StoredContent content2, long documentModificationStamp) {
            this.registeredTimestamp = registeredTimestamp;
            this.content = content2;
            this.documentModificationStamp = documentModificationStamp;
        }
    }

    private static class VersionedFilterData {
        final List<Project> myOpenedProjects = new ArrayList<Project>();
        final List<ProjectFileIndex> myProjectFileIndices = new ArrayList<ProjectFileIndex>();
        final List<VirtualFile> myWorkspaceFiles = new ArrayList<VirtualFile>();

        VersionedFilterData() {
            Project[] openProjects;
            for (Project each : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (each.isDefault() || !each.isInitialized()) continue;
                this.myWorkspaceFiles.add(each.getWorkspaceFile());
                this.myOpenedProjects.add(each);
                this.myProjectFileIndices.add(ProjectRootManager.getInstance((Project)each).getFileIndex());
            }
        }
    }

    private static class VfsEventDispatchContext
    implements AutoCloseable {
        final List<? extends VFileEvent> myEvents;
        final boolean myBeforeEvents;
        final VfsEventDispatchContext myPreviousContext;
        VersionedFilterData myFilterData;

        VfsEventDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents) {
            this.myEvents = events;
            this.myBeforeEvents = beforeEvents;
            this.myPreviousContext = (VfsEventDispatchContext)ourCurrentEventDispatchContext.get();
            if (this.myPreviousContext != null) {
                this.myFilterData = this.myPreviousContext.myFilterData;
            }
            ourCurrentEventDispatchContext.set(this);
        }

        @Override
        public void close() {
            ourCurrentEventDispatchContext.set(this.myPreviousContext);
            if (this.myPreviousContext != null && this.myPreviousContext.myFilterData == null && this.myFilterData != null) {
                this.myPreviousContext.myFilterData = this.myFilterData;
            }
        }
    }
}

