/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryEventDispatcher
extends VirtualFileAdapter
implements VirtualFileManagerListener,
CommandListener,
BulkFileListener {
    private static final Key<Boolean> WAS_VERSIONED_KEY = Key.create((String)(LocalHistoryEventDispatcher.class.getSimpleName() + ".WAS_VERSIONED_KEY"));
    private final LocalHistoryFacade myVcs;
    private final IdeaGateway myGateway;
    private final EventDispatcher<VirtualFileListener> myVfsEventsDispatcher = EventDispatcher.create(VirtualFileListener.class);

    public LocalHistoryEventDispatcher(LocalHistoryFacade vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myVfsEventsDispatcher.addListener((EventListener)((Object)this));
    }

    public void beforeRefreshStart(boolean asynchronous) {
        this.beginChangeSet();
    }

    public void afterRefreshFinish(boolean asynchronous) {
        this.endChangeSet(LocalHistoryBundle.message("system.label.external.change", new Object[0]));
    }

    public void commandStarted(CommandEvent e2) {
        this.beginChangeSet();
    }

    public void beforeCommandFinished(CommandEvent e2) {
    }

    public void commandFinished(CommandEvent e2) {
        this.endChangeSet(e2.getCommandName());
    }

    public void undoTransparentActionStarted() {
    }

    public void undoTransparentActionFinished() {
    }

    public void startAction() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.myVcs.forceBeginChangeSet();
    }

    public void finishAction(String name) {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.endChangeSet(name);
    }

    private void beginChangeSet() {
        this.myVcs.beginChangeSet();
    }

    private void endChangeSet(String name) {
        this.myVcs.endChangeSet(name);
    }

    public void fileCreated(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "fileCreated"));
        }
        this.beginChangeSet();
        this.createRecursively(e2.getFile());
        this.endChangeSet(null);
    }

    private void createRecursively(VirtualFile f2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile f2) {
                if (f2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/LocalHistoryEventDispatcher$1", "visitFile"));
                }
                if (LocalHistoryEventDispatcher.this.isVersioned(f2)) {
                    LocalHistoryEventDispatcher.this.myVcs.created(f2.getPath(), f2.isDirectory());
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f2) {
                if (f2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/history/integration/LocalHistoryEventDispatcher$1", "getChildrenIterable"));
                }
                return LocalHistoryEventDispatcher.this.myGateway.isVersioned(f2, true) ? IdeaGateway.loadAndIterateChildren(f2) : IdeaGateway.iterateDBChildren(f2);
            }
        });
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "beforeContentsChange"));
        }
        if (!this.areContentChangesVersioned(e2)) {
            return;
        }
        VirtualFile f2 = e2.getFile();
        Pair<StoredContent, Long> content2 = this.myGateway.acquireAndUpdateActualContent(f2, null);
        if (content2 != null) {
            this.myVcs.contentChanged(f2.getPath(), (Content)content2.first, (Long)content2.second);
        }
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "beforePropertyChange"));
        }
        if ("name".equals(e2.getPropertyName())) {
            VirtualFile f2 = e2.getFile();
            f2.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f2));
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "propertyChanged"));
        }
        if ("name".equals(e2.getPropertyName())) {
            VirtualFile f2 = e2.getFile();
            boolean isVersioned = this.myGateway.isVersioned(f2);
            Boolean wasVersioned = (Boolean)f2.getUserData(WAS_VERSIONED_KEY);
            if (wasVersioned == null) {
                return;
            }
            f2.putUserData(WAS_VERSIONED_KEY, null);
            if (!wasVersioned.booleanValue() && !isVersioned) {
                return;
            }
            String oldName = (String)e2.getOldValue();
            this.myVcs.renamed(f2.getPath(), oldName);
        } else if ("writable".equals(e2.getPropertyName())) {
            if (!this.isVersioned(e2.getFile())) {
                return;
            }
            VirtualFile f3 = e2.getFile();
            if (!f3.isDirectory()) {
                this.myVcs.readOnlyStatusChanged(f3.getPath(), (Boolean)e2.getOldValue() == false);
            }
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "beforeFileMovement"));
        }
        VirtualFile f2 = e2.getFile();
        f2.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f2));
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "fileMoved"));
        }
        VirtualFile f2 = e2.getFile();
        boolean isVersioned = this.myGateway.isVersioned(f2);
        Boolean wasVersioned = (Boolean)f2.getUserData(WAS_VERSIONED_KEY);
        if (wasVersioned == null) {
            return;
        }
        f2.putUserData(WAS_VERSIONED_KEY, null);
        if (!wasVersioned.booleanValue() && !isVersioned) {
            return;
        }
        this.myVcs.moved(f2.getPath(), e2.getOldParent().getPath());
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/LocalHistoryEventDispatcher", "beforeFileDeletion"));
        }
        VirtualFile f2 = e2.getFile();
        Entry entry = this.myGateway.createEntryForDeletion(f2);
        if (entry != null) {
            this.myVcs.deleted(f2.getPath(), entry);
        }
    }

    private boolean isVersioned(VirtualFile f2) {
        return this.myGateway.isVersioned(f2);
    }

    private boolean areContentChangesVersioned(VirtualFileEvent e2) {
        return this.myGateway.areContentChangesVersioned(e2.getFile());
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/history/integration/LocalHistoryEventDispatcher", "before"));
        }
        this.myGateway.runWithVfsEventsDispatchContext(events, true, () -> {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/history/integration/LocalHistoryEventDispatcher", "lambda$before$0"));
            }
            for (VFileEvent event : events) {
                BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)((VirtualFileListener)this.myVfsEventsDispatcher.getMulticaster()), (VFileEvent)event);
            }
        });
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/history/integration/LocalHistoryEventDispatcher", "after"));
        }
        this.myGateway.runWithVfsEventsDispatchContext(events, false, () -> {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/history/integration/LocalHistoryEventDispatcher", "lambda$after$1"));
            }
            for (VFileEvent event : events) {
                BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)((VirtualFileListener)this.myVfsEventsDispatcher.getMulticaster()), (VFileEvent)event);
            }
        });
    }

    public void addVirtualFileListener(VirtualFileListener virtualFileListener, Disposable disposable) {
        this.myVfsEventsDispatcher.addListener((EventListener)virtualFileListener, disposable);
    }
}

