/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DifferenceReverter
extends Reverter {
    private final IdeaGateway myGateway;
    private final List<Difference> myDiffs;
    private final Revision myLeftRevision;

    public DifferenceReverter(Project p2, LocalHistoryFacade vcs, IdeaGateway gw, List<Difference> diffs, Revision leftRevision) {
        super(p2, vcs, gw);
        this.myGateway = gw;
        this.myDiffs = diffs;
        this.myLeftRevision = leftRevision;
    }

    @Override
    protected Revision getTargetRevision() {
        return this.myLeftRevision;
    }

    @Override
    protected List<VirtualFile> getFilesToClearROStatus() throws IOException {
        LinkedHashSet<VirtualFile> files2 = new LinkedHashSet<VirtualFile>();
        for (Difference each : this.myDiffs) {
            VirtualFile f2;
            Entry l2 = each.getLeft();
            Entry r2 = each.getRight();
            VirtualFile virtualFile = f2 = l2 == null ? null : this.myGateway.findVirtualFile(l2.getPath());
            if (f2 != null) {
                files2.add(f2);
            }
            if ((f2 = r2 == null ? null : this.myGateway.findVirtualFile(r2.getPath())) == null) continue;
            files2.add(f2);
        }
        return new ArrayList<VirtualFile>(files2);
    }

    @Override
    protected void doRevert() throws IOException {
        this.doRevert(true);
    }

    public void doRevert(boolean revertContentChanges) throws IOException {
        THashSet vetoedFiles = new THashSet();
        for (Difference each : ContainerUtil.iterateBackward(this.myDiffs)) {
            Entry l2 = each.getLeft();
            Entry r2 = each.getRight();
            if (l2 == null) {
                this.revertCreation(r2, (Set<String>)vetoedFiles);
                continue;
            }
            vetoedFiles.add(l2.getPath());
            if (r2 == null) {
                this.revertDeletion(l2);
                continue;
            }
            VirtualFile file2 = this.myGateway.findOrCreateFileSafely(r2.getPath(), r2.isDirectory());
            this.revertRename(l2, file2);
            if (!revertContentChanges) continue;
            this.revertContentChange(l2, file2);
        }
    }

    private void revertCreation(Entry r2, Set<String> vetoedFiles) throws IOException {
        String path = r2.getPath();
        for (String each : vetoedFiles) {
            if (!Paths.isParent(path, each)) continue;
            return;
        }
        VirtualFile f2 = this.myGateway.findVirtualFile(path);
        if (f2 != null) {
            f2.delete((Object)this);
        }
    }

    private void revertDeletion(Entry l2) throws IOException {
        VirtualFile f2 = this.myGateway.findOrCreateFileSafely(l2.getPath(), l2.isDirectory());
        if (l2.isDirectory()) {
            return;
        }
        this.setContent(l2, f2);
    }

    private void revertRename(Entry l2, VirtualFile file2) throws IOException {
        String oldName = l2.getName();
        if (!oldName.equals(file2.getName())) {
            VirtualFile existing = file2.getParent().findChild(oldName);
            if (existing != null) {
                existing.delete((Object)this);
            }
            file2.rename((Object)this, oldName);
        }
    }

    private void revertContentChange(Entry l2, VirtualFile file2) throws IOException {
        if (l2.isDirectory()) {
            return;
        }
        if (file2.getTimeStamp() != l2.getTimestamp()) {
            this.setContent(l2, file2);
        }
    }

    private void setContent(Entry l2, VirtualFile file2) throws IOException {
        Content c2 = l2.getContent();
        if (!c2.isAvailable()) {
            return;
        }
        file2.setBinaryContent(c2.getBytes(), -1L, l2.getTimestamp());
    }
}

