/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.LocalHistory;
import com.intellij.history.core.Content;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndoChangeRevertingVisitor
extends ChangeVisitor {
    private final IdeaGateway myGateway;
    private final Set<DelayedApply> myDelayedApplies;
    private final long myFromChangeId;
    private final long myToChangeId;
    private boolean isReverting;

    public UndoChangeRevertingVisitor(IdeaGateway gw, @NotNull Long fromChangeId, @Nullable Long toChangeId) {
        if (fromChangeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromChangeId", "com/intellij/history/integration/revertion/UndoChangeRevertingVisitor", "<init>"));
        }
        this.myDelayedApplies = new HashSet();
        this.myGateway = gw;
        this.myFromChangeId = fromChangeId;
        this.myToChangeId = toChangeId == null ? -1L : toChangeId;
    }

    protected boolean shouldRevert(Change c2) {
        if (c2.getId() == this.myFromChangeId) {
            this.isReverting = true;
        }
        return this.isReverting && !(c2 instanceof ContentChange);
    }

    protected void checkShouldStop(Change c2) throws ChangeVisitor.StopVisitingException {
        if (c2.getId() == this.myToChangeId) {
            this.stop();
        }
    }

    @Override
    public void visit(CreateEntryChange c2) throws ChangeVisitor.StopVisitingException {
        VirtualFile f2;
        if (this.shouldRevert(c2) && (f2 = this.myGateway.findVirtualFile(c2.getPath())) != null) {
            this.unregisterDelayedApplies(f2);
            try {
                f2.delete(LocalHistory.VFS_EVENT_REQUESTOR);
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        this.checkShouldStop(c2);
    }

    @Override
    public void visit(ContentChange c2) throws ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c2)) {
            try {
                VirtualFile f2 = this.myGateway.findOrCreateFileSafely(c2.getPath(), false);
                this.registerDelayedContentApply(f2, c2.getOldContent(), c2.getOldTimestamp());
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        this.checkShouldStop(c2);
    }

    @Override
    public void visit(RenameChange c2) throws ChangeVisitor.StopVisitingException {
        VirtualFile f2;
        if (this.shouldRevert(c2) && (f2 = this.myGateway.findVirtualFile(c2.getPath())) != null) {
            VirtualFile existing = f2.getParent().findChild(c2.getOldName());
            try {
                if (existing != null && !Comparing.equal((Object)existing, (Object)f2)) {
                    existing.delete(LocalHistory.VFS_EVENT_REQUESTOR);
                }
                f2.rename(LocalHistory.VFS_EVENT_REQUESTOR, c2.getOldName());
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        this.checkShouldStop(c2);
    }

    @Override
    public void visit(ROStatusChange c2) throws ChangeVisitor.StopVisitingException {
        VirtualFile f2;
        if (this.shouldRevert(c2) && (f2 = this.myGateway.findVirtualFile(c2.getPath())) != null) {
            this.registerDelayedROStatusApply(f2, c2.getOldStatus());
        }
        this.checkShouldStop(c2);
    }

    @Override
    public void visit(MoveChange c2) throws ChangeVisitor.StopVisitingException {
        VirtualFile f2;
        if (this.shouldRevert(c2) && (f2 = this.myGateway.findVirtualFile(c2.getPath())) != null) {
            try {
                VirtualFile parent = this.myGateway.findOrCreateFileSafely(c2.getOldParent(), true);
                VirtualFile existing = parent.findChild(f2.getName());
                if (existing != null) {
                    existing.delete(LocalHistory.VFS_EVENT_REQUESTOR);
                }
                f2.move(LocalHistory.VFS_EVENT_REQUESTOR, parent);
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        this.checkShouldStop(c2);
    }

    @Override
    public void visit(DeleteChange c2) throws ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c2)) {
            try {
                VirtualFile parent = this.myGateway.findOrCreateFileSafely(Paths.getParentOf(c2.getPath()), true);
                this.revertDeletion(parent, c2.getDeletedEntry());
            }
            catch (IOException e2) {
                throw new RuntimeIOException(e2);
            }
        }
        this.checkShouldStop(c2);
    }

    private void revertDeletion(VirtualFile parent, Entry e2) throws IOException {
        VirtualFile f2 = this.myGateway.findOrCreateFileSafely(parent, e2.getName(), e2.isDirectory());
        if (e2.isDirectory()) {
            for (Entry child : e2.getChildren()) {
                this.revertDeletion(f2, child);
            }
        } else {
            this.registerDelayedContentApply(f2, e2.getContent(), e2.getTimestamp());
            this.registerDelayedROStatusApply(f2, e2.isReadOnly());
        }
    }

    private void registerDelayedContentApply(VirtualFile f2, Content content2, long timestamp) {
        this.registerDelayedApply(new DelayedContentApply(f2, content2, timestamp));
    }

    private void registerDelayedROStatusApply(VirtualFile f2, boolean isReadOnly) {
        this.registerDelayedApply(new DelayedROStatusApply(f2, isReadOnly));
    }

    private void registerDelayedApply(DelayedApply a) {
        this.myDelayedApplies.remove(a);
        this.myDelayedApplies.add(a);
    }

    private void unregisterDelayedApplies(VirtualFile fileOrDir) {
        ArrayList<DelayedApply> toRemove = new ArrayList<DelayedApply>();
        for (DelayedApply a : this.myDelayedApplies) {
            if (!VfsUtil.isAncestor((VirtualFile)fileOrDir, (VirtualFile)a.getFile(), (boolean)false)) continue;
            toRemove.add(a);
        }
        for (DelayedApply a : toRemove) {
            this.myDelayedApplies.remove(a);
        }
    }

    @Override
    public void finished() {
        try {
            for (DelayedApply a : this.myDelayedApplies) {
                a.apply();
            }
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public static class RuntimeIOException
    extends RuntimeException {
        public RuntimeIOException(Throwable cause) {
            super(cause);
        }
    }

    private static class DelayedROStatusApply
    extends DelayedApply {
        private final boolean isReadOnly;

        private DelayedROStatusApply(VirtualFile f2, boolean isReadOnly) {
            super(f2);
            this.isReadOnly = isReadOnly;
        }

        @Override
        public void apply() throws IOException {
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)this.isReadOnly);
        }
    }

    private static class DelayedContentApply
    extends DelayedApply {
        private final Content myContent;
        private final long myTimestamp;

        public DelayedContentApply(VirtualFile f2, Content content2, long timestamp) {
            super(f2);
            this.myContent = content2;
            this.myTimestamp = timestamp;
        }

        @Override
        public void apply() throws IOException {
            if (!this.myContent.isAvailable()) {
                return;
            }
            boolean isReadOnly = !this.myFile.isWritable();
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)false);
            Document doc = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
            DocumentUndoProvider.startDocumentUndo(doc);
            try {
                this.myFile.setBinaryContent(this.myContent.getBytes(), -1L, this.myTimestamp);
            }
            finally {
                DocumentUndoProvider.finishDocumentUndo(doc);
            }
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)isReadOnly);
        }
    }

    private static abstract class DelayedApply {
        protected VirtualFile myFile;

        protected DelayedApply(VirtualFile f2) {
            this.myFile = f2;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public abstract void apply() throws IOException;

        public boolean equals(Object o2) {
            if (!this.getClass().equals(o2.getClass())) {
                return false;
            }
            return this.myFile.equals(((DelayedApply)o2).myFile);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 32 * this.myFile.hashCode();
        }
    }
}

