/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vcs.changes.ContentRevision;

public class DirectoryChangeModel {
    private final Difference myDiff;
    private final IdeaGateway myGateway;

    public DirectoryChangeModel(Difference d2, IdeaGateway gw) {
        this.myDiff = d2;
        this.myGateway = gw;
    }

    public Difference getDifference() {
        return this.myDiff;
    }

    public boolean isFile() {
        return this.myDiff.isFile();
    }

    public String getEntryName(int i2) {
        Entry e2 = this.getEntry(i2);
        return e2 == null ? "" : e2.getName();
    }

    public Entry getEntry(int i2) {
        return i2 == 0 ? this.myDiff.getLeft() : this.myDiff.getRight();
    }

    public boolean canShowFileDifference() {
        return this.isFile() && this.isContentVersioned();
    }

    private boolean isContentVersioned() {
        Entry e2 = this.getEntry(0);
        if (e2 == null) {
            e2 = this.getEntry(1);
        }
        return this.myGateway.areContentChangesVersioned(e2.getName());
    }

    public ContentRevision getContentRevision(int i2) {
        return i2 == 0 ? this.myDiff.getLeftContentRevision(this.myGateway) : this.myDiff.getRightContentRevision(this.myGateway);
    }
}

