/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;

public class EntireFileDifferenceModel
extends FileDifferenceModel {
    private final Entry myLeft;
    private final Entry myRight;

    public EntireFileDifferenceModel(Project p2, IdeaGateway gw, Entry left, Entry right, boolean editableRightContent) {
        super(p2, gw, editableRightContent);
        this.myLeft = left;
        this.myRight = right;
    }

    @Override
    protected Entry getLeftEntry() {
        return this.myLeft;
    }

    @Override
    protected Entry getRightEntry() {
        return this.myRight;
    }

    @Override
    protected boolean isLeftContentAvailable(RevisionProcessingProgress p2) {
        return this.myLeft.getContent().isAvailable();
    }

    @Override
    protected boolean isRightContentAvailable(RevisionProcessingProgress p2) {
        return this.myRight.getContent().isAvailable();
    }

    @Override
    protected DiffContent doGetLeftDiffContent(RevisionProcessingProgress p2) {
        return this.getDiffContent(this.myLeft);
    }

    @Override
    protected DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress p2) {
        return this.getDiffContent(this.myRight);
    }

    @Override
    protected DiffContent getEditableRightDiffContent(RevisionProcessingProgress p2) {
        Document d2 = this.getDocument();
        return DiffContentFactory.getInstance().create(this.myProject, d2);
    }

    private DocumentContent getDiffContent(Entry e2) {
        return this.createSimpleDiffContent(this.getContentOf(e2), e2);
    }

    private String getContentOf(Entry e2) {
        return e2.getContent().getString(e2, this.myGateway);
    }
}

