/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.DateFormatUtil;

public abstract class FileDifferenceModel {
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    private final boolean isRightContentCurrent;

    protected FileDifferenceModel(Project p2, IdeaGateway gw, boolean currentRightContent) {
        this.myProject = p2;
        this.myGateway = gw;
        this.isRightContentCurrent = currentRightContent;
    }

    public String getTitle() {
        Entry e2 = this.getRightEntry();
        if (e2 == null) {
            e2 = this.getLeftEntry();
        }
        return FileUtil.toSystemDependentName((String)e2.getPath());
    }

    public String getLeftTitle(RevisionProcessingProgress p2) {
        if (!this.hasLeftEntry()) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        return this.formatTitle(this.getLeftEntry(), this.isLeftContentAvailable(p2));
    }

    public String getRightTitle(RevisionProcessingProgress p2) {
        if (!this.hasRightEntry()) {
            return LocalHistoryBundle.message("file.does.not.exist", new Object[0]);
        }
        if (!this.isRightContentAvailable(p2)) {
            return this.formatTitle(this.getRightEntry(), false);
        }
        if (this.isRightContentCurrent) {
            return LocalHistoryBundle.message("current.revision", new Object[0]);
        }
        return this.formatTitle(this.getRightEntry(), true);
    }

    private String formatTitle(Entry e2, boolean isAvailable) {
        String result2 = DateFormatUtil.formatPrettyDateTime((long)e2.getTimestamp()) + " - " + e2.getName();
        if (!isAvailable) {
            result2 = result2 + " - " + LocalHistoryBundle.message("content.not.available", new Object[0]);
        }
        return result2;
    }

    protected abstract Entry getLeftEntry();

    protected abstract Entry getRightEntry();

    public DiffContent getLeftDiffContent(RevisionProcessingProgress p2) {
        if (!this.hasLeftEntry()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        if (!this.isLeftContentAvailable(p2)) {
            return DiffContentFactory.getInstance().create("Content not available");
        }
        return this.doGetLeftDiffContent(p2);
    }

    public DiffContent getRightDiffContent(RevisionProcessingProgress p2) {
        if (!this.hasRightEntry()) {
            return DiffContentFactory.getInstance().createEmpty();
        }
        if (!this.isRightContentAvailable(p2)) {
            return DiffContentFactory.getInstance().create("Content not available");
        }
        if (this.isRightContentCurrent) {
            return this.getEditableRightDiffContent(p2);
        }
        return this.getReadOnlyRightDiffContent(p2);
    }

    private boolean hasLeftEntry() {
        return this.getLeftEntry() != null;
    }

    private boolean hasRightEntry() {
        return this.getRightEntry() != null;
    }

    protected abstract boolean isLeftContentAvailable(RevisionProcessingProgress var1);

    protected abstract boolean isRightContentAvailable(RevisionProcessingProgress var1);

    protected abstract DiffContent doGetLeftDiffContent(RevisionProcessingProgress var1);

    protected abstract DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress var1);

    protected abstract DiffContent getEditableRightDiffContent(RevisionProcessingProgress var1);

    protected DocumentContent createSimpleDiffContent(String content2, Entry e2) {
        return DiffContentFactory.getInstance().create(content2, this.myGateway.getFileType(e2.getName()));
    }

    protected Document getDocument() {
        return this.myGateway.getDocument(this.getRightEntry().getPath());
    }
}

