/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.Block;
import com.intellij.history.core.Content;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class SelectionCalculator {
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);
    private final IdeaGateway myGateway;
    private final List<Revision> myRevisions;
    private final int myFromLine;
    private final int myToLine;
    private final Map<Integer, Block> myCache = new HashMap<Integer, Block>();

    public SelectionCalculator(IdeaGateway gw, List<Revision> rr, int fromLine, int toLine) {
        this.myGateway = gw;
        this.myRevisions = rr;
        this.myFromLine = fromLine;
        this.myToLine = toLine;
    }

    public boolean canCalculateFor(Revision r2, Progress p2) throws FilesTooBigForDiffException {
        try {
            this.doGetSelectionFor(r2, p2);
        }
        catch (ContentIsUnavailableException e2) {
            return false;
        }
        return true;
    }

    public Block getSelectionFor(Revision r2, Progress p2) throws FilesTooBigForDiffException {
        return this.doGetSelectionFor(r2, p2);
    }

    private Block doGetSelectionFor(Revision r2, Progress p2) throws FilesTooBigForDiffException {
        int target = this.myRevisions.indexOf(r2);
        return this.getSelectionFor(target, target + 1, p2);
    }

    private Block getSelectionFor(int revisionIndex, int totalRevisions, Progress p2) throws FilesTooBigForDiffException {
        Block result2;
        Block cached = this.myCache.get(revisionIndex);
        if (cached != null) {
            return cached;
        }
        String content2 = this.getRevisionContent(this.myRevisions.get(revisionIndex));
        p2.processed((totalRevisions - revisionIndex) * 100 / totalRevisions);
        if (content2 == null) {
            result2 = EMPTY_BLOCK;
        } else if (revisionIndex == 0) {
            result2 = new Block(content2, this.myFromLine, this.myToLine + 1);
        } else {
            Block prev = EMPTY_BLOCK;
            int i2 = revisionIndex;
            while (prev == EMPTY_BLOCK && i2 > 0) {
                prev = this.getSelectionFor(--i2, totalRevisions, p2);
            }
            result2 = prev.createPreviousBlock(content2);
        }
        this.myCache.put(revisionIndex, result2);
        return result2;
    }

    @Nullable
    private String getRevisionContent(Revision r2) {
        Entry e2 = r2.findEntry();
        if (e2 == null) {
            return null;
        }
        Content c2 = e2.getContent();
        if (!c2.isAvailable()) {
            throw new ContentIsUnavailableException();
        }
        return c2.getString(e2, this.myGateway);
    }

    private static class ContentIsUnavailableException
    extends RuntimeException {
        private ContentIsUnavailableException() {
        }
    }
}

