/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.FilesTooBigForDiffException;

public class SelectionDifferenceModel
extends FileDifferenceModel {
    private final SelectionCalculator myCalculator;
    private final Revision myLeftRevision;
    private final Revision myRightRevision;
    private final int myFrom;
    private final int myTo;

    public SelectionDifferenceModel(Project p2, IdeaGateway gw, SelectionCalculator c2, Revision left, Revision right, int from, int to, boolean editableRightContent) {
        super(p2, gw, editableRightContent);
        this.myCalculator = c2;
        this.myLeftRevision = left;
        this.myRightRevision = right;
        this.myFrom = from;
        this.myTo = to;
    }

    @Override
    protected Entry getLeftEntry() {
        return this.myLeftRevision.findEntry();
    }

    @Override
    protected Entry getRightEntry() {
        return this.myRightRevision.findEntry();
    }

    @Override
    protected boolean isLeftContentAvailable(RevisionProcessingProgress p2) {
        try {
            return this.myCalculator.canCalculateFor(this.myLeftRevision, p2);
        }
        catch (FilesTooBigForDiffException e2) {
            return false;
        }
    }

    @Override
    protected boolean isRightContentAvailable(RevisionProcessingProgress p2) {
        try {
            return this.myCalculator.canCalculateFor(this.myRightRevision, p2);
        }
        catch (FilesTooBigForDiffException e2) {
            return false;
        }
    }

    @Override
    protected DiffContent doGetLeftDiffContent(RevisionProcessingProgress p2) {
        return this.getDiffContent(this.myLeftRevision, p2);
    }

    @Override
    protected DiffContent getReadOnlyRightDiffContent(RevisionProcessingProgress p2) {
        return this.getDiffContent(this.myRightRevision, p2);
    }

    @Override
    protected DiffContent getEditableRightDiffContent(RevisionProcessingProgress p2) {
        Document d2 = this.getDocument();
        int fromOffset = d2.getLineStartOffset(this.myFrom);
        int toOffset = d2.getLineEndOffset(this.myTo);
        return DiffContentFactory.getInstance().createFragment(this.myProject, d2, new TextRange(fromOffset, toOffset));
    }

    private DocumentContent getDiffContent(Revision r2, RevisionProcessingProgress p2) {
        return this.createSimpleDiffContent(this.getContentOf(r2, p2), r2.findEntry());
    }

    private String getContentOf(Revision r2, RevisionProcessingProgress p2) {
        try {
            return this.myCalculator.getSelectionFor(r2, p2).getBlockContent();
        }
        catch (FilesTooBigForDiffException e2) {
            return "";
        }
    }
}

