/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.views.RecentChangeDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.ui.components.JBList;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class RecentChangesPopup {
    private final Project myProject;
    private final IdeaGateway myGateway;
    private final LocalHistoryFacade myVcs;

    public RecentChangesPopup(Project project2, IdeaGateway gw, LocalHistoryFacade vcs) {
        this.myProject = project2;
        this.myGateway = gw;
        this.myVcs = vcs;
    }

    public void show() {
        List<RecentChange> cc2 = this.myVcs.getRecentChanges(this.myGateway.createTransientRootEntry());
        if (cc2.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)LocalHistoryBundle.message("recent.changes.to.changes", new Object[0]), (String)this.getTitle());
            return;
        }
        JBList list2 = new JBList(this.createModel(cc2));
        list2.setSelectionMode(0);
        list2.setCellRenderer(new RecentChangesListCellRenderer());
        Runnable selectAction = () -> this.lambda$show$0((JList)list2);
        this.showList((JList)list2, selectAction);
    }

    private ListModel createModel(List<RecentChange> cc2) {
        DefaultListModel<RecentChange> m2 = new DefaultListModel<RecentChange>();
        for (RecentChange c2 : cc2) {
            m2.addElement(c2);
        }
        return m2;
    }

    private void showList(JList list2, Runnable selectAction) {
        new PopupChooserBuilder(list2).setTitle(this.getTitle()).setItemChoosenCallback(selectAction).createPopup().showCenteredInCurrentWindow(this.myProject);
    }

    private void showRecentChangeDialog(RecentChange c2) {
        new RecentChangeDialog(this.myProject, this.myGateway, c2).show();
    }

    private String getTitle() {
        return LocalHistoryBundle.message("recent.changes.popup.title", new Object[0]);
    }

    private /* synthetic */ void lambda$show$0(JList list2) {
        RecentChange c2 = (RecentChange)list2.getSelectedValue();
        this.showRecentChangeDialog(c2);
    }

    private static class RecentChangesListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myActionLabel = new JLabel("", 2);
        private final JLabel myDateLabel = new JLabel("", 4);
        private final JPanel mySpacePanel = new JPanel();

        public RecentChangesListCellRenderer() {
            this.myPanel.add((Component)this.myActionLabel, "West");
            this.myPanel.add((Component)this.myDateLabel, "East");
            this.myPanel.add((Component)this.mySpacePanel, "Center");
            Dimension d2 = new Dimension(40, this.mySpacePanel.getPreferredSize().height);
            this.mySpacePanel.setMinimumSize(d2);
            this.mySpacePanel.setMaximumSize(d2);
            this.mySpacePanel.setPreferredSize(d2);
        }

        public Component getListCellRendererComponent(JList l2, Object val, int i2, boolean isSelected, boolean cellHasFocus) {
            RecentChange c2 = (RecentChange)val;
            this.myActionLabel.setText(c2.getChangeName());
            this.myDateLabel.setText(DateFormatUtil.formatPrettyDateTime((long)c2.getTimestamp()));
            this.updateColors(isSelected);
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.setColors(bg, fg, this.myPanel, this.myActionLabel, this.myDateLabel, this.mySpacePanel);
        }

        private void setColors(Color bg, Color fg, JComponent ... cc2) {
            for (JComponent c2 : cc2) {
                c2.setBackground(bg);
                c2.setForeground(fg);
            }
        }
    }
}

