/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl;

import com.intellij.html.impl.util.MicrodataUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicrodataAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    @Override
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context2) {
        boolean goodContextForProps;
        if (!HtmlUtil.isHtml5Context((XmlElement)context2)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        String tagName2 = context2.getName();
        ArrayList<AnyXmlAttributeDescriptor> result2 = new ArrayList<AnyXmlAttributeDescriptor>();
        boolean bl = goodContextForProps = "div".equalsIgnoreCase(tagName2) || "span".equalsIgnoreCase(tagName2) || "a".equalsIgnoreCase(tagName2);
        if (goodContextForProps && MicrodataUtil.hasScopeTag(context2)) {
            result2.add(new MicrodataPropertyAttributeDescriptor(context2));
        }
        if (context2.getAttribute("itemscope") == null) {
            result2.add(new AnyXmlAttributeDescriptor("itemscope"));
        } else {
            result2.add(new XmlAttributeDescriptorWithEmptyDefaultValue("itemid"));
            result2.add(new XmlAttributeDescriptorWithEmptyDefaultValue("itemtype"));
            result2.add(new XmlAttributeDescriptorWithEmptyDefaultValue("itemref"));
        }
        return result2.toArray(new XmlAttributeDescriptor[result2.size()]);
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context2) {
        if (!HtmlUtil.isHtml5Context((XmlElement)context2)) {
            return null;
        }
        if ("itemscope".equalsIgnoreCase(attributeName)) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        if (context2.getAttribute("itemscope") != null && ("itemtype".equalsIgnoreCase(attributeName) || "itemid".equalsIgnoreCase(attributeName) || "itemref".equalsIgnoreCase(attributeName))) {
            return new XmlAttributeDescriptorWithEmptyDefaultValue(attributeName);
        }
        if ("itemprop".equalsIgnoreCase(attributeName) && MicrodataUtil.hasScopeTag(context2)) {
            return new MicrodataPropertyAttributeDescriptor(context2);
        }
        return null;
    }

    private static class MicrodataPropertyAttributeDescriptor
    extends AnyXmlAttributeDescriptor {
        @NotNull
        private final XmlTag myContext;

        public MicrodataPropertyAttributeDescriptor(@NotNull XmlTag context2) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/html/impl/MicrodataAttributeDescriptorsProvider$MicrodataPropertyAttributeDescriptor", "<init>"));
            }
            super("itemprop");
            this.myContext = context2;
        }

        @Override
        public String getDefaultValue() {
            return "";
        }

        @Override
        public boolean isEnumerated() {
            String[] enumeratedValues = this.getEnumeratedValues();
            return enumeratedValues == null ? super.isEnumerated() : enumeratedValues.length > 0;
        }

        @Override
        public String[] getEnumeratedValues() {
            XmlTag scopeParent = MicrodataUtil.findScopeTag(this.myContext);
            return scopeParent != null ? MicrodataPropertyAttributeDescriptor.findProperties(scopeParent) : super.getEnumeratedValues();
        }

        private static String[] findProperties(@NotNull XmlTag tag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/html/impl/MicrodataAttributeDescriptorsProvider$MicrodataPropertyAttributeDescriptor", "findProperties"));
            }
            XmlAttribute typeAttribute = tag.getAttribute("itemtype");
            if (typeAttribute != null) {
                XmlAttributeValue valueElement = typeAttribute.getValueElement();
                PsiReference[] references = valueElement != null ? valueElement.getReferences() : PsiReference.EMPTY_ARRAY;
                ArrayList<String> result2 = new ArrayList<String>();
                for (PsiReference reference : references) {
                    PsiElement target;
                    PsiElement psiElement = target = reference != null ? reference.resolve() : null;
                    if (!(target instanceof PsiFile)) continue;
                    result2.addAll(MicrodataUtil.extractProperties((PsiFile)target, StringUtil.stripQuotesAroundValue((String)reference.getCanonicalText())));
                }
                return ArrayUtil.toStringArray(result2);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    private static class XmlAttributeDescriptorWithEmptyDefaultValue
    extends AnyXmlAttributeDescriptor {
        public XmlAttributeDescriptorWithEmptyDefaultValue(String name) {
            super(name);
        }

        @Override
        public String getDefaultValue() {
            return "";
        }
    }
}

